clear 
close all
clc

% ������ �������� ������
Fclk = 105.912e6;
% Fclk = 106.344e6;

L2_L3_mode = true; % L2 и L3 принимаем на 1 фронтенд

NintL1 = 45;
NintL2 = NintL1*7/9;
NintL3 = 34;
NfracL1 = 0;
NfracL2 = 0;
NfracL3 = 0;

% ��������, �������� �� ����� ���� 
% ����� ������������� ������� ������� 1 ���, ����� ����� ������� �����
% ������� �� 1 ��. 
% ��� � Oryx ��������� �������� � ��������� ������ 90-110 ���
Fd = 90e6:1e3:110e6;  % ������� �������������

% ������� ��� ������� ��������� DDS'� ������� �������������
FTW = Fd / 1e9 * 2^48;

% ����������� ������ ���� ������������� � � ���������  [0�2^48-1]
ind = find(...
    (FTW == round(FTW)) ...
    & (FTW > 0) ...
    & (FTW < (2^48 - 1)) ); 
% 
% for i = 1:length(ind)
%     fprintf('Possible Fd = %.3f MHz (FTW = %.1f) \n', Fd(ind(i))/1e6, FTW(ind(i)));
% end

Fd_legal = Fd(ind); 
FTW_legal = FTW(ind);

ind_fclk = find(Fclk == Fd_legal);
if isempty(ind_fclk)
    errordlg('Bad Fclk. Check Fd_legal to choose good one.','Fclk error');
    return;
else
    FTW_clk = FTW_legal(ind_fclk);
end

fprintf('�������� ������� = %f ��\n', Fd_legal(ind_fclk));
fprintf('���������� FTW = %.1f\n', FTW_clk);

% ������� ����������
if Fclk > 96e6
    R = 3;
else
    R = 2;
end

fLO_L1 = Fclk/R*(NintL1 + NfracL1/2^24); %��������� L1
fLO_L2 = Fclk/R*(NintL2 + NfracL2/2^24); %��������� L2
fLO_L3 = Fclk/R*(NintL3 + NfracL3/2^24); %��������� L3

fprintf('������� ����������� (��)\n fLO_L1 = %.2f\n fLO_L2 = %.2f\n fLO_L3 = %.2f\n', fLO_L1, fLO_L2, fLO_L3); 

%������� ������������� ����������

f0_glnL1 = 1602e6;
f0_glnL2 = 1246e6;
f0_glnL1C = 1600.995e6;
f0_glnL2C = 1248.06e6;
f0_glnL3 = 1202.025e6;
f0_gpsL1 = 1575.42e6;
f0_gpsL2 = 1227.60e6;

fIF_glnL1 = f0_glnL1 - fLO_L1;
fIF_glnL2 = f0_glnL2 - fLO_L2;
fIF_glnL1C = f0_glnL1C - fLO_L1;
fIF_glnL2C = f0_glnL2C - fLO_L2;

if (L2_L3_mode)
    fIF_glnL3 = f0_glnL3 - fLO_L2;
else
    fIF_glnL3 = f0_glnL3 - fLO_L3;
end

fIF_gpsL1 = f0_gpsL1 - fLO_L1;
fIF_gpsL2 = f0_gpsL2 - fLO_L2;

fprintf('������������� ������� (��)\n GlnL1OF = %f\n GlnL2OF = %f\n GlnL1OC = %f\n GlnL2OC = %f\n GlnL3OC = %f\n GpsL1CA = %f\n GpsL2C  = %f\n', ...
        fIF_glnL1, fIF_glnL2, fIF_glnL1C, fIF_glnL2C, fIF_glnL3, fIF_gpsL1, fIF_gpsL2);
    

% Дополнение для визуализации частотного плана MCR
sigNames = {'L1OF', 'L1SF', 'L1OC', 'L2OF', 'L2SF', 'L2OC', 'L3OC', 'L1CA'};
IF = [fIF_glnL1; fIF_glnL1; fIF_glnL1C; fIF_glnL2; fIF_glnL2; fIF_glnL2C; 
      fIF_glnL3; fIF_gpsL1];

BW = [13*0.5625e6 + 2*0.511e6; 13*0.5625e6 + 2*5.11e6; 4.092e6;
      13*0.4375e6 + 2*0.511e6; 13*0.4375e6 + 2*5.11e6; 4.092e6;
      20.46e6; 2.046e6];

y_right = [0 1 2 0];
y_left = [0 2 1 0];

figs = 3;
titles = {'frontend L1', 'frontend L2', 'frontend L3'};
if (L2_L3_mode)
    figs = 2;
    titles = {'frontend L1', 'frontend L2+L3'};
end

for k = 1:figs
    hF(k) = figure();
end

leg0.names = {};
leg = repmat(leg0, figs, 1);

for i = 1:length(sigNames)
    x_right = [IF(i)-BW(i)/2 * [1 1] IF(i)+BW(i)/2 * [1 1]] ./ 1e6;
    x_left = [-IF(i)-BW(i)/2 * [1 1] -IF(i)+BW(i)/2 * [1 1]] ./ 1e6;
    if strfind(sigNames{i}, 'L1')
        figure(hF(1))
        patch(x_right, y_right, i, 'FaceAlpha', 0.5)
        patch(x_left, y_left, 'black', 'LineStyle', '--', 'FaceAlpha', 0.1)
        leg(1).names = [leg(1).names sigNames(i) {'mirror'}];
    elseif strfind(sigNames{i}, 'L2')
        figure(hF(2))
        patch(x_right, y_right, i, 'FaceAlpha', 0.5)
        patch(x_left, y_left, 'black', 'LineStyle', '--', 'FaceAlpha', 0.1)
        leg(2).names = [leg(2).names sigNames(i) {'mirror'}];
    elseif strfind(sigNames{i}, 'L3')
        if L2_L3_mode
            figure(hF(2))
            leg(2).names = [leg(2).names sigNames(i) {'mirror'}];
        else
            figure(hF(3))
            leg(3).names = [leg(3).names sigNames(i) {'mirror'}];
        end
            patch(x_right, y_right, i, 'FaceAlpha', 0.5)
            patch(x_left, y_left, 'black', 'LineStyle', '--', 'FaceAlpha', 0.1)
    end
end

for i = 1:figs
    figure(hF(i))
    legend(leg(i).names, 'Location', 'southeast')
    title(titles{i})
    xlabel('f, MHz')
    grid on
end
