#include <termios.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/signal.h>
#include <sys/types.h>
#include <stdlib.h>
#include <string.h>

#define BAUDRATE B9600
#define MODEMDEVICE "/dev/ttyUSB0"
#define _POSIX_SOURCE 1 /* POSIX compliant source */
#define FALSE 0                         
#define TRUE 1

volatile int STOP=FALSE;

void signal_handler_IO (int status);   /* definition of signal handler */
int wait_flag=TRUE;                    /* TRUE while no signal received */

main()
{
  int fd,c, res;
  struct termios oldtio,newtio;
  struct sigaction saio;           /* definition of signal action */
  char buf[255];

  int i;

  char str[255];                   /* Для строки NMEA */
  int str_cnt = 0;
  str[0] = 0;

  char NMEA_buf[32768];            /* Буфер для данных NMEA на 1 с */
  int NMEA_cnt = 0;
  NMEA_buf[0] = 0;


  /* open the device to be non-blocking (read will return immediatly) */
  fd = open(MODEMDEVICE, O_RDWR | O_NOCTTY | O_NONBLOCK);
  if (fd <0) {perror(MODEMDEVICE); exit(-1); }

  /* install the signal handler before making the device asynchronous */
  saio.sa_handler = signal_handler_IO;
  saio.sa_flags = SA_RESTART;
  saio.sa_restorer = NULL;
  sigaction(SIGIO,&saio,NULL);

  /* allow the process to receive SIGIO */
  fcntl(fd, F_SETOWN, getpid());

  /* Make the file descriptor asynchronous (the manual page says only
     O_APPEND and O_NONBLOCK, will work with F_SETFL...) */
  fcntl(fd, F_SETFL, FASYNC);

  tcgetattr(fd,&oldtio); /* save current port settings */
  newtio=oldtio;
  /* newtio.c_cflag = BAUDRATE | CRTSCTS | CS8 | CLOCAL | CREAD; */
  // Set something similiar to stty's RAW mode
  newtio.c_iflag &= ~(IGNBRK | BRKINT | PARMRK | ISTRIP | INLCR | IGNCR | ICRNL | IXON);
  newtio.c_oflag &= ~OPOST;
  newtio.c_lflag &= ~(ECHO | ECHONL | ICANON | ISIG | IEXTEN);
  newtio.c_cflag &= ~(CSIZE | PARENB);
  newtio.c_cflag |= BAUDRATE | CS8;
  tcsetattr(fd,TCSANOW,&newtio);

  // tcflush(fd, TCIFLUSH);  // tcflush разрушает приём данных !!! (?)
  while (read(fd, buf, 255) > 1); // Замена tcflush

  while (STOP==FALSE) {
    // printf("."); fflush(stdout);
    usleep(100000);  // <<< DO something here instead !!!

    if (wait_flag==FALSE) {
      res = read(fd,buf,255);
      buf[res]=0;
      for (i=0; i<res; i++) {
	if (buf[i] != '\n') {
	  str[str_cnt++] = buf[i];
	} else {
	  str[str_cnt++] = '\n';
	  memcpy(NMEA_buf+NMEA_cnt, str, str_cnt);
	  NMEA_cnt+= str_cnt; NMEA_buf[NMEA_cnt] = 0;
  
	  if (strncmp(str+3, "RMC", 2) == 0) {
	    printf("          New RMC arrived:\n");
	    printf("%s", NMEA_buf);
	    NMEA_cnt = 0;
	    NMEA_buf[0] = 0;
	  }

	  str_cnt = 0; str[0] = 0;
	}
      }
      /* printf("%s", buf); */
      wait_flag = TRUE;
    }
  }

  /* restore old port settings */                                            
  tcsetattr(fd,TCSANOW,&oldtio);
  printf("\n");
}                                                                            
                                                                                   
                                                                                   
void signal_handler_IO (int status)                                          
{                                                                            
  //  printf("received SIGIO signal.\n");                                        
  wait_flag = FALSE;                                                         
}   
