#include <stdio.h>
#include <stdlib.h>
#include "Packets.h"

#define FALSE 0                         
#define TRUE 1

#define BUF_SIZE 1024*8 //Shorts (2*Bytes)  // Не как в MixRead !!!

#define min(x, y) ((x)>(y) ? (y) : (x))

typedef struct {
  unsigned int sec;    // Номер секунды UTC с начала суток
  unsigned char data[MaxPacketSize];  // Массив данных NMEA
} TPack0x00;

typedef struct {
  unsigned int sec;    // Номер секунды UTC с начала суток
  unsigned int smp;    // Номер первого отсчёта в пределах секунды
  unsigned short data[BUF_SIZE];  // Буфер с сырыми данными // Здесь данные рассматриваются, как short, а в MixRead - как char
} TPack0x01;

typedef struct {
  unsigned int sec;    // Номер секунды UTC с начала суток
  unsigned int PPS_m;  // Оцифровка секунды из платы USB
} TPack0x02;


int main(void)
{
  FILE *fid1, *fid2;

  unsigned int ID;
  unsigned short cs;
  unsigned int rc;

  unsigned char data1[MaxPacketSize];
  unsigned char data2[MaxPacketSize];

  unsigned int length1;
  unsigned int length2;

  TPack0x01 *Pack0x01;
  TPack0x02 *Pack0x02;

  TPack0x01 *Pack0x01a, *Pack0x01b;

  FILE *fid;

#define File1 "/tmp/log.bin"

  fid1 = fopen(File1, "r");
  if (fid1 == NULL) {
    printf("Не могу открыть файл %s\n", File1);
    return(-1);
  }

#define File2 "/mnt/NET/HP/tmp/log.bin"
  //#define File2 "/tmp/log.bin"

  fid2 = fopen(File2, "r");
  if (fid2 == NULL) {
    printf("Не могу открыть файл %s", File2);
    return(-1);
  }

  fid = fopen("/tmp/res.txt", "w");
  if (fid == NULL) {
    printf("Не могу открыть файл /tmp/res.txt для записи");
    return(-1);
  }

  int sec1, sec2;
  int shift1=0, shift2=0;
  int s1, s2;
  int smp1, smp2;

  int do_read1 = TRUE, do_read2 = TRUE;


  int i, j;

  int dec_cnt = 0;

  while (!feof(fid1)) {
    rc = ReadNewPacket(fid1, &ID, &length1, data1, &cs);
    if ((rc == 0) & (cs == 0) & (ID == 0x02)) {
      Pack0x02 = (TPack0x02*)data1;
      sec1 = Pack0x02->sec;
      shift1 = Pack0x02->PPS_m;
      break;
    }
  }

  while (!feof(fid2)) {
    rc = ReadNewPacket(fid2, &ID, &length2, data2, &cs);
    if ((rc == 0) & (cs == 0) & (ID == 0x02)) {
      Pack0x02 = (TPack0x02*)data2;
      sec2 = Pack0x02->sec;
      shift2 = Pack0x02->PPS_m;
      break;
    }
  }

  printf("sec: %d %d\n", sec1, sec2);

  /* if (sec1 > sec2) { */
  /*   do_read2 = TRUE; */
  /*   do_read1 = FALSE; */
  /* } else if (sec2 > sec1) { */
  /*   do_read1 = TRUE; */
  /*   do_read2 = FALSE; */
  /* } else { */
  /*   do_read1 = TRUE; */
  /*   do_read2 = TRUE; */
  /* } */


  while ((!feof(fid1)) & (!feof(fid2)))  {

    if (do_read1) {
      rc = ReadNewPacket(fid1, &ID, &length1, data1, &cs);
      if ((rc == 0) & (cs == 0)) {
	//	printf("P1: ID=%d, sec=%d\n", ID, Pack0x01->sec);
	switch (ID) {
	case 0x00:
	  break;
	case 0x01:
	  Pack0x01 = (TPack0x01*)data1;
	  sec1 = Pack0x01->sec;
	  smp1 = Pack0x01->smp;
	  /* if (s1 != sec1) */
	  /*   printf("Ошибка синхронизации 1: %d %d\n", sec1, s1); */
	  break;
	case 0x02:
	  Pack0x02 = (TPack0x02*)data1;
	  /* sec1 = Pack0x02->sec; */
	  shift1 = Pack0x02->PPS_m;
	  /* printf("File1: %d %d\n", Pack0x02->sec, Pack0x02->PPS_m); */
	  printf("PPS1: %d\n", shift1);
	  break;
	}
      }
    }

    if (do_read2) {
      rc = ReadNewPacket(fid2, &ID, &length2, data2, &cs);
      if ((rc == 0) & (cs == 0)) {
	//	printf("P2: ID=%d, sec=%d\n", ID, Pack0x01->sec);
	switch (ID) {
	case 0x00:
	  break;
	case 0x01:
	  Pack0x01 = (TPack0x01*)data2;
	  sec2 = Pack0x01->sec;
	  smp2 = Pack0x01->smp;
	  /* if (s2 != sec2) */
	  /*   printf("Ошибка синхронизации 2: %d %d\n", sec2, s2); */
	  break;
	case 0x02:
	  Pack0x02 = (TPack0x02*)data2;
	  /* sec2 = Pack0x02->sec; */
	  shift2 = Pack0x02->PPS_m;
	  /* printf("File2: %d %d\n", Pack0x02->sec, Pack0x02->PPS_m); */
	  printf("PPS2: %d\n", shift2);
	  break;
	}
      }
    }

    if (sec1 > sec2) {
      do_read2 = TRUE;
      do_read1 = FALSE;
    } else if (sec2 > sec1) {
      do_read1 = TRUE;
      do_read2 = FALSE;
    } else { // sec1 == sec2
      if (smp1 > smp2) {
	do_read2 = TRUE;
	do_read1 = FALSE;
      } else if (smp2 > smp1) {
	do_read1 = TRUE;
	do_read2 = FALSE;
      } else {
	do_read1 = TRUE;
	do_read2 = TRUE;

	//	printf("PPS:  %d %d\n", shift1, shift2);

	Pack0x01a = (TPack0x01*)data1;
	Pack0x01b = (TPack0x01*)data2;
	//	for (i=0; i<min((length1-4)/2, (length2-4)/2); i++) {
	dec_cnt++;
	/* if (dec_cnt % 8 == 0) { */
	/*   for (i=0; i<2048; i++) { */
	/*     for (j=0; j<16; j++) */
	/*       fprintf(fid, "%2d %2d %d %d %d\n", -1+2*((Pack0x01a->data[i]>>j)&0x01), -1+2*((Pack0x01b->data[i]>>j)&0x01), shift1, shift2, dec_cnt/8); */
	/*   } */
	/* } */
	  for (i=0; i<2048; i++) {
	    //	    fprintf(fid, "%d %d\n", Pack0x01a->data[i], Pack0x01b->data[i]);
	    for (j=0; j<16; j++)
	      fprintf(fid, "%2d %2d %d %d %d\n", -1+2*((Pack0x01a->data[i]>>j)&0x01), -1+2*((Pack0x01b->data[i]>>j)&0x01), shift1, shift2, dec_cnt);
	  }
	//	printf("res: %d(%d) %d(%d)\n", sec1, smp1, sec2, smp2);
      }
    }

    /* rc = ReadNewPacket(fid1, &ID, &length, data, &cs); */
    /* if ((rc == 0) & (cs == 0) & (ID == 0x01)) { */
    /*   //fwrite(Pack0x01->data, 1, length-8, stdout); */
    /*   printf("File1: %d %d\n", Pack0x01->sec, Pack0x01->smp); */
    /* } */

    /* rc = ReadNewPacket(fid2, &ID, &length, data, &cs); */
    /* if ((rc == 0) & (cs == 0) & (ID == 0x01)) { */
    /*   //fwrite(Pack0x01->data, 1, length-8, stdout); */
    /*   printf("File2: %d %d\n", Pack0x01->sec, Pack0x01->smp); */
    /* } */

  }

  fclose(fid2);
  fclose(fid1);

}
