#include <termios.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/signal.h>
#include <sys/types.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <usb.h>

#include "Packets.h"

// Параметры последовательного порта
#define BAUDRATE B9600
#define MODEMDEVICE "/dev/ttyUSB0"

#define _POSIX_SOURCE 1 /* POSIX compliant source */
#define FALSE 0                         
#define TRUE 1

// Параметры Cypress
#define MY_VID 0xC0DE
#define MY_PID 0x6666
#define EP_IN 0x82
#define EP_OUT 0x04
#define BUF_SIZE 1024*16//Bytes
#define DATA_SIZE 400//MBytes
#define ONE_Mb 1//MBytes

// Буферы для чтения данных из платы
/* char tmp1[BUF_SIZE]; */

// Конфигурация Cypress
char mas [32] = {
 0xB3,0xA3,0xB0,0x2E, //CONF1 0000
 0x50,0x05,0x81,0x20, //CONF2 0001
 0xFE,0xFE,0xC2,0x1D, //CONF3 0010 
 0xC0,0x9E,0x83,0x00, //PLLCONF 0011
 0x00,0x0C,0x04,0x08, //DIV 0100
 0x00,0x80,0x05,0x07, //FDIV 0101
 0x00,0x80,0x06,0x00, //STRM 0110
 0x08,0x80,0x27,0x00  //CLK 0111
};

#define min(x, y) ((x)>(y) ? (y) : (x))

volatile int STOP=FALSE;
void signal_handler_IO (int status);   /* definition of signal handler */
int wait_flag=TRUE;                    /* TRUE while no signal received */

usb_dev_handle *open_dev(void);

typedef struct {
  unsigned int sec;    // Номер секунды UTC с начала суток
  unsigned char data[MaxPacketSize];  // Массив данных NMEA
} TPack0x00;

typedef struct {
  unsigned int sec;    // Номер секунды UTC с начала суток
  unsigned int smp;    // Номер первого отсчёта в пределах секунды
  unsigned char data[BUF_SIZE];  // Буфер с сырыми данными
} TPack0x01;

typedef struct {
  unsigned int sec;    // Номер секунды UTC с начала суток
  unsigned int PPS_m; // Оцифровка секунды из платы USB
} TPack0x02;

main()
{
  // Инициализация блока чтения NMEA из последовательного порта

  int fd,c, res;
  struct termios oldtio,newtio;
  struct sigaction saio;           /* definition of signal action */
  char buf[255];

  int i;

  char str[255];                   /* Для строки NMEA */
  int str_cnt = 0;
  str[0] = 0;

  int NMEA_cnt = 0;  // Счётчик для сбора данных NMEA

  FILE *log_fid;

  log_fid = fopen("/tmp/log.bin", "w");

  FILE *fid;
  fid = fopen("/tmp/raw.bin", "w");

  /* open the device to be non-blocking (read will return immediatly) */
  fd = open(MODEMDEVICE, O_RDWR | O_NOCTTY | O_NONBLOCK);
  if (fd <0) {perror(MODEMDEVICE); exit(-1); }

  /* install the signal handler before making the device asynchronous */
  saio.sa_handler = signal_handler_IO;
  saio.sa_flags = SA_RESTART;
  saio.sa_restorer = NULL;
  sigaction(SIGIO,&saio,NULL);

  /* allow the process to receive SIGIO */
  fcntl(fd, F_SETOWN, getpid());

  /* Make the file descriptor asynchronous (the manual page says only
     O_APPEND and O_NONBLOCK, will work with F_SETFL...) */
  fcntl(fd, F_SETFL, FASYNC);

  tcgetattr(fd,&oldtio); /* save current port settings */
  newtio=oldtio;
  /* newtio.c_cflag = BAUDRATE | CRTSCTS | CS8 | CLOCAL | CREAD; */
  // Set something similiar to stty's RAW mode
  newtio.c_iflag &= ~(IGNBRK | BRKINT | PARMRK | ISTRIP | INLCR | IGNCR | ICRNL | IXON);
  newtio.c_oflag &= ~OPOST;
  newtio.c_lflag &= ~(ECHO | ECHONL | ICANON | ISIG | IEXTEN);
  newtio.c_cflag &= ~(CSIZE | PARENB);
  newtio.c_cflag |= BAUDRATE | CS8;
  tcsetattr(fd,TCSANOW,&newtio);

  // tcflush(fd, TCIFLUSH);  // tcflush разрушает приём данных !!! (?)
  while (read(fd, buf, 255) > 1); // Замена tcflush


  // Инициализация блока чтения из Cypress
  double t;
  clock_t t1, t2;
  int k,n,m;
  int j;
  usb_dev_handle *dev = NULL; /* the device handle */

  TPack0x01 Pack0x01;      // Переменная для хранения сырых данных

  char tmp[BUF_SIZE+4];
  int PPS_cnt = 0;
  int prev = 0;
  unsigned int data_cnt = 0;

  unsigned char PPS[8] = {0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF};
  
  unsigned char PPS_mark[4];
  memset(PPS_mark, 0, 4);
  unsigned int PPS_m;

  int rc;
  int cnt = 0;

  TPack0x02 Pack0x02;      // Переменная для пакета информации об импульсе PPS

  usb_init(); /* initialize the library */
  usb_find_busses(); /* find all busses */
  usb_find_devices(); /* find all connected devices */

  if(!(dev = open_dev())) {
    printf("error: device not found!\n");
    return 0;
  }

  if(usb_set_configuration(dev, 1) < 0) {
    printf("error: setting config 1 failed\n");
    usb_close(dev);
    return 0;
  }

  if(usb_claim_interface(dev, 0) < 0) {
    printf("error: claiming interface 0 failed\n");
    usb_close(dev);
    return 0;
  }

  //---пустое-чтение,-чтобы-прочистить-буфера-------------
  // будем читать 1Мб
  m = ONE_Mb*1024*1024/(BUF_SIZE);
  for (n=1;n<=m;n++)
      usb_bulk_read(dev, EP_IN, tmp, BUF_SIZE, 500);

  printf("Transmittion started\n");

  // Инициализация декодера NMEA
  char *token;
  char cnv[7];
  int hour, min;
  float sec;
  double time;
  unsigned int nmea_sec = 100000;
  unsigned int cur_sec = 100000;

  TPack0x00 Pack0x00; // Переменная для хранения данных NMEA

  int last_cnt = 0;

  // Цикл чтения
  t1 = clock();
  n = 1;
  while (STOP==FALSE) {

    // Чтение из Cypress
    rc = usb_bulk_read(dev, EP_IN, tmp+8, BUF_SIZE, 500); 
    printf("%.3f Mb\r",(n*BUF_SIZE/1048576.0));//1048576=1MByte
    n++;

    fwrite(tmp+8, 1, rc, fid);

    for (i=((prev==1)?0:8); i<min(BUF_SIZE, rc); i++) {
      if (memcmp(tmp+i, PPS, 8) == 0) {
    	printf("          PPS found: %d\n", cur_sec);
    	PPS_cnt = 0;

    	if (cur_sec != 100000) {
    	  Pack0x01.sec = cur_sec;
    	  Pack0x01.smp = cnt;          // Счётчик отсчётов
    	  cnt = 0;

	  last_cnt = (data_cnt-14342)*80 + 160; // Пока так!!!

    	  WriteNewPacket(log_fid, 0x01, data_cnt+8, (unsigned char*)(&Pack0x01));
    	}
	cur_sec = nmea_sec;                // Новая секунда из NMEA выдаётся только после прихода секундной метки
    	data_cnt = 0;

      } else if ((PPS_cnt >= 8) & (PPS_cnt < 8+4)) {

    	PPS_mark[PPS_cnt-8] = tmp[i];

      } else if (PPS_cnt >= 8+4) {

	if (PPS_cnt == 8+4) {
	  PPS_m = *((unsigned int*)(PPS_mark));
	  printf("PPS: %d\n", PPS_m);
	  Pack0x02.sec = cur_sec;
	  Pack0x02.PPS_m = PPS_m + last_cnt*0;
	  if (cur_sec != 100000)
	    WriteNewPacket(log_fid, 0x02, sizeof(TPack0x02), (unsigned char*)(&Pack0x02));
	}

    	Pack0x01.data[data_cnt] = tmp[i];
    	data_cnt++;

    	if (data_cnt >= BUF_SIZE) {
    	  if (cur_sec != 100000) {
    	    Pack0x01.sec = cur_sec;
    	    Pack0x01.smp = cnt;
    	    cnt += BUF_SIZE*8;       // Счётчик отсчётов за последнюю секунду

	    //	    if ((cnt < 1500000) | (cnt > 2500000)) // Это искуственно вызванная проблема для отладки синхронизации
    	    WriteNewPacket(log_fid, 0x01, BUF_SIZE+8, (unsigned char*)(&Pack0x01));
     	  }
    	  data_cnt = 0;
    	}
      }

      PPS_cnt++;
    }
    for (i=0; i<8; i++)
      tmp[i] = tmp[BUF_SIZE+i];
    prev = 1;
    

    // Чтение из последовательного порта
    if (wait_flag==FALSE) {
      res = read(fd,buf,255);
      buf[res]=0;
      for (i=0; i<res; i++) {
    	if (buf[i] != '\n') {
    	  str[str_cnt++] = buf[i];
    	} else {
    	  str[str_cnt++] = '\n';
    	  memcpy(Pack0x00.data+NMEA_cnt, str, str_cnt);
    	  NMEA_cnt+= str_cnt; Pack0x00.data[NMEA_cnt] = 0;
  
    	  if (strncmp(str+3, "RMC", 2) == 0) {
    	    printf("          A new RMC has arrived:\n");
    	    printf("%s", Pack0x00.data);
	 
    	    token = strtok(str, ",");
    	    token = strtok(NULL, ",");
    	    cnv[0]=token[0]; cnv[1]=token[1]; cnv[2]=0; sscanf(cnv, "%02d", &hour);
    	    cnv[0]=token[2]; cnv[1]=token[3]; cnv[2]=0; sscanf(cnv, "%02d", &min);
    	    sscanf(token+4, "%f", &sec);
    	    time = 3600*hour + 60*min + sec;
    	    token = strtok(NULL, ",");
   
    	    if (token[0] == 'A')
    	      nmea_sec = (unsigned int)time;
    	    else
    	      nmea_sec = 100000; // Пришёл признак неправильного решения

    	    Pack0x00.sec = nmea_sec;
    	    WriteNewPacket(log_fid, 0x00, NMEA_cnt+4, (unsigned char*)(&Pack0x00));
    	    fflush(log_fid);

    	    NMEA_cnt = 0;
    	    Pack0x00.data[0] = 0;
    	  }

    	  str_cnt = 0; str[0] = 0;
    	}
      }
      /* printf("%s", buf); */
      wait_flag = TRUE;
    }
  }

  t2 = clock();
  t = (double)(t2-t1)/CLOCKS_PER_SEC;
  printf("\n\n-----SPEED-----\n");
  //printf(" %.2f Mb/sec\n",DATA_SIZE/t);

  usb_release_interface(dev, 0);
  usb_close(dev);
  /* fclose(fp); */


  /* restore old port settings */                                            
  tcsetattr(fd,TCSANOW,&oldtio);
  printf("\n");

  fclose(log_fid);

  fclose(fid);

}                                                                            
                                                                                   
                                                                                   
void signal_handler_IO (int status)                                          
{                                                                            
  //  printf("received SIGIO signal.\n");                                        
  wait_flag = FALSE;                                                         
}   

usb_dev_handle *open_dev(void)
{
  struct usb_bus *bus;
  struct usb_device *dev;

  for(bus = usb_get_busses(); bus; bus = bus->next) 
    {
      for(dev = bus->devices; dev; dev = dev->next) 
        {
          if(dev->descriptor.idVendor == MY_VID
             && dev->descriptor.idProduct == MY_PID)
            {
              return usb_open(dev);
            }
        }
    }
  return NULL;
}
