clear;

%%%%%%%%%%%%%%%%%%%   %%%%%%%%%%%%%%%%%%%
NS = 4;                %   

Rz = 6371.3e3;         %  
LightC = 299792458;    %  

%  
fd = 16.369e6;         %  
Td = 1/fd;
fi = fd/4;             %  

%   
N = 13000;

%   
T = 1e-3;
Nd = fix(T/Td);

%   
TPSP = 1e-3;
PNSize = 1023;
Tpn = TPSP / PNSize;

%  
ULat = 55;        % 
ULon = 37;        % 
UH   = 100;               % 
UX = lla2ecef([ULat ULon UH]);      %  

%  
TLEname = 'gps-ops.txt';       %   
tle = readTLE(TLEname);

%         
ep = decodeTLE(tle);
tstart = timeSinceEpoch(ep{1}.epochyr, ep{1}.epochdays); %    

%   
Sats = zeros(3, length(tle));
for i=1:length(tle)
    ep = decodeTLE(tle);
    [SatX, SatV] = getSatPos(tstart, ep{i});
    Sats(:, i) = SatX;
end
SatList = getConstellation(NS, ULat, ULon, UH, Sats);
NS = length(SatList);

% 
t_rcv = tstart;           %  

%    
hf = figure(1);
hEarth = subplot(3, 2, 1);           %    
hY     = subplot(3, 2, 2);           %   
hIQ    = subplot(3, 2, 3);           %     
hData  = subplot(3, 2, 4);           %   
hSky   = subplot(3, 2, 5);           % SkyPlot
hSol   = subplot(3, 2, 6);           %    

%       
Sats = zeros(3, NS);
for i=1:NS
    [SatX, SatV] = getSatPos(tstart, ep{SatList(i)});  %   
    Sats(:, i) = SatX;
end
showEarth(hEarth, UX, Sats);          %  

%   
[El, Az] = getElAz(Sats, ULat/180*pi, ULon/180*pi, UH);
polar(hSky, Az, pi/2-El, '*')

%    
initSgnParams

%  
initCorr

%  ,  
initCPU

%   
initAcqParams

%   
initFllParams

%   
initPllParams

%    
initSymParams

%    
initFrameParams

%   
FrontEndParams.fi = fi;    %  
FrontEndParams.fd = fd;
FrontEndParams.BW = 8e6;
FrontEndParams = initFrontEnd(FrontEndParams);

%     
initOutData



%%%%%%%%%%%%%%%%%%%%%%     %%%%%%%%%%%%%%%%%%
tic
for iT=1:N   
    if mod(iT, 100)==0
        fprintf('%d / %d  (%g c)\n', iT, N, toc/(iT-1)*(N-iT+1));
    end
    
    %%%%%%%%%%%      %%%%%%%%%%%
    s = zeros(1, Nd);
    for ch=1:NS
        %    i
        SatX = zeros(3, 1);
        for j=1:3
            SatX(j) = polyval(SgnParams{ch}.SXA(j, :), T*(iT-1));
        end

        % [SatX, SV] = getSatPos(tstart + T*(iT-1), SgnParams{ch}.ep);
        
        range = getRange(UX, SatX);
        
        %  
        SgnParams{ch}.tau = range/LightC;
        [s2, t_rcv2, SgnParams{ch}] = makeSignal(t_rcv, Nd, SgnParams{ch});
        
        s = s + s2;  %       
    end
    t_rcv = t_rcv2;

   
    %%%%%%%%%%%   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    [y, FrontEndParams] = FrontEnd(s, FrontEndParams);

    %    
    if mod(iT, 30) == 0
        plot(hY, y(1:300))
        drawnow
    end
    
    
    %%%%%%%%%%  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    for ch=1:NS
        %   
        [CorrRegs{ch}, CorrParams{ch}] = correlator(y, CorrRegs{ch}, CorrParams{ch});
    end

    %%%%%%%%%%      %%%%%%%%%%%%%%%%
    for ch=1:NS
        %   
        CPU{ch}.CntM = CPU{ch}.CntM + 1;
        switch CPU{ch}.state
          case 1  % 
            [detected, CorrRegs{ch}, AcqParams{ch}] = acq(CorrRegs{ch}, AcqParams{ch});
            
            if detected
                CPU{ch}.state = 2;  CPU{ch}.CntM = 1;
            end
          case 2  %  
            [CorrRegs{ch}, FllParams{ch}] = FllDll(CorrRegs{ch}, FllParams{ch});

            if CPU{ch}.CntM > 100
                CPU{ch}.state = 3;   CPU{ch}.CntM = 1;
                
                %    
                PllParams{ch}.xp(2) = 2*pi*CorrRegs{ch}.freq;
            end
          case 3  %  
            [CorrRegs{ch}, PllParams{ch}] = PllDll(CorrRegs{ch}, PllParams{ch});
        end

        %    
        if CPU{ch}.state == 3  %     
            [syncDone, II, ephI, SymParams{ch}] = SymSync(CorrRegs{ch}, SymParams{ch});
            if syncDone & (length(II) > 0)
                [new_frame, frame, FrameParams{ch}, RR(iT)] = FrameSync(II, ephI, FrameParams{ch});
                if new_frame == 1
                    TLE = cell(0);
                    [t, TLE{1}, CS] = decodeMsg(frame);
                    fprintf('new_frame %g %g %d\n', t, CorrRegs{ch}.tsgnI, CS);
                    CPU{ch}.tle = TLE;
                    CPU{ch}.eph = decodeTLE(CPU{ch}.tle);
                    CPU{ch}.haveEph = 1;
                    OutData{ch}.rcv_msg = frame;
                end
            end
        end
        
        %  
        OutData{ch}.PR(iT) = (t_rcv - CorrRegs{ch}.tsgn)*LightC;
        
        %      
        OutData{ch}.tau(iT)  = CorrRegs{ch}.tau;
        OutData{ch}.freq(iT) = CorrRegs{ch}.freq;
        OutData{ch}.phi(iT)  = CorrRegs{ch}.phi;

        OutData{ch}.tau0(iT)  = SgnParams{ch}.tau;
        OutData{ch}.freq0(iT) = SgnParams{ch}.freq;
        
        OutData{ch}.eph(iT)  = CorrRegs{ch}.epoch;
        OutData{ch}.I(iT)    = CorrRegs{ch}.I;   OutData{ch}.Q(iT)  = CorrRegs{ch}.Q;
        OutData{ch}.Ie(iT)   = CorrRegs{ch}.Ie;  OutData{ch}.Qe(iT) = CorrRegs{ch}.Qe;
        OutData{ch}.Il(iT)   = CorrRegs{ch}.Il;  OutData{ch}.Ql(iT) = CorrRegs{ch}.Ql;
        OutData{ch}.R(iT) = sqrt(OutData{ch}.I(iT)^2+OutData{ch}.Q(iT)^2);    
    end
    
    
    ch = 1;
    if mod(iT, 30) == 0
        %     
        NIQ = min(200, iT);
        plot(hIQ, [OutData{ch}.I(iT-NIQ+1:iT); OutData{ch}.Q(iT-NIQ+1:iT); OutData{ch}.RR(iT-NIQ+1:iT)]')
        
        %    
        if length(OutData{ch}.rcv_msg) > 0
            plot(hData, [SgnParams{ch}.Data(NPR+1:end); OutData{ch}.rcv_msg(NPR+1:end)+2.1]')
        end
    end

    
    %%%%%%%%%%%%%%%%%     %%%%%%%%%%%%%%%%%%%%%%%%
    PR = zeros(1, 0);
    SatPos = zeros(4, 0);
    InitPos = [UX'; 0];

    Sats = 0;
    for ch=1:NS
        if CPU{ch}.haveEph == 1 %     
            Sats = Sats + 1;
        end
    end
    
    if (Sats >= 4) & (mod(iT, 100)==0)
        Sats = 0;
        for ch=1:NS
            %            if CPU{ch}.state == 3
            if CPU{ch}.haveEph == 1
                Sats = Sats + 1;
                PR(Sats) = OutData{ch}.PR(iT);
                
                %                [SX, SV] = getSatPos(tstart+(iT-1)*T, SgnParams{ch}.ep);
                [SX, SV] = getSatPos(tstart+(iT-1)*T, CPU{ch}.eph{1});
                SatPos(1:3, Sats) = SX;
            end
        end    
        Pos = NavSol(InitPos, SatPos, PR);
        EstX(:, iT) = Pos(1:3);
        LLA = ecef2lla(Pos(1:3)');      Lat(iT) = LLA(1); Lon(iT) = LLA(2); H(iT) = LLA(3);
        errX(iT) = getRange(UX, Pos(1:3)');
        
        %   
        ind = find(Lat ~= 0);
        plot(hSol, Lat(ind), Lon(ind));
    end
end

