clear;

global Td Nd fi T
global Tpn PNSize TPSP


fd = 16.369e6;
Td = 1/fd;

T = 1e-3;
Nd = fix(T/Td);

N = 13000;%2*PNSize;

t = 0;  %      
t_rcv = 0;                     %   

TPSP = 1e-3;
PNSize = 1023;
PN = sign(randn(1, PNSize));
Tpn = TPSP / PNSize;

fi = fd/4;

%    
Res = zeros(1, N);
I  = zeros(1, N); Q  = zeros(1, N);
Ie = zeros(1, N); Qe = zeros(1, N);
Il = zeros(1, N); Ql = zeros(1, N);
R  = zeros(1, N);

Udt  = zeros(1, N); 
Udf  = zeros(1, N);
Udp  = zeros(1, N); 

eph   = zeros(1, N);
tau   = zeros(1, N);
freq  = zeros(1, N);
phi   = zeros(1, N);

tau0  = zeros(1, N);
freq0 = zeros(1, N);

%   
tau0 = 0.13e-3;
freq0 = 765;
phi0 = 2*pi*rand(1, 1);

%   
tau(1) = tau0+Tpn*5;
freq(1) = freq0 - 250;
phi(1) = 2*pi*rand(1, 1);

q = 10^(55/10);
A = sqrt(4*q*Td);



%  
state = 1;  % 
% state = 2;  %  
% state = 3;  %  

CntM = 1;

% 
TLEname = 'gps-ops.txt';       %   
tle = readTLE(TLEname);

msg = TLE2msg(tle{1});

NF = 1200;
NT = 25; %     
NE = 5;
pream = [ -1     1    -1     1     1     1    -1     1    -1    -1    -1    -1    -1 ...
           1    -1     1    -1     1     1    -1     1     1    -1    -1     1    -1 ...
          -1     1     1     1     1     1    -1    -1    -1     1     1    -1    -1 ...
          -1     1    -1     1    -1     1    -1     1    -1     1     1    -1    -1 ...
           1     1     1     1     1     1     1    -1    -1     1     1];
NPR = length(pream);
Data = [pream zeros(1, NT) msg zeros(1, 8)];
TD = NE*TPSP;

%    
SgnParams.Td     = Td;
SgnParams.fi     = fi;
SgnParams.T      = T;
SgnParams.Tpn    = Tpn;
SgnParams.PNSize = PNSize;
SgnParams.TPSP   = TPSP;
SgnParams.TD     = TD;
SgnParams.NF     = NF;
SgnParams.NPR    = NPR;
SgnParams.NT     = NT;
SgnParams.PN     = PN;
SgnParams.Data   = Data;
                         
SgnParams.tau    = tau0;
SgnParams.freq   = freq(1);
SgnParams.phi    = phi(1);
SgnParams.A      = A;

%  
CorrParams.Td     = Td;
CorrParams.Nd     = Nd;
CorrParams.fi     = fi;
CorrParams.T      = T;
CorrParams.Tpn    = Tpn;
CorrParams.PNSize = PNSize;
CorrParams.TPSP   = TPSP;
CorrParams.PN     = PN;

CorrRegs.tsgn     = t(1) - tau(1) + 20;
CorrRegs.tau      = tau(1);   CorrRegs.tau_prev  = CorrRegs.tau;
CorrRegs.dtau     = 0;
CorrRegs.freq     = freq(1);  CorrRegs.freq_prev = CorrRegs.freq;
CorrRegs.phi      = phi(1);   CorrRegs.phi_prev  = CorrRegs.phi - 2*pi*CorrRegs.freq*T;
CorrRegs.I        = 0;   CorrRegs.INext = 0;
CorrRegs.Q        = 0;   CorrRegs.QNext = 0;
CorrRegs.Ie       = 0;   CorrRegs.IeNext = 0;
CorrRegs.Qe       = 0;   CorrRegs.QeNext = 0;
CorrRegs.Il       = 0;   CorrRegs.IlNext = 0;
CorrRegs.Ql       = 0;   CorrRegs.QlNext = 0;

%   
AcqParams.Tpn     = Tpn;
AcqParams.Thr     = 500;

%   
FllParams.Tpn     = Tpn;

%   
PllParams.T       = T;
PllParams.Tpn     = Tpn;
PllParams.xp      = zeros(2, 1);
PllParams.phi_p   = 0;


%    
SymParams.NE    = NE;   %    
SymParams.accI  = zeros(1, SymParams.NE);
SymParams.accR  = zeros(1, SymParams.NE);
SymParams.PrevShift = 1;
SymParams.PrevChange = 100;
SymParams.syncDone = 0;
SymParams.N     = 100; %      

%    
FrameParams.pream = pream;
FrameParams.II = [];
FrameParams.epoch = 0;
FrameParams.NF    = NF;  %    
FrameParams.syncDone = 0;

yy = [];
rcv_msg = [];

Nd = Nd + 1;

tic

RR = zeros(1, N);

for iT=2:N
    if mod(iT, 100)==0
        fprintf('%d / %d  (%g c)\n', iT, N, toc/(iT-1)*(N-iT+1));
        state
    end
    
    %  
    [s, t_rcv, SgnParams] = makeSignal(t_rcv, Nd, SgnParams);

    %  
    y = s + randn(1, Nd);
    
    %  
    [CorrRegs, CorrParams] = correlator(y, CorrRegs, CorrParams);
    
    CntM = CntM + 1;
    %   
    switch state
      case 1  % 
        [detected, CorrRegs, AcqParams] = acq(t, CorrRegs, AcqParams);
        
        if detected
            state = 2;  CntM = 1;
        end
      case 2  %  
        [CorrRegs, FllParams] = FllDll(t, CorrRegs, FllParams);

        if CntM > 100
           state = 3;   CntM = 1;
           
           %    
           PllParams.xp(2) = 2*pi*CorrRegs.freq;
        end
      case 3  %  
        [CorrRegs, PllParams] = PllDll(t, CorrRegs, PllParams);
    end

    %    
    if state == 3  %     
        [syncDone, II, ephI, SymParams] = SymSync(t, CorrRegs, SymParams);
        if syncDone & (length(II) > 0)
            [new_frame, frame, FrameParams, RR(iT)] = FrameSync(t, II, ephI, FrameParams);
            if new_frame
                fprintf('new_frame %d  %d\n', ephI, length(frame));
                rcv_msg = frame;
            end
        end
    end
    
    %      
    tau(iT)  = CorrRegs.tau;
    freq(iT) = CorrRegs.freq;
    phi(iT)  = CorrRegs.phi;

    tau0(iT)  = SgnParams.tau;
    freq0(iT) = SgnParams.freq;
    
    eph(iT)  = CorrRegs.epoch;
    I(iT)    = CorrRegs.I;   Q(iT)  = CorrRegs.Q;
    Ie(iT)   = CorrRegs.Ie;  Qe(iT) = CorrRegs.Qe;
    Il(iT)   = CorrRegs.Il;  Ql(iT) = CorrRegs.Ql;
    R(iT) = sqrt(I(iT)^2+Q(iT)^2);    
end


%plot(Udf);
%plot([I; Ie; Il]')
figure(1);
plot([I; Q]')
grid on

figure(2);
plot([SgnParams.Data(NPR+1:end); rcv_msg+2.1]')
grid on
