clear;

%filename = 'SGP4-VER.TLE';
filename = '/tmp/gps-ops.txt';

sys       = 84;   % WGS84
typerun   = 'c';
typeinput = 'e';

fid = fopen(filename, 'r');
if fid==-1
    fprintf('can''t open file %s\n', filename);
    return;
end

NS = 0;

while (~feof(fid))
    str1 = fgets(fid, 130);
    while ( (str1(1)~='1') && (feof(fid)==0) )
        str1 = fgets(fid, 130);
    end
    
    if (feof(fid) == 0)
        str2 = fgets(fid, 130);

        NS = NS + 1;
        [satrec, startmfe, stopmfe, deltamin] = twoline2rv(sys, str1, str2, typerun, typeinput);
        
        ephemeris(NS) = satrec;
    end
end

earth

%tim=startmfe:1:stopmfe;
tim = 0:60:24*3600;

for sat=1:NS
    sat
    for iT=1:length(tim)
        t=tim(iT);
        [satrec, ro ,vo] = sgp4 (ephemeris(sat),  t/60);
        
        X(iT, :) = ro*1e3;
        V(iT, :) = vo*1e3;
    end
    plot3(X(:, 1), X(:, 2), X(:, 3), 'LineWidth', 1)
    drawnow
end    
axis equal

