namespace eval VgProgram {
    namespace eval programmer {
        namespace import ::Vg::LogLine;
        variable filenamelist "";
        
        proc add2list {var args} {
	    upvar $var tmp
	    append tmp_filename $Vg::PACKFILEDIR $Vg::default_pak_filename

	    foreach arg $args {
		if {[file pathtype $arg] ne "absolute"} {
		    set arg [file join [file dirname $tmp_filename] $arg];
		}
		lappend tmp $arg
	    }
        }
    }
}

proc VgProgram::create { nb } {
    set frame [$nb insert end VgProgram -text "Program"]
    set titf [LabelFrame  $frame.titf];   

    _gctl [$titf getframe]
    
    pack $titf -padx 4 -pady 4 -fill both -anchor center;      

    return $frame
}
proc VgProgram::_gctl { root } {
    # this handles '.' as a special case
    set base [expr {($root == ".") ? "" : $root}]
    variable ROOT $root
    variable BASE $base
    variable SCRIPTDIR ; # defined in main script


    # Widget Initialization
    variable _labelframe_conf_data [labelframe $BASE._labelframe_conf_data \
	    -text "Configuration"]
    variable _labelframe_data [labelframe $BASE._labelframe_data \
	    -text "Data"]
    variable _labelframe_all_data [labelframe $BASE._labelframe_all_data \
	    -text ""]
    variable _labelframe_check [labelframe $BASE._labelframe_check \
	    -text ""]
    variable _frame_conf_data1 [frame $BASE._frame_conf_data1]
    variable _frame_conf_data2 [frame $BASE._frame_conf_data2]
    variable _frame_conf_data3 [frame $BASE._frame_conf_data3]
    variable _frame_conf_data4 [frame $BASE._frame_conf_data4]
    variable _frame_data1 [frame $BASE._frame_data1]
    variable _frame_data2 [frame $BASE._frame_data2]
    variable _frame_data3 [frame $BASE._frame_data3]
    variable _frame_data4 [frame $BASE._frame_data4]
    
    variable _frame_all_data1 [frame $BASE._frame_all_data1]
    variable _frame_all_data2 [frame $BASE._frame_all_data2]    
    variable _frame_all_data3 [frame $BASE._frame_all_data3]
    variable _frame_all_data4 [frame $BASE._frame_all_data4]
    
    variable _entry_conf_file [entry $BASE._entry_conf_file \
	    -textvariable Vg::program_conf_save_filename \
	    -justify right \
	    -width 0 ]
    variable _entry_data_file [entry $BASE._entry_data_file \
	    -textvariable Vg::default_program_data_filename \
	    -justify right \
	    -width 0 ]
    variable _label_conf_data [label $BASE._label_conf_data \
	    -text "Configuration file:"]
    variable _label_data [label $BASE._label_2 \
	    -text "Data file:"]

    variable _button_conf_erase [button $BASE._button_conf_erase \
	    -command "VgProgram::button_conf_erase" \
	    -text "Conf Erase" \
	    -width 8]   

    variable _button_conf_select [button $BASE._button_conf_select \
	    -command "VgProgram::button_conf_select" \
	    -text "Select" \
	    -width 8]
    
    variable _button_conf_save [button $BASE._button_conf_save \
	    -command "VgProgram::button_conf_save" \
	    -text "Conf save" \
	    -state disable \
	    -width 8]
    
    variable _button_data_erase [button $BASE._button_data_erase \
	    -command "VgProgram::button_data_erase" \
	    -text "Data Erase" \
	    -width 8]   

    variable _button_data_select [button $BASE._button_data_select \
	    -command "VgProgram::button_data_select" \
	    -text "Select" \
	    -width 8]
    
    variable _button_data_save [button $BASE._button_data_save \
	    -command "VgProgram::button_data_save" \
	    -text "Data save" \
	    -state normal \
	    -width 8]
    variable _button_data_view [button $BASE._button_data_view \
	    -command "VgProgram::button_data_view" \
	    -text "Data view" \
	    -state disable \
	    -width 8]
    variable _button_data_read [button $BASE._button_data_read \
	    -command "VgProgram::button_data_read" \
	    -text "Data Read" \
	    -width 8]
    variable _button_all_erase [button $BASE._button_all_erase \
	    -command "VgProgram::button_all_erase" \
	    -text "All erase" \
	    -width 8] 

    variable _button_all_save [button $BASE._button_all_save \
	    -command "VgProgram::button_all_save" \
	    -text "All save" \
	    -width 8]    
    
    variable _button_check [button $BASE._button_check \
	    -command "VgProgram::button_all_check" \
	    -text "All check" \
	    -width 8]

    variable _checkbutton_erase_before [checkbutton $BASE._checkbutton_erase_before \
	    -text "Erase before programming" \
	    -state disable \
	    -variable "Vg::erase_before_program"]

    variable _checkbutton_check_after [checkbutton $BASE._checkbutton_check_after \
	    -text "Check after programming" \
	    -state disable \
	    -variable "Vg::check_after_program"]
    
    # Pack Management
    pack $_labelframe_conf_data $_labelframe_data $_labelframe_all_data $_labelframe_check -fill x -in $root
    pack configure $_labelframe_all_data -pady "5 5"   
    pack $_frame_conf_data1 $_frame_conf_data2 $_frame_conf_data3 $_frame_conf_data4 -fill x -in $_labelframe_conf_data
#    pack $_frame_outfile2 -anchor "e" -pady "5"
#    pack $_frame_outfile3 -anchor "e" -pady "5"

    pack $_frame_data1 $_frame_data2 $_frame_data3  $_frame_data4 -fill x -in $_labelframe_data
    pack $_frame_all_data1 $_frame_all_data2 -fill x -in $_labelframe_all_data     
    pack $_frame_all_data3 $_frame_all_data4 -side left -fill x -expand 1 -pady "10 10" -in $_frame_all_data2 

    pack $_button_conf_erase -in $base._frame_conf_data1 -side right -padx 10
    pack $_label_conf_data -in $base._frame_conf_data2 -side left -padx 10
    pack $_button_conf_select $_entry_conf_file -in $base._frame_conf_data3 -side right
    pack configure $_button_conf_select -padx "5 10"
    pack configure $_entry_conf_file -fill x -expand 1 -padx "5 0"
    pack $_button_conf_save -in $base._frame_conf_data4 -pady 10

    pack $_button_data_erase -in $base._frame_data1 -side right -padx 10
    pack $_label_data -in $base._frame_data2 -side left -padx 10
    pack $_button_data_select $_entry_data_file -in $base._frame_data3 -side right
    pack configure $_button_data_select -padx "5 10"
    pack configure $_entry_data_file -fill x -expand 1 -padx "5 0"
    pack $_button_data_save $_button_data_view $_button_data_read -in $base._frame_data4
    pack configure $_button_data_save -pady "10 10"
    pack configure $_button_data_view -pady "0 10"
    pack configure $_button_data_read -pady "0 10"
    
    pack $_checkbutton_erase_before $_checkbutton_check_after -anchor w -in $_frame_all_data1    
    pack $_button_all_erase -in $_frame_all_data3
    pack $_button_all_save -in $_frame_all_data4

    pack $_button_check -in $_labelframe_check -pady 10
    
}

proc VgProgram::button_conf_select {} {
    Vg::LogLine "Nothing to do!"
}
proc VgProgram::button_conf_save {} {
    variable serial;
    variable filename "";
    append filename $Vg::PROGRAM_CONFFILEDIR $Vg::program_conf_save_filename
    
    if {[Vg::open_serial serial]} then {return 1}
    if {[Vg::PageErase $serial 0]} then {Vg::LogLine "Vg::PageErase -> error"; close $serial; return 1}
    close $serial
    
#    Vg::CreateConfigFile $filename
    Vg::LoadFile2Flash $filename    
    Vg::LogLine "Save data to configuration block succesfully"
}

proc VgProgram::button_data_select {} {
    variable tmp_initfile "";
    set types {{{AVD2 pak file} {.pak}}}
    
    if {[set filename [tk_getOpenFile -initialdir $Vg::DATAFILEDIR -initialfile $Vg::program_data_filename -filetypes $types]] ne ""} {
	regexp {.*(/)} "$filename"  Vg::DATAFILEDIR
	regexp -all {/(\w*)} "$filename"  -> Vg::default_program_data_filename
	regexp -all {\w*} $filename  extansion
	append Vg::default_program_data_filename "." $extansion
	set Vg::program_data_filename $filename
#        set Vg::program_data_filename $Vg::default_pak_filename
	Vg::LogLine "Select file : $filename"        
    }
}

proc VgProgram::button_data_save { } {
    global MAX_ADR_CONFIG_BLOCK
    variable data_block;
    set filename $Vg::program_data_filename
    set appendix ".\\_data\\"
    if {[VgFile::GetFileList filename_list $filename $appendix]} {return 1}
#    Vg::LogLine "filename_list: $filename_list"
#    set filename_list "";
#    lappend filename_list ".\\_data\\cal_hmc370.dat" ".\\_data\\cal_hmc470.dat"
#    lappend filename_list ".\\_data\\cal_rfinatt_att.dat" ".\\_data\\cal_rfinlna_att.dat"
#    lappend filename_list ".\\_data\\cal_rfinatt_gain.dat" ".\\_data\\cal_rfinlna_gain.dat"
#    lappend filename_list ".\\_data\\cal_gain.dat" ".\\_data\\cal_det.dat"
    set data_block [VgFile::FormDataBlock $filename_list]
    set data_block [VgFile::FixBlockSize $data_block]
    
    set Vg::data_size [llength $data_block]
    
    set tmp_filename ""
    append tmp_filename $Vg::FLASHDIR $Vg::TEMPCONFIGFILENAME
    VgFile::CreateConfigFile $tmp_filename
    VgFile::LoadFile2Flash $tmp_filename
    
    set data_crc [VgCRC::FastCalculate16bitCRCnormal $data_block]

    lappend data_block [lindex $data_crc 1]
    lappend data_block [lindex $data_crc 0]

    set filename $Vg::FLASHDIR
    append filename $Vg::TEMPDATAFILENAME

    VgFile::CreateHexFile $filename $data_block [expr $MAX_ADR_CONFIG_BLOCK+1]

    VgFile::LoadFile2Flash $filename
 
}

#proc VgProgram::LoadPakScript {filename} {
#    if {[catch {namespace eval programmer {source $VgProgram::filename}} err_msg]} {
#        Vg::LogLine "VgProgram::LoadPakScript: can't load PAK file -> $err_msg";
#        return 1
#    } else {
#        Vg::LogLine "VgProgram::LoadPakScript: PAK loaded";
#    }
#    return 0;
#}
#proc VgProgram::OnAdrProgressBar {} {
#    global FLASH_SIZE
#    .mainframe configure -progressvar Vg::flash_paragraph_adr -progressmax [expr round(($FLASH_SIZE/8) >> 4)]
#    .mainframe showstatusbar progression    
#}

#proc VgProgram::OffAdrProgressBar {} {
#    .mainframe showstatusbar status    
#}

proc VgProgram::button_conf_erase {} {
    variable serial;
    if {[VgCOM::open_channel serial]} then {return 1}
    if {[VgCOM::PageErase $serial 0] == 0} {
        Vg::LogLine "Succesfully erase configuration block of flash"
    } else {
        Vg::LogLine "Cant't erase configuration block of flash"
    }
    VgCOM::close_channel $serial
}


proc VgProgram::button_data_erase {} {
    global FLASH_SIZE
    variable serial;
    set errortype 0
    set trycount 0
    
    Vg::LogLine "Erasing data block of flash... Please wait..."
    update
    set t [clock seconds]
    set j 0
    set n [expr 511/100]
    set Vg::var_progressbar 0
    Vg::OnProgressBar [expr 100]
    
    VgCOM::open_channel serial
    
    for {set adr [expr 256]} {$adr < [expr $FLASH_SIZE/8]} {} {
        if {[VgCOM::PageErase $serial $adr] == 0} {
            set adr [expr $adr + 256]
            if {$j == $n} {incr Vg::var_progressbar; set j 0; update}
            incr j
        } else {
            Vg::LogLine "Cant't erase page: [format "%05X" $adr]. Trying again..."
            VgCOM::close_channel $serial
            if {[Vg::open_channel serial]} then {return 1}
            incr trycount
            update
            if {$trycount == 10} {"Cant't erase page: [format "%05X" $adr]. No more try";set errortype 1; break}
        }
    }
    Vg::LogLine "Done in [expr [clock seconds]-$t] seconds"
    Vg::OffProgressBar
    VgCOM::close_channel $serial
    if {$errortype == 0} {
        Vg::LogLine "Succesfully erase data block of flash"
    } else {
        Vg::LogLine "Cant't erase data block of flash"
    }
}

proc VgProgram::button_data_view {} {

}

proc VgProgram::button_data_read {} {

    set types {{{AVD2 data file} {.hex}}}
    if {[set filenamein [tk_getSaveFile -initialdir $Vg::FLASHDIR -initialfile $Vg::read_data_filename -filetypes $types]] ne ""} {
        
        set tmp_filename ""
        append tmp_filename $Vg::FLASHDIR $Vg::TEMPCONFIGFILENAME
        VgConfig::ReadConfig $tmp_filename
        VgConfig::ImportConfigFile $tmp_filename        
        Vg::LogLine "data_size: $Vg::data_size"
        set n [expr $Vg::data_size+2]
        
        if {[VgFile::LoadFlash2File1 $filenamein 256 $n]} {return 1}

#        set filenameout $Vg::FLASHDIR
#        append filenameout $Vg::DATAEXPORTFILENAME            
        set filename ".\\_data\\export_calibration.pak"
        set appendix ""
        if {[VgFile::GetFileList filename_list $filename $appendix]} {return 1}
#        Vg::LogLine "filename_list: $filename_list"
        

#        set filenameout_list "";
#        lappend filenameout_list ".\\_flash\\_export_hmc370.dat" ".\\_flash\\_export_hmc470.dat"
#        lappend filenameout_list ".\\_flash\\_export_rfinatt_att.dat" ".\\_flash\\_export_rfinlna_att.dat"
#        lappend filenameout_list ".\\_flash\\_export_rfinatt_gain.dat" ".\\_flash\\_export_rfinlna_gain.dat"
#        lappend filenameout_list ".\\_flash\\_export_gain.dat" ".\\_flash\\_export_det.dat"
        if {[VgFile::ImportDataFromHex $filenamein $filename_list]} {return 1}
        Vg::LogLine "Data are read from file and saved to file successfully"
    }    
    
    # 130816
}


proc VgProgram::button_all_check {} {
    Vg::LogLine "Nothing to do!"
}

proc VgProgram::button_all_erase {} {
    Vg::LogLine "Nothing to do!"
}

proc VgProgram::button_all_save {} {
    Vg::LogLine "Nothing to do!" 
}
