namespace eval VgFlash {

    namespace import ::Vg::LogLine;
    variable progmsg
    variable progval
}

proc VgFlash::create { nb } {
    set frame [$nb insert end VgFlash -text "Flash"]
    set titf [LabelFrame  $frame.titf];   

    _gctl [$titf getframe]
    
    pack $titf -padx 4 -pady 4 -fill both -anchor center;      

    return $frame
}

proc VgFlash::_gctl { root } {
    set base [expr {($root == ".") ? "" : $root}]
    variable ROOT $root
    variable BASE $base
    variable SCRIPTDIR ; # defined in main script


    # Widget Initialization
    variable _labelframe_1 [labelframe $BASE._labelframe_1 \
	    -text "Status"]
    variable _labelframe_3 [labelframe $BASE._labelframe_3]
    variable _labelframe_4 [labelframe $BASE._labelframe_4]
    variable _labelframe_5 [labelframe $BASE._labelframe_5]
    variable checkbutton_wel [checkbutton $BASE.checkbutton_wel \
	    -state "disabled" \
	    -text "WEL" \
	    -variable "Vg::var_wel" \
	    -width 8]
    variable checkbutton_wip [checkbutton $BASE.checkbutton_wip \
	    -state "disabled" \
	    -text "WIP" \
	    -variable "Vg::var_wip" \
	    -width 8]
    variable _checkbutton_3 [checkbutton $BASE._checkbutton_3 \
	    -text "BP1" \
	    -variable "Vg::var_bp1" \
	    -width 8]
    variable checkbutton_bp0 [checkbutton $BASE.checkbutton_bp0 \
	    -text "BP0" \
	    -variable "Vg::var_bp0" \
	    -width 8]
    variable button_read_status_reg [button $BASE.button_read_status_reg \
	    -command "VgFlash::rd_status_reg" \
	    -text "Read" \
	    -width 8]
    variable button_write_status_reg [button $BASE.button_write_status_reg \
	    -command "VgFlash::wr_status_reg" \
	    -text "Write" \
	    -width 8]
    variable label_rd_status_reg [label $BASE.label_rd_status_reg \
	    -text "Read status register" \
	    -width 20]
    variable button_wr_status_reg [label $BASE.button_wr_status_reg \
	    -text "Write status register" \
	    -width 20]
    variable checkbutton_wr_operation [checkbutton $BASE.checkbutton_wr_operation \
	    -text "WPEN" \
	    -variable "Vg::var_wpen" \
	    -width 10]
    variable button_chip_erase [button $BASE.button_chip_erase \
	    -command "VgFlash::chip_erase" \
	    -text "Erase" \
	    -width 8]
    variable button_page_erase [button $BASE.button_page_erase \
	    -command "VgFlash::page_erase" \
	    -text "Erase" \
	    -width 8]
    variable button_sector_erase [button $BASE.button_sector_erase \
	    -command "VgFlash::sector_erase" \
	    -text "Erase" \
	    -width 8]
    variable entry_page_erase [entry $BASE.entry_page_erase \
	    -textvariable "Vg::adr_page_erase" \
	    -width 8]
    variable entry_sector_erase [entry $BASE.entry_sector_erase \
	    -textvariable "Vg::adr_sec_erase" \
	    -width 8]
    variable _label_6 [label $BASE._label_6 \
	    -text "Address: 0x"]
    variable _label_7 [label $BASE._label_7 \
	    -text "Address: 0x"]
    variable label_chip_erase [label $BASE.label_chip_erase \
	    -text "Chip Erase"]
    variable label_page_erase [label $BASE.label_page_erase \
	    -text "Page Erase"]
    variable label_sector_erase [label $BASE.label_sector_erase \
	    -text "Sector Erase"]
    variable _label_11 [label $BASE._label_11 \
	    -text "Address: 0x"]
    variable _label_12 [label $BASE._label_12 \
	    -text "Value: 0x"]
    variable _entry_4 [entry $BASE._entry_4 \
	    -textvariable "Vg::adr_wr_sector" \
	    -width 8]
    variable _entry_5 [entry $BASE._entry_5 \
	    -textvariable "Vg::data_wr_sector" \
	    -width 8]
    variable button_wr_sector [button $BASE.button_wr_sector \
	    -command "VgFlash::wr_sector" \
	    -text "Write" \
	    -width 8]
    variable _Label_1 [Label $BASE._Label_1 \
	    -text "Write sector"]
    variable _label_13 [label $BASE._label_13 \
	    -text "Address: 0x"]
    variable _label_14 [label $BASE._label_14 \
	    -text "Value: 0x"]
    variable _entry_6 [entry $BASE._entry_6 \
	    -textvariable "Vg::adr_rd_sector" \
	    -width 8]
    variable _entry_7 [entry $BASE._entry_7 \
	    -state "disabled" \
	    -textvariable "Vg::data_rd_sector" \
	    -width 8]
    variable button_rd_sector [button $BASE.button_rd_sector \
	    -command "VgFlash::rd_sector" \
	    -text "Read" \
	    -width 8]
    variable _label_15 [label $BASE._label_15 \
	    -text "Read sector"]
    variable button_init [button $BASE.button_init \
	    -command "VgFlash::init_button" \
	    -text "Init" \
            -state disable \
	    -width 8]


    # Geometry Management

    grid $BASE._labelframe_1 -in $root -row 1 -column 1 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky "news"
    grid $BASE._labelframe_3 -in $root -row 2 -column 1 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky "news"
    grid $BASE._labelframe_4 -in $root -row 3 -column 1 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky "news"
    grid $BASE._labelframe_5 -in $root -row 4 -column 1 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky "news"
    grid $BASE.checkbutton_wel -in $base._labelframe_1 -row 1 -column 1 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky ""
    grid $BASE.checkbutton_wip -in $base._labelframe_1 -row 1 -column 2 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky ""
    grid $BASE._checkbutton_3 -in $base._labelframe_1 -row 2 -column 1 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky ""
    grid $BASE.checkbutton_bp0 -in $base._labelframe_1 -row 2 -column 2 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky ""
    grid $BASE.button_read_status_reg -in $base._labelframe_1 -row 1 -column 3 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 5 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky ""
    grid $BASE.button_write_status_reg -in $base._labelframe_1 -row 2 -column 3 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky ""
    grid $BASE.label_rd_status_reg -in $base._labelframe_1 -row 1 -column 4 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky "w"
    grid $BASE.button_wr_status_reg -in $base._labelframe_1 -row 2 -column 4 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky "w"
    grid $BASE.checkbutton_wr_operation -in $base._labelframe_1 -row 3 -column 1 \
	    -columnspan 3 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky "w"
    grid $BASE.button_chip_erase -in $base._labelframe_3 -row 1 -column 3 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky ""
    grid $BASE.button_page_erase -in $base._labelframe_3 -row 2 -column 3 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 5 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky ""
    grid $BASE.button_sector_erase -in $base._labelframe_3 -row 3 -column 3 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky ""
    grid $BASE.entry_page_erase -in $base._labelframe_3 -row 2 -column 2 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky "ew"
    grid $BASE.entry_sector_erase -in $base._labelframe_3 -row 3 -column 2 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky "ew"
    grid $BASE._label_6 -in $base._labelframe_3 -row 2 -column 1 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky "e"
    grid $BASE._label_7 -in $base._labelframe_3 -row 3 -column 1 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky "e"
    grid $BASE.label_chip_erase -in $base._labelframe_3 -row 1 -column 4 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky ""
    grid $BASE.label_page_erase -in $base._labelframe_3 -row 2 -column 4 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky ""
    grid $BASE.label_sector_erase -in $base._labelframe_3 -row 3 -column 4 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky ""
    grid $BASE._label_11 -in $base._labelframe_4 -row 1 -column 1 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky "e"
    grid $BASE._label_12 -in $base._labelframe_4 -row 2 -column 1 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky "e"
    grid $BASE._entry_4 -in $base._labelframe_4 -row 1 -column 2 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky "ew"
    grid $BASE._entry_5 -in $base._labelframe_4 -row 2 -column 2 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky "ew"
    grid $BASE.button_wr_sector -in $base._labelframe_4 -row 2 -column 3 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 5 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky ""
    grid $BASE._Label_1 -in $base._labelframe_4 -row 2 -column 4 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky ""
    grid $BASE._label_13 -in $base._labelframe_5 -row 1 -column 1 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky "e"
    grid $BASE._label_14 -in $base._labelframe_5 -row 2 -column 1 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky "e"
    grid $BASE._entry_6 -in $base._labelframe_5 -row 1 -column 2 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky "ew"
    grid $BASE._entry_7 -in $base._labelframe_5 -row 2 -column 2 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky "ew"
    grid $BASE.button_rd_sector -in $base._labelframe_5 -row 2 -column 3 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 5 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky ""
    grid $BASE._label_15 -in $base._labelframe_5 -row 2 -column 4 \
	    -columnspan 1 \
	    -ipadx 0 \
	    -ipady 0 \
	    -padx 0 \
	    -pady 0 \
	    -rowspan 1 \
	    -sticky ""
#    grid $BASE.button_init -in $base._labelframe_1 -row 3 -column 4 \
#	    -columnspan 1 \
#	    -ipadx 0 \
#	    -ipady 0 \
#	    -padx 0 \
#	    -pady 0 \
#	    -rowspan 1 \
#	    -sticky ""

    # Resize Behavior
    grid rowconfigure $root 1 -weight 0 -minsize 40 -pad 0
    grid rowconfigure $root 2 -weight 0 -minsize 22 -pad 0
    grid rowconfigure $root 3 -weight 0 -minsize 40 -pad 0
    grid rowconfigure $root 4 -weight 0 -minsize 40 -pad 0
    grid columnconfigure $root 1 -weight 0 -minsize 208 -pad 0
    grid rowconfigure $base._labelframe_1 1 -weight 0 -minsize 40 -pad 0
    grid rowconfigure $base._labelframe_1 2 -weight 0 -minsize 40 -pad 0
    grid rowconfigure $base._labelframe_1 3 -weight 0 -minsize 40 -pad 0
    grid columnconfigure $base._labelframe_1 1 -weight 0 -minsize 40 -pad 0
    grid columnconfigure $base._labelframe_1 2 -weight 0 -minsize 40 -pad 0
    grid columnconfigure $base._labelframe_1 3 -weight 0 -minsize 40 -pad 0
    grid columnconfigure $base._labelframe_1 4 -weight 0 -minsize 40 -pad 0
    grid rowconfigure $base._labelframe_3 1 -weight 0 -minsize 40 -pad 0
    grid rowconfigure $base._labelframe_3 2 -weight 0 -minsize 40 -pad 0
    grid rowconfigure $base._labelframe_3 3 -weight 0 -minsize 40 -pad 0
    grid columnconfigure $base._labelframe_3 1 -weight 0 -minsize 40 -pad 0
    grid columnconfigure $base._labelframe_3 2 -weight 0 -minsize 40 -pad 0
    grid columnconfigure $base._labelframe_3 3 -weight 0 -minsize 40 -pad 0
    grid columnconfigure $base._labelframe_3 4 -weight 0 -minsize 40 -pad 0
    grid rowconfigure $base._labelframe_4 1 -weight 0 -minsize 40 -pad 0
    grid rowconfigure $base._labelframe_4 2 -weight 0 -minsize 40 -pad 0
    grid columnconfigure $base._labelframe_4 1 -weight 0 -minsize 2 -pad 0
    grid columnconfigure $base._labelframe_4 2 -weight 0 -minsize 56 -pad 0
    grid columnconfigure $base._labelframe_4 3 -weight 0 -minsize 2 -pad 0
    grid columnconfigure $base._labelframe_4 4 -weight 0 -minsize 40 -pad 0
    grid rowconfigure $base._labelframe_5 1 -weight 0 -minsize 40 -pad 0
    grid rowconfigure $base._labelframe_5 2 -weight 0 -minsize 40 -pad 0
    grid columnconfigure $base._labelframe_5 1 -weight 0 -minsize 40 -pad 0
    grid columnconfigure $base._labelframe_5 2 -weight 0 -minsize 40 -pad 0
    grid columnconfigure $base._labelframe_5 3 -weight 0 -minsize 40 -pad 0
    grid columnconfigure $base._labelframe_5 4 -weight 0 -minsize 40 -pad 0
}

proc VgFlash::rd_status_reg {} {
    variable answer "";
    global FLASH_CMD_RDSR CPLD_ADR_RD_FLASH
    Vg::LogLine "VgLNO::rd_status_reg"
    if {[VgCOM::open_channel serial]} then {return 1} 

    set data $CPLD_ADR_RD_FLASH
    append data $FLASH_CMD_RDSR
    append data "00"   
    VgCOM::put_channel $serial $data 0 answer    

    set data [ expr 0x$answer & 0xFF]
    set Vg::var_wip [expr $data & 1]    
    set Vg::var_wel [expr ($data >> 1) & 1]
    set Vg::var_bp0 [expr ($data >> 2) & 1]
    set Vg::var_bp1 [expr ($data >> 3) & 1]
    set Vg::var_wpen [expr ($data >> 7) & 1]
    
    VgCOM::close_channel $serial
    return 0

}

proc VgFlash::wr_status_reg {} {
    variable answer "";
    global FLASH_CMD_WRSR FLASH_CMD_WREN CPLD_ADR_WR_FLASH
    
    Vg::LogLine "VgLNO::wr_status_reg"
    
    if {[VgCOM::open_channel serial]} then {return 1} 

    set data $CPLD_ADR_WR_FLASH
    append data $FLASH_CMD_WREN
    
    VgCOM::put_channel $serial $data 0 answer
   
    set data $CPLD_ADR_WR_FLASH
    append data $FLASH_CMD_WRSR
    
    set str $Vg::var_wpen    
    set str [expr $str << 4 | $Vg::var_bp1]
    set str [expr ($str << 1) | $Vg::var_bp0]
    set str [expr $str << 2]     
    append data [format "%02X" [expr $str & 0xFF]]
    VgCOM::put_channel $serial $data 0 answer   

    VgCOM::close_channel $serial
    return 0    
}

proc VgFlash::init_button {} {
    Vg::LogLine "VgLNO::init_button"
    Vg::LogLine "Nothing to do !!!!!!!!!!!!!!"    
}

proc VgFlash::chip_erase {} {
    global CMD_SS0_LOW CMD_SS0_HIGH CMD_SPI0 CMD_RUN FLASH_CMD_CE FLASH_CMD_WREN CPLD_ADR_WR_FLASH
    variable answer "";
    Vg::LogLine "VgLNO::chip_erase"
    
    if {[VgCOM::open_channel serial]} then {return 1} 

#   FLASH_CMD_WREN
 
    
    set data [expr (0x$CPLD_ADR_WR_FLASH << 8) | 0x$FLASH_CMD_WREN]
    VgCOM::put_channel $serial [format "%04X" $data] 0 answer    

#   FLASH_CMD_CE
    
    set data [expr (0x$CPLD_ADR_WR_FLASH << 8) | 0x$FLASH_CMD_CE]
    VgCOM::put_channel $serial [format "%04X" $data] 0 answer   

    VgCOM::close_channel $serial
    return 0        
}

proc VgFlash::page_erase {} {
    variable answer "";
    global CMD_SS0_LOW CMD_SS0_HIGH CMD_SPI0 CMD_RUN FLASH_CMD_PE FLASH_CMD_WREN CPLD_ADR_WR_FLASH
   
    set Vg::adr_page_erase [format "%05X" [expr 0x$Vg::adr_page_erase & 0x1FFFF]]    
    Vg::LogLine "VgLNO::page_erase"
    
    if {[VgCOM::open_channel serial]} then {return 1} 

    set data $CPLD_ADR_WR_FLASH
    append data $FLASH_CMD_WREN
    
    VgCOM::put_channel $serial $data 0 answer
    
    set data $CPLD_ADR_WR_FLASH
    append data $FLASH_CMD_PE
    append data [format "%06X" [expr 0x$Vg::adr_sec_erase & 0x01FFFF]]
    VgCOM::put_channel $serial $data 0 answer     

    VgCOM::close_channel $serial
    return 0    
}

proc VgFlash::sector_erase {} {
    variable answer "";
   global FLASH_CMD_SE FLASH_CMD_WREN CPLD_ADR_WR_FLASH
   
    set Vg::adr_sec_erase [format "%05X" [expr 0x$Vg::adr_sec_erase & 0x1FFFF]]
    
    Vg::LogLine "VgLNO::sector_erase"
    
    if {[VgCOM::open_channel serial]} then {return 1} 

    set data $CPLD_ADR_WR_FLASH
    append data $FLASH_CMD_WREN
    
    VgCOM::put_channel $serial $data 0 answer 

    set data $CPLD_ADR_WR_FLASH
    append data $FLASH_CMD_SE
    append data [format "%06X" [expr 0x$Vg::adr_sec_erase & 0x01FFFF]]
    VgCOM::put_channel $serial $data 0 answer 

    VgCOM::close_channel $serial
    return 0     
}

proc VgFlash::wr_sector {} {
    variable answer "";
    global FLASH_CMD_WRSR FLASH_CMD_WREN CPLD_ADR_WR_FLASH FLASH_CMD_WRITE
    
    set Vg::data_wr_sector [format "%02X" [expr 0x$Vg::data_wr_sector & 0xFF]]
    set Vg::adr_wr_sector [format "%05X" [expr 0x$Vg::adr_wr_sector & 0x1FFFF]]    
   
    Vg::LogLine "VgRWM::wr_sector_reg"
    Vg::LogLine "Address: 0x$Vg::adr_wr_sector"
    Vg::LogLine "Data: 0x$Vg::data_wr_sector"
    
    if {[VgCOM::open_channel serial]} then {return 1}

    set data $CPLD_ADR_WR_FLASH
    append data $FLASH_CMD_WREN
    
    VgCOM::put_channel $serial $data 0 answer 

    set data $CPLD_ADR_WR_FLASH
    append data $FLASH_CMD_WRITE
    append data [format "%06X" [expr 0x$Vg::adr_wr_sector & 0x01FFFF]]
    append data [format "%02X" [expr 0x$Vg::data_wr_sector & 0xFF]]
    
    VgCOM::put_channel $serial $data 0 answer 


    VgCOM::close_channel $serial
    return 0    
}

proc VgFlash::rd_sector {} {
    variable answer "";
    variable answer1 "";
    global   FLASH_CMD_WRSR FLASH_CMD_WREN CPLD_ADR_WR_FLASH CPLD_ADR_RD_FLASH FLASH_CMD_WRITE FLASH_CMD_READ

    set Vg::adr_rd_sector [format "%05X" [expr 0x$Vg::adr_rd_sector & 0x1FFFF]]  
    
    Vg::LogLine "VgRWM::rd_sector_reg"
    Vg::LogLine "Address: 0x$Vg::adr_rd_sector"

    
    if {[VgCOM::open_channel serial]} then {return 1} 
    

    set data $CPLD_ADR_RD_FLASH
    append data $FLASH_CMD_READ
    append data [format "%06X" [expr 0x$Vg::adr_rd_sector & 0x01FFFF]]
    append data "00"
    
    VgCOM::put_channel $serial $data 0 answer 
    
    
    set answer [format "%02X" [expr 0x$answer & 0xFF]]

    Vg::LogLine "Data: 0x$answer"

    set Vg::data_rd_sector $answer
    VgCOM::close_channel $serial
    return 0       
}

