namespace eval VgFile {

}

proc VgFile::GetParamFromFile {param_list power_list filename show} {
#  rt_type y_value x_value x_mult y_number x_number x_start x_delta

    variable crt_type "0";
    variable y_value "";
    variable x_value "";
    variable x_mult "";
    variable y_number "";
    variable x_number "";
    variable x_start "";
    variable x_delta "";

    upvar $param_list tmp
    upvar $power_list tmp1
    if { [catch {open $filename r} fd] } {
        Vg::LogLine "Could not open $filename for reading"
        return 1
    }
    Vg::LogLine "Open file for reading:\n$filename"
    set i 0
    set tmp1 ""
    while {1} {
        set str [gets $fd]
        if {[eof $fd]} {
            break
        }
        if {[regexp {^#} $str]} {continue}
        if {[regexp {^!} $str]} {
            set str_list [regexp -inline -all {\S*} $str]
            set str [lindex $str_list 2]
            
            switch -- $str {
                crt_type {
                    set str [lindex $str_list 4]
                    switch -- $str {
                        hmc370 { set crt_type 1 }
                        HMC370 { set crt_type 1 }
                        1 { set crt_type 1 }
                        hmc470 { set crt_type 2 }
                        HMC470 { set crt_type 2 }
                        2 { set crt_type 2 }                        
                        rfinatt_att { set crt_type 3 }
                        3 { set crt_type 3 }                         
                        rfinlna_att { set crt_type 4 }
                        4 { set crt_type 4 }                        
                        rfinatt_gain { set crt_type 5 }
                        5 { set crt_type 5 }
                        rfinlna_gain { set crt_type 6 }
                        6 { set crt_type 6 } 
                        rf_gain { set crt_type 7 }
                        7 { set crt_type 7 }                         
                        pwr_det { set crt_type 8 }
                        8 { set crt_type 8 }
                        default {
                            Vg::LogLine "Unexpected value of parametr 'crt_type': $str"
                            close $fd
                            return 1   
                        }
                    }                    
                }                
                y_value {
                    set str [lindex $str_list 4]
                    switch -- $str {
                        0 { set y_value 1 }
                        INT { set y_value 1 }
                        int { set y_value 1 }
                        1 { set y_value 1 }                        
                        2D.2 { set y_value 2 }
                        2d.2 { set y_value 2 }
                        2 { set y_value 2 }
                        default {
                            Vg::LogLine "Unexpected value of parametr 'y_value': $str"
                            close $fd
                            return 1   
                        }
                    }                    
                }                
                x_value {
                    set str [lindex $str_list 4]
                    switch -- $str {
                        0 { set x_value 1 }
                        INT { set x_value 1 }
                        int { set x_value 1 }
                        1 { set x_value 1 }                        
                        2D.2 { set x_value 2 }
                        2d.2 { set x_value 2 }
                        2 { set x_value 2 }
                        default {
                            Vg::LogLine "Unexpected value of parametr 'y_value': $str"
                            close $fd
                            return 1   
                        }
                    }                    
                }
                x_mult {
                    set str [lindex $str_list 4]
                    switch -- $str {
                        MHz { set x_mult 1000000 }
                        kHz { set x_mult 1000 }
                        Hz { set x_mult 1 }
                        default {
                            Vg::LogLine "Unexpected value of parametr 'fr_mult': $str"
                            close $fd
                            return 1   
                        }
                    }
                }
                y_number {
                    set y_number [lindex $str_list 4]    
                }
                x_number {
                    set x_number [lindex $str_list 4]    
                }
                x_start {
                    set x_start [lindex $str_list 4]    
                }
                x_delta {
                    set x_delta [lindex $str_list 4]    
                }
                power {
                    incr i
                    lappend tmp1 [lindex $str_list 4]
                }
                gain {

                }                
                att {

                }
                default {
                    Vg::LogLine "Unexpected parameter '$str' in file: $filename"
                    close $fd
                    return 1
                }
            }
        }    
    }
    close $fd

    if {$crt_type == {}} {Vg::LogLine "Parameter 'crt_type' aren't find in file: $filename\nSet to default: 0"; set crt_type 0}
    if {$y_value == {}} {Vg::LogLine "Parameter 'y_value' aren't find in file: $filename\nSet to default: INT"; set pwr_value 1}
    if {$x_value == {}} {Vg::LogLine "Parameter 'x_value' aren't find in file: $filename\nSet to default: INT"; set x_value 1}
    
    if {$x_mult == {}} {Vg::LogLine "Parameter 'x_mult' aren't find in file: $filename"; return 1}
    if {$y_number == {}} {Vg::LogLine "Parameter 'y_number' aren't find in file: $filename\nSet to default: 0"; set y_number 0}    
#    if {$y_number == {}} {Vg::LogLine "Parameter 'y_number' aren't find in file: $filename"; return 1}
    if {($y_number != $i) && $y_number != 0} {Vg::LogLine "Parameter 'y_number' don't match number of power points in file: $filename"; return 1}
    if {$x_number == {}} {Vg::LogLine "Parameter 'x_number' aren't find in file: $filename"; return 1}
    if {$x_start == {}} {Vg::LogLine "Parameter 'x_start' aren't find in file: $filename"; return 1}
    if {$x_delta == {}} {Vg::LogLine "Parameter 'x_delta' aren't find in file: $filename"; return 1}


#  rt_type y_value x_value x_mult y_number x_number x_start x_delta

    set tmp ""
    lappend tmp $crt_type $y_value $x_value $x_mult $y_number $x_number $x_start $x_delta
    
#    Vg::LogLine "TODO: organize better handling regular expration"
    return 0
}

proc VgFile::GetRowFromFile {data_list power fr_count filename} {
    upvar $data_list tmp
    set tmp ""

    if { [catch {open $filename r} fd] } {
        Vg::LogLine "Could not open $filename for reading"
        return 1
    }
#    Vg::LogLine "Open file for reading: $filename"
    set i 0
    if {$power == "ANY"} {
        while {1} {
            set str [gets $fd]
            if {[regexp {^#} $str]} {continue}
            if {[regexp {^!} $str]} {continue}
            set str_list [regexp -inline -all {\S*} $str]
            if {[lindex $str_list 0] == ""} {continue}                            
            if {[lindex $str_list 2] == ""} {
                Vg::LogLine "Error. Bad data structure for power: $power"
                close $fd
                return 1
            } else {
                incr i
                lappend tmp [lindex $str_list 2]
                if {$i == $fr_count} {
                    close $fd
                    return 0
                }
            }
            if {[eof $fd]} {
                Vg::LogLine "Warning. Unsufficient data points for power: $power"
                close $fd
                return 1
            }
        }        
        
    } else {
        while {1} {
            set str [gets $fd]
            if {[eof $fd]} {
                break
            }
            if {[regexp {^#} $str]} {continue}
            if {[regexp {^!} $str]} {
                set str_list [regexp -inline -all {\S*} $str]
                set str [lindex $str_list 2]
                switch -- $str {
                    power {
                        if {$power == [lindex $str_list 4]} {
                            while {1} {
                                set str [gets $fd]
                                if {[regexp {^#} $str]} {continue}
                                set str_list [regexp -inline -all {\S*} $str]
                                if {[lindex $str_list 0] == ""} {continue}                            
                                if {[lindex $str_list 2] == ""} {
                                    Vg::LogLine "Error. Bad data structure for power: $power"
                                    close $fd
                                    return 1
                                } else {
                                    incr i
                                    lappend tmp [lindex $str_list 2]
                                    if {$i == $fr_count} {
                                        close $fd
                                        return 0
                                    }
                                }
                                if {[eof $fd]} {
                                    Vg::LogLine "Warning. Unsufficient data points for power: $power"
                                    close $fd
                                    return 1
                                }
                            }
                        }
                    }                
                    default {
                        continue
                    }
                }
            }    
        }
    }
    Vg::LogLine "Error. Can't find data for power: $power"
    close $fd
    return 1
}

proc VgFile::GetPowerDAC {D0 D1 F0 F1 power freq filename} {
# freq - MHz
    upvar $D0 D0_tmp
    upvar $D1 D1_tmp 
    upvar $F0 F0_tmp    
    upvar $F1 F1_tmp    

    variable param_list "";
    variable power_list "";
    variable data_list "";

    if {[VgFile::GetParamFromFile param_list power_list $filename 1]} {return 1}

    set N [expr ($freq*1000000-[lindex $param_list 6]*[lindex $param_list 3])/(1.0*[lindex $param_list 7]*[lindex $param_list 3])]
    set N [expr round(floor($N))]
    set a [expr 1000000/[lindex $param_list 3]]
    set a [expr $a*$freq]
    set b [expr ([lindex $param_list 6]+[lindex $param_list 7]*([lindex $param_list 5]-1))]
    if {$a > $b} {set N [expr [lindex $param_list 5]-1]}
#    Vg::LogLine "N1: $N"
#    Vg::LogLine "freq: $freq"    
#    Vg::LogLine "a: $a"
#    Vg::LogLine "b: $b"
#    Vg::LogLine "N1: $N"
#    Vg::LogLine "c: [lindex $param_list 5]"    
    if {$N >= [expr [lindex $param_list 5]-1]} {set N [expr $N-1]}
    if { $N < 0 } {set N 0}
#    Vg::LogLine "N2: $N"    
    set F0_tmp [expr [lindex $param_list 6]+$N*[lindex $param_list 7]]
    set F1_tmp [expr $F0_tmp+[lindex $param_list 7]]
#    Vg::LogLine "N2: $N"
#    Vg::LogLine "c: [lindex $param_list 5]"
    update
    set i 0
    set count [llength $power_list]
#    Vg::LogLine "power: $power"
#    Vg::LogLine "power_list: $power_list"
    
    if {$power > [lindex $power_list 0]} {
    
    } else {
        for {set i 1} {$i<$count} {incr i} {
            if {$power >= [lindex $power_list $i]} {
                break
            }
        }
    }
    if {$i == 0} {
        Vg::LogLine "Warning: uncalibrated power"
        set i 1
    }
    if {$i == $count} {
        Vg::LogLine "Warning: uncalibrated power"
        set i [expr $count-1]
    }    
    VgFile::GetRowFromFile data_list [lindex $power_list $i] [lindex $param_list 5] $filename
    set Da0_tmp [lindex $data_list [expr $N]]
    set Da1_tmp [lindex $data_list [expr $N+1]]
#     Vg::LogLine "data_list: $data_list"    
    VgFile::GetRowFromFile data_list [lindex $power_list [expr $i-1]] [lindex $param_list 5] $filename    
    set Db0_tmp [lindex $data_list [expr $N]]
    set Db1_tmp [lindex $data_list [expr $N+1]]
    
#     Vg::LogLine "i: $i"
#     Vg::LogLine "Da1_tmp: $Da1_tmp"
 
    set D0_tmp [expr ($power-[lindex $power_list $i])*($Db0_tmp-$Da0_tmp)/([lindex $power_list [expr $i-1]]-[lindex $power_list $i])+$Da0_tmp]
# check
    set D1_tmp [expr ($power-[lindex $power_list $i])*($Db1_tmp-$Da1_tmp)/([lindex $power_list [expr $i-1]]-[lindex $power_list $i])+$Da1_tmp]
# check
    return 0
}
proc VgFile::CalculatePowerDAC {x0 x1 y0 y1 x} {
    set y [expr ($y1-$y0)*($x-$x0)/($x1-$x0)+$y0]
    return [expr round($y)]
}

proc VgFile::FormDataBlock {filename_list} {
    global ADR_DATABLK DATABLKSIG MAX_ADR_CONFIG_BLOCK FLASH_SIZE ROWBLKSIG
    variable param_list "";
    variable power_list "";    
    variable data_list "";
    variable data_block "";
    set count [expr $MAX_ADR_CONFIG_BLOCK+1]
#  rt_type y_value x_value x_mult y_number x_number x_start x_delta
    foreach filename $filename_list {
        if {[VgFile::GetParamFromFile param_list power_list $filename 1]} {Vg::LogLine "Error during read parameters from file: $filename"; return 1}
#        Vg::LogLine "param_list: $param_list"
#        Vg::LogLine "power_list: $power_list"        
        
        
        set str_list [regexp -inline -all -- {\w\w} $DATABLKSIG]
        for {set i 0} {$i<4} {incr i} {lappend data_block [lindex $str_list $i]}
    # rt_type
        lappend data_block [format "%02X" [lindex $param_list 0]]
    # y_value
        lappend data_block [format "%02X" [lindex $param_list 1]]
    # x_value
        lappend data_block [format "%02X" [lindex $param_list 2]]
    # x_mult   
    #    lappend data_block [format "%02X" [lindex $param_list 3]]
        lappend data_block [format "%02X" [expr round(log10([lindex $param_list 3]))]]
    #y_number
        lappend data_block [format "%02X" [expr [lindex $param_list 4] & 0xFF]]
        lappend data_block [format "%02X" [expr ([lindex $param_list 4] >> 8) & 0xFF]]
        lappend data_block [format "%02X" [expr ([lindex $param_list 4] >> 16) & 0xFF]]
        lappend data_block [format "%02X" [expr ([lindex $param_list 4] >> 24) & 0xFF]]
    #x_number
        lappend data_block [format "%02X" [expr [lindex $param_list 5] & 0xFF]]
        lappend data_block [format "%02X" [expr ([lindex $param_list 5] >> 8) & 0xFF]]
        lappend data_block [format "%02X" [expr ([lindex $param_list 5] >> 16) & 0xFF]]
        lappend data_block [format "%02X" [expr ([lindex $param_list 5] >> 24) & 0xFF]]
    #x_start
        lappend data_block [format "%02X" [expr [lindex $param_list 6] & 0xFF]]
        lappend data_block [format "%02X" [expr ([lindex $param_list 6] >> 8) & 0xFF]]
        lappend data_block [format "%02X" [expr ([lindex $param_list 6] >> 16) & 0xFF]]
        lappend data_block [format "%02X" [expr ([lindex $param_list 6] >> 24) & 0xFF]]
    #x_delta
        lappend data_block [format "%02X" [expr [lindex $param_list 7] & 0xFF]]
        lappend data_block [format "%02X" [expr ([lindex $param_list 7] >> 8) & 0xFF]]
        lappend data_block [format "%02X" [expr ([lindex $param_list 7] >> 16) & 0xFF]]
        lappend data_block [format "%02X" [expr ([lindex $param_list 7] >> 24) & 0xFF]]
#        for {set i 0} {$i<8} {incr i} {lappend data_block "00"}
        set count [expr $count + 24]
        if {[lindex $param_list 4] == 0} {set power_list "ANY"}
        foreach power $power_list {
            set str_list [regexp -inline -all -- {\w\w} $ROWBLKSIG]
            for {set i 0} {$i<2} {incr i} {lappend data_block [lindex $str_list $i]}
            if {$power == "ANY"} {
                set str 0
            } else {
                set str $power
            }
            lappend data_block [format "%02X" [expr $str & 0xFF]]
            lappend data_block [format "%02X" [expr ($str >> 8) & 0xFF]]        
            set count [expr $count + 4]         
            if {[VgFile::GetRowFromFile data_list $power [lindex $param_list 5] $filename]} {Vg::LogLine "Error during read row (power: $power) from file: $filename"; return 1}
#            Vg::LogLine "data_list: $data_list"
            if {[lindex $param_list 2] == 0 || [lindex $param_list 2] == 1} {
                foreach var $data_list {
                    lappend data_block [format "%02X" [expr $var & 0xFF]]
                    lappend data_block [format "%02X" [expr ($var >> 8) & 0xFF]]
                    set count [expr $count + 2]       
                }                
            }
            if {[lindex $param_list 2] == 2} {
                foreach var $data_list {
                    set var [expr round($var*100)]
                    lappend data_block [format "%02X" [expr $var & 0xFF]]
                    lappend data_block [format "%02X" [expr ($var >> 8) & 0xFF]]
                    set count [expr $count + 2]       
                }                 
            }
            

        }
    }
    set data_size $count
    set percent [expr 100*8*($count+$MAX_ADR_CONFIG_BLOCK)/(1.0*$FLASH_SIZE)]
    set percent [format "%.2f" $percent]
    Vg::LogLine "***********************************************************************" 
    Vg::LogLine "Flash is fill $percent %"    
    Vg::LogLine "***********************************************************************" 
#    set n [expr $FLASH_SIZE/8-2] 
#    for {} {$count < $n} {incr count} {
#        lappend data_block "00"
#    }
    if {[expr $count & 0xF] != 0} {
        set i [expr (($count/16)+1)*16-$count]
            for {set j 0} {$j < $i} {incr j} {
                lappend data_block "00"
            }
    }

#    set n [llength $data_block]
#    Vg::LogLine "data block: $n"
    
    return $data_block
}

proc VgFile::FixBlockSize {data_block} {
    set n [llength $data_block]
    set g [expr $n+2]
    if {[expr $g & 0xFF] != 0} {
        set i [expr (($n/256)+1)*256-$n-2]
            for {set j 0} {$j < $i} {incr j} {
                lappend data_block "00"
            }
    }
#    Vg::LogLine "after size: [llength $data_block]"
    return $data_block
}

proc VgFile::CreateHexFile {filename data_list start_adr} {
    global ENDOFFILE
    if { [catch {open $filename w} fd] } {
        Vg::LogLine "Could not open $filename for writing"
        return 1
    }
    Vg::LogLine "Open file for writing:\n$filename"   
    Vg::LogLine "Writing to file... Please wait..." 
#    VgProgram::OnAdrProgressBar 
    update
    set t [clock seconds]
    set flash_adr $start_adr

    set flash_paragraph_adr [expr ($flash_adr & 0xF0000) >> 4]
    set new_str "02000002"
    append new_str [format "%02X" [expr ($flash_paragraph_adr >> 8) & 0xFF]]
    append new_str [format "%02X" [expr $flash_paragraph_adr & 0xFF]]
    puts -nonewline $fd ":$new_str[VgCRC::CalculateHEXCRC $new_str]\n"

    set data [join $data_list ""]
    set data_list [regexp -inline -all -- {\w\w\w\w\w\w\w\w\w\w\w\w\w\w\w\w\w\w\w\w\w\w\w\w\w\w\w\w\w\w\w\w} $data]

    foreach str $data_list {
        set new_str [format "%02X" [expr 16]]
        append new_str [format "%02X" [expr ($flash_adr >> 8) & 0xFF]]
        append new_str [format "%02X" [expr $flash_adr & 0xFF]]
        append new_str "00"
        append new_str $str
        puts -nonewline $fd ":$new_str[VgCRC::CalculateHEXCRC $new_str]\n"
        set flash_adr [expr $flash_adr + 16]
        if {[expr ($flash_adr & 0xFFFF)] == 0} {
            set flash_paragraph_adr [expr $flash_adr >> 4]
            update
            set new_str "02000002"
            append new_str [format "%02X" [expr ($flash_paragraph_adr >> 8) & 0xFF]]
            append new_str [format "%02X" [expr $flash_paragraph_adr & 0xFF]]
            if {$flash_adr < 1048576} {puts -nonewline $fd ":$new_str[VgCRC::CalculateHEXCRC $new_str]\n"}
        }
    }

    set str $ENDOFFILE
    puts -nonewline $fd ":$str[VgCRC::CalculateHEXCRC $str]\n"
    close $fd
#    VgProgram::OffAdrProgressBar
    Vg::LogLine "Done in [expr [clock seconds]-$t] seconds" 
    return 0
}

proc VgFile::LoadFile2Flash {filename} {
# Error type list
# 1 - unexpected string begin
# 2 - unexpected CRC in string 
# 3 - unexpected number of bytes in string
# 4 - unsequent data flow
# 5 - Any data are not found

#    list data
    variable serial;
    variable form_page 0
    set count 0
    
    if { [catch {open $filename r} fd] } {
        Vg::LogLine "Could not open $filename for reading"
        return 1
    }
    Vg::LogLine "Open file for reading:\n$filename" 

    while {1} {
        set str [gets $fd]
        if {[eof $fd]} {
            break
        }
        scan $str "%c" char
        set strlist [regexp -inline -all -- {\w\w} $str]

        set reg_bytecount [expr 0x[lindex $strlist 0]]
        set reg_recordtype [lindex $strlist 3]
        if {$reg_recordtype == "01"} {
            break
        }
        if {$reg_recordtype == "02"} {
            continue
        }
        if {$reg_recordtype == "00"} {
            set count [expr $count+$reg_bytecount]
            continue
        }
    }
    set number_of_pages [expr $count/256]
#    Vg::LogLine "count: $count"
    
    close $fd
    if { [catch {open $filename r} fd] } {
        Vg::LogLine "Could not open $filename for reading"
        return 1
    }

    Vg::LogLine "Write to flash... Please wait..."
    set t [clock seconds]
#    set pagescount 0
#    set j 0
#    set n [expr $count/100]
    set Vg::var_progressbar 0
    Vg::OnProgressBar $number_of_pages
    update
    
    set copy_start 0
    set errortype 0
    set count 0
    set data {};

    if {[VgCOM::open_serial serial]} then {return 1}
    
    while {1} {
        set str [gets $fd]
        if {[eof $fd]} {
            break
        }
        scan $str "%c" char
        if {$char != 58} {set errortype 1; break}
        set strlist [regexp -inline -all -- {\w\w} $str]
#        Vg::LogLine "strlist: $strlist"
        if {[VgCRC::CheckStringCRC $strlist]} {set errortype 2; break}
        set str_number_bytes [llength $strlist]
        set reg_bytecount [expr 0x[lindex $strlist 0]]
        if {$str_number_bytes != [expr $reg_bytecount+5]} {set errortype 3; break}
        set reg_recordtype [lindex $strlist 3]
                if {$reg_recordtype == "01"} {
            break
        }
        if {$reg_recordtype == "02"} {
            set adr_offset [expr ((0x[lindex $strlist 4] << 8) + 0x[lindex $strlist 5]) << 4]
            continue
        }
        if {$reg_recordtype == "00"} {
            set copy_start 1
            if {$form_page == 0} {
                set reg_adr [expr (0x[lindex $strlist 1] << 8) + 0x[lindex $strlist 2]]
                set page_adr [expr $reg_adr+$adr_offset]
                set form_page 1
                for {set i 4} {$i < [expr $reg_bytecount+4]} {incr i} {
                    lappend data [lindex $strlist $i]
                    incr count
                }
            } else {
                for {set i 4} {$i < [expr $reg_bytecount+4]} {incr i} {
                    lappend data [lindex $strlist $i]
                    incr count
                }                
            }
            if {$count == 256} {
#                Vg::LogLine "data: $data"
                set try_num 0 
                while {[VgCOM::puts_page $serial $page_adr $data] != 0} {
                    incr try_num
                    if {$try_num == 10} {set errortype 5; break}
                    Vg::LogLine "Write page error"
                    Vg::LogLine "*** Reopen serial port ****"   
                    close $serial
                    update
                    if {[VgCOM::open_serial serial]} then {return 1}
#                    close $serial
#                    return 1
                }
                set count 0
                set form_page 0
                set data {};
                incr Vg::var_progressbar
                update
            }
        continue
        }
    }
    if {$copy_start == 0} {set errortype 5}
    Vg::OffProgressBar
    Vg::LogLine "Done in [expr [clock seconds]-$t] seconds"
    close $serial
    return $errortype
}

proc VgFile::LoadFlash2File1 {filename start_adr bytecount} {
    variable serial;
    variable byte "";
    variable page {};
    global ENDOFFILE
    set errortype 0
    if { [catch {open $filename w} fd] } {
        Vg::LogLine "Could not open $filename for writing"
        return 1
    }
    Vg::LogLine "Open file for writing:\n$filename"

    Vg::LogLine "Read from flash... Please wait..."
    update
    set t [clock seconds]
    set pages_number [expr $bytecount/256]
    set Vg::var_progressbar 0
    Vg::OnProgressBar $pages_number
    
    
    set adr_offset [expr ($start_adr & 0xF0000) >> 4]
    set adr [expr $start_adr & 0x1FF00]
    set count 0    

    set outstr "02000002"
    append outstr [format "%04X" $adr_offset]
    puts -nonewline $fd ":$outstr[VgCRC::CalculateHEXCRC $outstr]\n"

    if {[VgCOM::open_serial serial]} then {return 1} 

    set str {};  
    while {$count < $pages_number} {
        if {[VgCOM::GetPageFromFlash $serial $adr page] == 0} {
            incr count
            set page [join $page ""]
            set page [regexp -inline -all -- {................................} $page]
            for {set str_count 0} {$str_count < 16} {incr str_count} {
                set str [lindex $page $str_count]
                set outstr "10[format "%04X" [expr $adr & 0xFFFF]]00"
                append outstr $str
                puts -nonewline $fd ":$outstr[VgCRC::CalculateHEXCRC $outstr]\n"
                set str ""
                set adr [expr $adr + 16]
                if {[expr $adr & 0xFFFF] == 0} {
                    set adr_offset [expr ($adr & 0xF0000) >> 4]
                    set outstr "02000002"
                    append outstr [format "%04X" $adr_offset]                
                    puts -nonewline $fd ":$outstr[VgCRC::CalculateHEXCRC $outstr]\n"                
                }
            }
            incr Vg::var_progressbar
            update
        } else {
            Vg::LogLine "*** Read page error ****"
            close $serial
            return 1
            if {[Vg::open_serial serial]} then {return 1}
            Vg::LogLine "*** Reopen serial port ****"
            set errortype 1
            update
        }
    }
    
    set str $ENDOFFILE
    puts -nonewline $fd ":$str[VgCRC::CalculateHEXCRC $str]\n"

    close $fd
    close $serial
    Vg::LogLine "Done in [expr [clock seconds]-$t] seconds"
    Vg::OffProgressBar
    return $errortype
}

proc VgFile::ImportDataFromHex {filenamein filenameout_list} {



#    Vg::LogLine "filenameout_list: $filenameout_list"
    global MAX_ADR_CONFIG_BLOCK DATABLKSIG
    variable param_list "";
#    if { [catch {open $filenamein r} fdin] } {
#        Vg::LogLine "Could not open $filenamein for reading"
#        return 1
#    }
#    Vg::LogLine "Open file for reading:\n$filenamein"
    
    set adr [expr $MAX_ADR_CONFIG_BLOCK+1]
    
    foreach filenameout $filenameout_list {
#        Vg::LogLine "filenameout: $filenameout"
        if { [catch {open $filenameout w} fdout] } {
            Vg::LogLine "Could not open $filenameout for writing"
            return 1
        }
        Vg::LogLine "Open file for writing:\n$filenameout"    
        
        set block [VgFile::GetDataFromHex $filenamein $adr 24]
        set adr [expr $adr+24]
        
#        Vg::LogLine "param_block: $block"
        
        if {$block != 0} {
            set str [lindex $block 0]
            append str [lindex $block 1]
            append str [lindex $block 2]
            append str [lindex $block 3]
            if {$str != $DATABLKSIG} {
                Vg::LogLine "Fail to import data. Data block signature don't match"
#                close $fdin
                close $fdout
                return 1                
            }
            set param_list [expr 0x[lindex $block 4]]
            lappend param_list [expr 0x[lindex $block 5]]
            lappend param_list [expr 0x[lindex $block 6]]
            
            lappend param_list [expr round(pow(10,0x[lindex $block 7]))]
    
            set str [lindex $block 11]
            append str [lindex $block 10]
            append str [lindex $block 9]
            append str [lindex $block 8]
            lappend param_list [expr 0x$str]        
            
            set str [lindex $block 15]
            append str [lindex $block 14]
            append str [lindex $block 13]
            append str [lindex $block 12]
            lappend param_list [expr 0x$str]
            
            set str [lindex $block 19]
            append str [lindex $block 18]
            append str [lindex $block 17]
            append str [lindex $block 16]
            lappend param_list [expr 0x$str]
    
            set str [lindex $block 23]
            append str [lindex $block 22]
            append str [lindex $block 21]
            append str [lindex $block 20]
            lappend param_list [expr 0x$str]
            
#            Vg::LogLine "param_list: $param_list"
        } else {
            Vg::LogLine "Fail to import data"
#            close $fdin
            close $fdout
            return 1
        }
        if {[lindex $param_list 4] == 0} {
            set n 1
        } else {
            set n [lindex $param_list 4]
        }
        set byte_count [expr round($n*(4+2*[lindex $param_list 5]))]
#        Vg::LogLine "byte_count: $byte_count"
#        set a [expr $byte_count/16.0]
#        if {[expr $a - round($a)] != 0} {set byte_count [expr round(16*(floor($a)+1))]}
#        Vg::LogLine "adr: $adr"
        
        set block [VgFile::GetDataFromHex $filenamein $adr $byte_count]
#        Vg::LogLine "data_block: $block"
        set adr [expr $adr + $byte_count]
        if {$block != 0} {
            SetCalibrationData $param_list $block $fdout
        } else {
            Vg::LogLine "Fail to import data"
#            close $fdin
            close $fdout
            return 1
        }
        
        
        
    
        close $fdout
    }
    
#    close $fdin
    return 0
}

proc VgFile::GetDataFromHex {filenamein start_adr number_bytes} {
# Error type list
# 1 - unexpected string begin
# 2 - unexpected CRC in string 
# 3 - unexpected number of bytes in string
# 4 - unsequent data flow
# 5 - unexpected end of file, read unsufficiency data

    if { [catch {open $filenamein r} fd] } {
        Vg::LogLine "Could not open $filenamein for reading"
        return 1
    }

    variable char
    set block ""
    set copy_start 0
    set errortype 0
    set reg_adr 0
    set reg_bytecount 0
    set adr_offset 0
    set bytecount 0
#    Vg::LogLine "start_adr: $start_adr"
    while {1} {
        set str [gets $fd]
        if {[eof $fd]} {
            break
        }
        scan $str "%c" char
        if {$char != 58} {set errortype 1; break}
        set strlist [regexp -inline -all -- {\w\w} $str]
        if {[VgCRC::CheckStringCRC $strlist]} {set errortype 2; break}
        set str_number_bytes [llength $strlist]
        set reg_bytecount [expr 0x[lindex $strlist 0]]
        if {$str_number_bytes != [expr $reg_bytecount+5]} {set errortype 3; break}
        set reg_recordtype [lindex $strlist 3]
                if {$reg_recordtype == "01"} {
            set errortype 5
            break
        }
        if {$reg_recordtype == "02"} {
            set adr_offset [expr ((0x[lindex $strlist 4] << 8) + 0x[lindex $strlist 5]) << 4]
            continue
        }
        if {$reg_recordtype == "00"} {
            set reg_adr [expr (0x[lindex $strlist 1] << 8) + 0x[lindex $strlist 2]]          
            if {$copy_start == 0} {
                if {([expr $reg_adr+$adr_offset] <= $start_adr) && ([expr $reg_adr+$adr_offset+$reg_bytecount] > $start_adr)} {
                    
                    set n [expr $start_adr-$reg_adr+$adr_offset]
#                    Vg::LogLine "strlist: $strlist"
#                    Vg::LogLine "n: $n"
                    
                    set adr [expr $reg_adr + $reg_bytecount]
                    set bytecount [expr $bytecount + $reg_bytecount - $n]
                    for {set i $n} {$i<$reg_bytecount} {incr i} {
                        lappend block [lindex $strlist [expr $i+4]]
                    }
                    set copy_start 1
                }
            } else {
                if {$reg_adr == $adr} {
                    set adr [expr $reg_adr + $reg_bytecount]
#                    set bytecount [expr $bytecount + $reg_bytecount]
                    for {set i 0} {$i<$reg_bytecount && $bytecount < $number_bytes} {incr i} {
                        lappend block [lindex $strlist [expr $i+4]]
                        incr bytecount
                    }
                    if {$bytecount == $number_bytes} {
                        break
                    }
                } else {
                    set errortype 4; break
                }
            }
            continue
        }
    }
    close $fd
    if {$copy_start == 0} {set errortype 5} 
    if {$errortype == 0} {return $block} else {return 0}
}

proc VgFile::SetCalibrationData {param_list data_list fdout} {
#  rt_type y_value x_value x_mult y_number x_number x_start x_delta

    switch -- [lindex $param_list 0] {
        0 { set str "undef" }
        1 { set str "hmc370" }
        2 { set str "hmc470" }
        3 { set str "rfinatt_att" }
        4 { set str "rfinlna_att" }
        5 { set str "rfinatt_gain" }
        6 { set str "rfinlna_gain" }
        7 { set str "rf_gain" }
        8 { set str "pwr_det" }       

        default {
            Vg::LogLine "Unexpected crt_type: [lindex $param_list 0]"
            return 1
        }
    }
    puts $fdout "! crt_type $str"

    switch -- [lindex $param_list 1] {
        1 { set str "INT" }
        2 { set str "2D.2" }        
        
        default {
            Vg::LogLine "Unexpected y_value: [lindex $param_list 1]"
            return 1
        }
    }
    puts $fdout "! y_value $str"    
    
    switch -- [lindex $param_list 2] {
        1 { set str "INT" }
        2 { set str "2D.2" }        
        
        default {
            Vg::LogLine "Unexpected x_value: [lindex $param_list 2]"
            return 1
        }
    }
    puts $fdout "! x_value $str"
    
    switch -- [lindex $param_list 3] {
        1 {
            set str "Hz"
        }
        1000 {
            set str "kHz"
        }
        1000000 {
            set str "MHz"
        }          
        1000000000 {
            set str "GHz"
        }          
        default {
            Vg::LogLine "Unexpected x_mult: [lindex $param_list 3]"
            return 1
        }
    }
    puts $fdout "! x_mult $str"
    
    puts $fdout "! y_number [lindex $param_list 4]"    
    puts $fdout "! x_number [lindex $param_list 5]"
    puts $fdout "! x_start [lindex $param_list 6]"     
    puts $fdout "! x_delta [lindex $param_list 7]"     
    
#    set power_list ""

    if {[lindex $param_list 0] == 8} {
        set power_list ""
        for {set i 0} {$i < [lindex $param_list 4]} {incr i} {
            set N [expr 2*$i*[expr 2 + [lindex $param_list 5]]+2]
            set str [lindex $data_list [expr $N+1]]
            append str [lindex $data_list $N]     
            lappend power_list [expr 0x$str]
        }
#        Vg::LogLine "param_list: $param_list"
#        Vg::LogLine "data_list: $data_list"
#        Vg::LogLine "power_list: $power_list"
            set j 0
            foreach power $power_list {
                puts $fdout "\n"
                if {[expr ($power >> 7) & 0x01] == 1} {
                    set power [expr (($power & 0xFFFF)-1-0xFFFF)]
                }
                puts $fdout "! power $power"
                for {set i 0} {$i < [lindex $param_list 5]} {incr i} {
                    set N [expr 2*$j*[expr 2 + [lindex $param_list 5]]+4+2*$i]
                    set str [lindex $data_list [expr $N+1]]
                    append str [lindex $data_list $N]             
                    puts $fdout "[expr [lindex $param_list 6]+$i*[lindex $param_list 7]]\t[expr 0x$str]"
                }        
                incr j
            }
    }
    if {([lindex $param_list 0] == 1) || ([lindex $param_list 0] == 2) || ([lindex $param_list 0] == 3) || ([lindex $param_list 0] == 4) || ([lindex $param_list 0] == 5) || ([lindex $param_list 0] == 6) || ([lindex $param_list 0] == 7)} {
        puts $fdout "\n"
        for {set i 0} {$i < [lindex $param_list 5]} {incr i} {
            set N [expr 4+2*$i]
            set str [lindex $data_list [expr $N+1]]
            append str [lindex $data_list $N]
#            Vg::LogLine "N: $N"
#            Vg::LogLine "data_list: $data_list"
#            Vg::LogLine "str: $str"
            if {[lindex $param_list 2] == 0 || [lindex $param_list 2] == 1} {puts $fdout "[expr [lindex $param_list 6]+$i*[lindex $param_list 7]]\t[expr 0x$str]"}
            if {[lindex $param_list 2] == 2} {puts $fdout "[expr [lindex $param_list 6]+$i*[lindex $param_list 7]]\t[expr 0x$str/100.0]"}
        }
    }    

    return 0
    
}

proc VgFile::CreateConfigFile {filename} {
    global ENDOFFILE
    if { [catch {open $filename w} fd] } {
        Vg::LogLine "Could not open $filename for writing"
        return 1
    }

    Vg::LogLine "Open file for writing:\n$filename"
    
    set outstr "020000020000"
    puts -nonewline $fd ":$outstr[VgCRC::CalculateHEXCRC $outstr]\n"
    set block [VgFile::CreateConfigBlockFlash]
    set config_crc [VgCRC::Calculate16bitCRCnormal $block]
    lappend block [lindex $config_crc 1]
    lappend block [lindex $config_crc 0]
#    Vg::LogLine "block: $block"
    set block [join $block ""]
    set block [regexp -inline -all -- {................................} $block]

    set flash_adr 0

    foreach str $block {
#        set Vg::prgindic $Vg::flash_adr
        set new_str [format "%02X" [expr 16]]
        append new_str [format "%02X" [expr ($flash_adr >> 8) & 0xFF]]
        append new_str [format "%02X" [expr $flash_adr & 0xFF]]
        append new_str "00"
        append new_str $str
        puts -nonewline $fd ":$new_str[VgCRC::CalculateHEXCRC $new_str]\n"
        set flash_adr [expr $flash_adr + 16]

    }    
    
    set str $ENDOFFILE
    puts -nonewline $fd ":$str[VgCRC::CalculateHEXCRC $str]\n"

    close $fd
    return 0
}

proc VgFile::CreateConfigBlockFlash {} {
    global MAX_ADR_CONFIG_BLOCK ZERO_LINE
    global ADR_CONFIGBLKSIG CONFIGBLKSIG ADR_PID ADR_SID ADR_SN ADR_DATE ADR_REF_FR ADR_DATA_SIZE ADR_FLASH_SIZE FLASH_SIZE ADR_LOT
    variable block
    
    set block "$ZERO_LINE"
    append block "$ZERO_LINE"

    set block [regexp -inline -all -- {\w\w} $block]
    
    set sig_list [regexp -inline -all -- {\w\w} $CONFIGBLKSIG]

# Signature
    set adr [expr $ADR_CONFIGBLKSIG]
    set tmp 0
    lset block $adr [lindex $sig_list $tmp]
    lset block [incr adr] [lindex $sig_list [incr tmp]]
    lset block [incr adr] [lindex $sig_list [incr tmp]]
    lset block [incr adr] [lindex $sig_list [incr tmp]]
    
# PID
    set adr [expr $ADR_PID]
    set str $Vg::device_pid
    while {[regsub {^[0]} $str {} str] != 0} {}
    if {$str == ""} {set str 0}
    lset block $adr [format "%02X" [expr $str & 0xFF]]
    lset block [incr adr] [format "%02X" [expr ($str >> 8) & 0xFF]]    
# SID    
    set adr [expr $ADR_SID]
    lset block $adr [format "%02X" [expr $Vg::device_sid & 0xFF]] 
    lset block [incr adr] [format "%02X" [expr ($Vg::device_sid >> 8) & 0xFF]]      
# SN    
    set adr [expr $ADR_SN]
    lset block $adr [format "%02X" [expr $Vg::device_sn & 0xFF]]
    lset block [incr adr] [format "%02X" [expr ($Vg::device_sn >> 8) & 0xFF]]
# LOT
    set adr [expr $ADR_LOT]
    lset block $adr [format "%02X" [expr $Vg::device_lot & 0xFF]]     
# DATE    
    set adr [expr $ADR_DATE]
    set str $Vg::date_dd
    regsub {^[0]} $str {} str
    lset block $adr [format "%02X" [expr $str & 0xFF]]
    set str $Vg::date_mm
    regsub {^[0]} $str {} str
    lset block [incr adr] [format "%02X" [expr $str & 0xFF]]
    lset block [incr adr] [format "%02X" [expr ($Vg::date_yyyy-1970) & 0xFF]]     

# REF_FR    
    set adr [expr $ADR_REF_FR]
    lset block $adr [format "%02X" [expr $Vg::flash_ref_clk & 0xFF]]
    lset block [incr adr] [format "%02X" [expr ($Vg::flash_ref_clk >> 8) & 0xFF]]    
    lset block [incr adr] [format "%02X" [expr ($Vg::flash_ref_clk >> 16) & 0xFF]]
    lset block [incr adr] [format "%02X" [expr ($Vg::flash_ref_clk >> 24) & 0xFF]]
    
# DATA_SIZE    
    set adr [expr $ADR_DATA_SIZE]
    lset block $adr [format "%02X" [expr $Vg::data_size & 0xFF]]
    lset block [incr adr] [format "%02X" [expr ($Vg::data_size >> 8) & 0xFF]]    
    lset block [incr adr] [format "%02X" [expr ($Vg::data_size >> 16) & 0xFF]]
    lset block [incr adr] [format "%02X" [expr ($Vg::data_size >> 24) & 0xFF]]    
    
# FLASH_SIZE    
    set adr [expr $ADR_FLASH_SIZE]
    lset block $adr [format "%02X" [expr $FLASH_SIZE & 0xFF]]
    lset block [incr adr] [format "%02X" [expr ($FLASH_SIZE >> 8) & 0xFF]]    
    lset block [incr adr] [format "%02X" [expr ($FLASH_SIZE >> 16) & 0xFF]]
    lset block [incr adr] [format "%02X" [expr ($FLASH_SIZE >> 24) & 0xFF]]
    
    
    set n [expr $MAX_ADR_CONFIG_BLOCK-1]
    for {set i 32} {$i<$n} {incr i} {
        lappend block "00"
    }
#    append block "$ZERO_LINE\n"
#    if {[expr $i-1] != $n} {Vg::LogLine "Unsupported configuration block size"}
#    Vg::LogLine "conf block size : [llength $block]"
    
    return $block
}

proc VgFile::ReadRefFrequency {show_mb} {
    variable serial;
    variable byte "";
    global ADR_REF_FR CONFIGBLKSIG DEFAULT_REF_CLK
    variable strlist {}
    set adr 0
    if {[VgCOM::open_serial serial]} then {return 1}
    for {set i 0} {$i<4} {} {
        if {[VgCOM::GetByteFromFlash $serial $adr byte] == 0} {
            lappend strlist $byte
            incr i
            incr adr
        } else {
            Vg::LogLine "*** Error. Read empty byte ****"
            update
            close $serial
            if {[Vg::open_serial serial]} then {return 1}
            Vg::LogLine "*** Reopen serial port ****"
        }
    }
    set signature ""
    append signature [lindex $strlist 0] [lindex $strlist 1] [lindex $strlist 2] [lindex $strlist 3]
    if {$signature ne $CONFIGBLKSIG} {
        set clk [expr $DEFAULT_REF_CLK/1000000.0]
        Vg::LogLine "Can't read reference frequency from flash"
        Vg::LogLine "Set to default $clk MHz"        
        if {$show_mb == 1} {tk_messageBox -message "Can't read reference frequency from flash" -type ok -icon warning}
        close $serial;
        return $clk
    }
    
    set strlist {};
    set adr [expr $ADR_REF_FR]
    for {set i 0} {$i<4} {} {
#        set byte [GetByteFromFlash $adr]
        if {[VgCOM::GetByteFromFlash $serial $adr byte] == 0} {
            lappend strlist $byte
            incr i
            incr adr
        } else {
            Vg::LogLine "*** Error. Read empty byte ****"
            close $serial
            if {[Vg::open_serial serial]} then {return 1}
            Vg::LogLine "*** Reopen serial port ****"
            update
        }
    }

    set clk ""
    append clk [lindex $strlist 3] [lindex $strlist 2] [lindex $strlist 1] [lindex $strlist 0]
   
    set clk [expr 0x$clk/1000000.0]
    set clk [format "%.6f" $clk]
    Vg::LogLine "*****************************************************************************"
    Vg::LogLine "Read reference frequency from flash: $clk MHz"
    Vg::LogLine "*****************************************************************************"
#    Vg::LogLine "clk: $clk"
    close $serial
    return $clk
}

proc VgFile::GetVarValue {var var_name filename} {
    upvar $var var_tmp

    if { [catch {open $filename r} fd] } {return 1}
    while {1} {
        set str [gets $fd]
        if {[eof $fd]} {
            break
        }
        if {[regexp {^#} $str]} {continue}
        set str_list [regexp -inline -all {\S*} $str]
        if {[lindex $str_list 0] == $var_name} {
            if {[lindex $str_list 2] == ""} {
                close $fd
                return 1
            } else {
                set var_tmp [lindex $str_list 2]
                close $fd
                return 0
            }
        }
    }
    close $fd
    return 1
}

proc VgFile::SavePreferences2File {data_list filename} {
    if { [catch {open $filename w} fd] } {
        file mkdir "_config"
        if { [catch {open $filename w} fd] } {    
            return 1
        }
        
    }    
    foreach var_str $data_list {
        puts $fd "[lindex $var_str 0] [lindex $var_str 1]"
        
        
    }
    close $fd
    return 0
}

proc VgFile::SetConfigInformation {block} {
    global ADR_CONFIGBLKSIG CONFIGBLKSIG ADR_PID ADR_SID ADR_SN ADR_DATE ADR_REF_FR ADR_DATA_SIZE ADR_FLASH_SIZE ADR_LOT
# Error type list
# 0 - Ok
# 1 - Wrong signature
    
    set errortype 0
# Signature
    set data ""
    set adr [expr $ADR_CONFIGBLKSIG]
    append data [lindex $block $adr]
    append data [lindex $block [incr adr]]
    append data [lindex $block [incr adr]]
    append data [lindex $block [incr adr]]
    if {$data != $CONFIGBLKSIG} {set errortype 1}
    
# PID
    set adr [expr $ADR_PID]
    set Vg::device_pid [expr 0x[lindex $block $adr] + (0x[lindex $block [incr adr]] << 8)]  
# SID    
    set adr [expr $ADR_SID]
    set Vg::device_sid [expr 0x[lindex $block $adr] + (0x[lindex $block [incr adr]] << 8)]      
# SN    
    set adr [expr $ADR_SN]
    set Vg::device_sn [expr 0x[lindex $block $adr] + (0x[lindex $block [expr $adr +1]] << 8)]
# LOT    
    set adr [expr $ADR_LOT]
    set Vg::device_lot [expr 0x[lindex $block $adr]] 
# DATE
    set adr [expr $ADR_DATE]
    set Vg::date_dd [expr 0x[lindex $block $adr]]
    set Vg::date_mm [expr 0x[lindex $block [incr adr]]]
    set Vg::date_yyyy [expr 0x[lindex $block [incr adr]]+1970]       

# REF_FR    
    set adr [expr $ADR_REF_FR]
    set Vg::flash_ref_clk [expr 0x[lindex $block $adr] + (0x[lindex $block [expr $adr+1]] << 8) + (0x[lindex $block [expr $adr+2]] << 16) + (0x[lindex $block [expr $adr+3]] << 24)]
    
# ADR_DATA_SIZE    
    set adr [expr $ADR_DATA_SIZE]
    set Vg::data_size [expr 0x[lindex $block $adr] + (0x[lindex $block [expr $adr+1]] << 8) + (0x[lindex $block [expr $adr+2]] << 16) + (0x[lindex $block [expr $adr+3]] << 24)]

#    Vg::LogLine "Vg::data_size: $Vg::data_size"


    return $errortype
}

proc VgFile::CreateConfigFile {filename} {
    global ENDOFFILE
    if { [catch {open $filename w} fd] } {
        Vg::LogLine "Could not open $filename for writing"
        return 1
    }

    Vg::LogLine "Open file for writing:\n$filename"
    
    set outstr "020000020000"
    puts -nonewline $fd ":$outstr[VgCRC::CalculateHEXCRC $outstr]\n"
    set block [VgFile::CreateConfigBlockFlash]
    set config_crc [VgCRC::Calculate16bitCRCnormal $block]
    lappend block [lindex $config_crc 1]
    lappend block [lindex $config_crc 0]
#    Vg::LogLine "block: $block"
    set block [join $block ""]
    set block [regexp -inline -all -- {................................} $block]

    set adr 0

    foreach str $block {
#        set Vg::prgindic $Vg::flash_adr
        set new_str [format "%02X" [expr 16]]
        append new_str [format "%02X" [expr ($adr >> 8) & 0xFF]]
        append new_str [format "%02X" [expr $adr & 0xFF]]
        append new_str "00"
        append new_str $str
        puts -nonewline $fd ":$new_str[VgCRC::CalculateHEXCRC $new_str]\n"
        set adr [expr $adr + 16]

    }    
    
    set str $ENDOFFILE
    puts -nonewline $fd ":$str[VgCRC::CalculateHEXCRC $str]\n"

    close $fd
    return 0
}

proc VgFile::GetCalibrationParamFromFile {var freq filename show} {
    upvar $var tmp

    variable param_list "";
    variable power_list "";

    if {[VgFile::GetParamFromFile param_list power_list $filename $show]} {return 1}

    if { [catch {open $filename r} fd] } {
        Vg::LogLine "Could not open $filename for reading"
        return 1
    }
    set i 0
    set data_list ""
    while {1} {
        set str [gets $fd]
        if {[regexp {^#} $str]} {continue}
        if {[regexp {^!} $str]} {continue}
        set str_list [regexp -inline -all {\S*} $str]
        if {[lindex $str_list 0] == ""} {continue}                            
        if {[lindex $str_list 2] == ""} {
            Vg::LogLine "Error. Bad data structure"
            close $fd
            return 1
        } else {
            incr i
            lappend data_list [lindex $str_list 2]
            if {$i == [lindex $param_list 5]} {
                break
            }
        }
        if {[eof $fd]} {
            Vg::LogLine "Warning. Unsufficient data points for power: $param"
            close $fd
            return 1
        }
    }

    close $fd
#  rt_type y_value x_value x_mult y_number x_number x_start x_delta

    set N [expr ($freq*1000000-[lindex $param_list 6]*[lindex $param_list 3])/(1.0*[lindex $param_list 7]*[lindex $param_list 3])]
    set N [expr round(floor($N))]
    if {$N < 2} {set N 2}
    set a [expr 1000000/[lindex $param_list 3]]
    set a [expr $a*$freq]
    set b [expr ([lindex $param_list 6]+[lindex $param_list 7]*([lindex $param_list 5]-1))]
    if {$a >= $b} {set N [expr [lindex $param_list 5]-2]}   

    
    set F1 [expr [lindex $param_list 6]+$N*[lindex $param_list 7]]
    set F2 [expr $F1+[lindex $param_list 7]]
    
    set D1 [lindex $data_list $N]
    set D2 [lindex $data_list [expr $N+1]]    
    
    #Vg::LogLine "F1: $F1"
    #Vg::LogLine "F2: $F2"
    #Vg::LogLine "D1: $D1"
    #Vg::LogLine "D2: $D2"
    #Vg::LogLine "data_list: $data_list"
    
    set tmp [VgCRC::CalculatePoint4Liner $F1 $F2 $D1 $D2 $freq]
    
    return 0
}

proc VgFile::GetFileList {filename_list filename appendix} {
    upvar $filename_list tmp
    set tmp "";
    if { [catch {open $filename r} fd] } {
        Vg::LogLine "Could not open $filename for reading"
        return 1
    }    
    while {1} {
        set str [gets $fd]
        set str_list [regexp -inline -all {\S*} $str]
        if {[lindex $str_list 0] == ""} {continue}
        set str $appendix
        append str [lindex $str_list 0]
        lappend tmp $str
        if {[eof $fd]} {
            break
        }
    }
    close $fd
    return 0
}




##############################################################################################

proc VgFile::GetColumnFromFile {data_list fr_int pow_count filename} {
    upvar $data_list tmp
    set tmp ""

    if { [catch {open $filename r} fd] } {
        Vg::LogLine "Could not open $filename for reading"
        return 1
    }
#    Vg::LogLine "Open file for reading: $filename"
    set j 0
    while {1} {
        set str [gets $fd]
        if {[eof $fd]} {
            break
        }
        if {[regexp {^#} $str]} {continue}
        if {[regexp {^!} $str]} {
            set str_list [regexp -inline -all {\S*} $str]
            set str [lindex $str_list 2]
            
            switch -- $str {
                power {
                        incr j
                        set i 0
                        while {1} {
                            set str [gets $fd]
                            if {[regexp {^#} $str]} {continue}
                            set str_list [regexp -inline -all {\S*} $str]
                            if {[lindex $str_list 0] == ""} {continue}                            
                            if {[lindex $str_list 2] == ""} {
                                Vg::LogLine "Error. Bad data structure for power: $power"
                                close $fd
                                return 1
                            } else {
                                    if {$i == $fr_int} {
                                        lappend tmp [lindex $str_list 2]
                                        if {$j == $pow_count} {return 0}
                                        break
                                    }
                                    incr i
                                }
                            }
                            if {[eof $fd]} {
                                Vg::LogLine "Warning. Unsufficient data points for power: $power"
                                close $fd
                                return 1
                            }
                        }

                default {
                    continue
                }
            }
        }    
    }
    Vg::LogLine "Error. Can't find data for frequency: $fr_int"
    close $fd
    return 1
}

proc VgFile::GetValuesFromColumn {data_list D} {
    if {$D <= [lindex $data_list 0]} {return 0}
    set j [llength $data_list]
    for {set i 0} {$i <= $j} {incr i} {
        if {$D <= [lindex $data_list $i]} {return [expr $i-1]}
    }
    if {$i >= [expr $j-1]} {set i [expr $j-1]}
    return [expr $i-1]
}