namespace eval VgDlg {
    variable about_dlg;

}

proc VgDlg::About {} {
    global EXE_COMPILE
    set VgDlg::about_dlg [Dialog .comselectdlg -parent . -modal local \
                 -separator false \
                 -title   "About" \
                 -side    bottom    \
                 -anchor  e  \
                 -default 0 -cancel 1];
    set titf [frame $VgDlg::about_dlg.titf];
    
    set titf1 [frame $titf.titf1]
    set titf2 [frame $titf.titf2]
    set titf3 [frame $titf.titf3]
    set titf4 [frame $titf.titf4]
    set titf5 [frame $titf.titf5]
    set titf6 [frame $titf.titf6]
    
#    set canvas_logo [canvas $titf1.canvas_logo]
    if {$EXE_COMPILE == 0} {
	image create photo logo_image_data -file "$Vg::VgDIR/adv_label.gif"
    } else {
	image create photo logo_image_data -file "/adv_label.gif"
    }
    set logo_image [label $titf1.logo_image -image logo_image_data]
    set label_rights [label $titf2.label_rights \
                     -text "Copyright (c) 2004-2008 Advantex LLC. All rights reserved." ];
    set label_license [label $titf3.label_license \
                     -text "License Information:" ];    
    variable entry_licence [entry $titf3.entry_licence \
	    -justify "center" \
            -state disable \
	    -textvariable "Vg::licence" ]    
    set label_version [label $titf4.label_license \
                     -text "Software version:" ];    
    variable entry_version [entry $titf4.entry_version \
	    -justify "center" \
            -state disable \
	    -textvariable "Vg::program_sw_version" ]     
    set label_support [label $titf5.label_support \
                     -text "All your questions please mail to support@advantex.ru" ];
    variable button_ok [button $titf6.button_ok \
	    -command "VgDlg::AboutDlgOk" \
	    -text "OK" \
	    -width 16] 
    #set combobaund [ComboBox $titf2.combobaund -textvariable Vg::baundrate \
    #                 -editable false -values $Vg::baund_select \
    #                 -width 6 ];
    #
    #set combodatabits [ComboBox $titf3.combodatabits -textvariable Vg::databits \
    #                 -editable false -values $Vg::databits_select \
    #                 -width 6 ];
    #
    #set comboparity [ComboBox $titf4.comboparity -textvariable Vg::parity \
    #                 -editable false -values [array names Vg::parity_select] \
    #                 -width 6 ];
    #
    #set labelcom [label $titf1.labelcom -text "COM port select:"];
    #set labelbaund [label $titf2.labelbaund -text "Bits per second:"];    
    #set labeldatabits [label $titf3.labeldatabits -text "Data bits:"];      
    #set labelparity [label $titf4.labelparity -text "Parity:"];    
    #set labelstopbits [label $titf5.labelstopbits -text "Stop bits:"];

    #pack $comcombo $labelcom -padx 4 -fill both -side right;
    #pack $combobaund $labelbaund -padx 4 -fill both -side right;
    #pack $combodatabits $labeldatabits -padx 4 -fill both -side right;    
    #pack $comboparity $labelparity -padx 4 -fill both -side right;
    
    pack $titf1 $titf2 $titf3 $titf4 $titf5 $titf6 -padx 2 -pady 2 -fill both -fill both -expand yes;    
    pack $titf -padx 4 -fill both -expand yes;

    pack $logo_image $label_rights
    pack $label_license $entry_licence -anchor w
    pack configure $entry_licence -fill both -expand yes
    pack $label_version $entry_version -anchor w
    pack configure $entry_version -fill both -expand yes    
    pack $label_support
    pack $button_ok
    
    $VgDlg::about_dlg draw;

    destroy $VgDlg::about_dlg
}

proc VgDlg::AboutDlgOk {} {
    destroy $VgDlg::about_dlg
}

proc VgDlg::COMconfigure {} {
    
    set dlg [Dialog .comselectdlg -parent . -modal local \
                 -separator false \
                 -title   "COM port configure" \
                 -side    bottom    \
                 -anchor  e  \
                 -default 0 -cancel 1];
    set titf [TitleFrame [$dlg getframe].titf -text "Setup"];
    
    set titf1 [frame [$titf getframe].titf1]
    set titf2 [frame [$titf getframe].titf2]
    set titf3 [frame [$titf getframe].titf3]
    set titf4 [frame [$titf getframe].titf4]
    set titf5 [frame [$titf getframe].titf5]

    set comcombo [ComboBox $titf1.comcombo -textvariable Vg::serialport \
                     -editable false -values $Vg::com_select \
                     -width 6 ];
    set combobaund [ComboBox $titf2.combobaund -textvariable Vg::baundrate \
                     -editable false -values $Vg::baund_select \
                     -width 6 ];

    set combodatabits [ComboBox $titf3.combodatabits -textvariable Vg::databits \
                     -editable false -values $Vg::databits_select \
                     -width 6 ];

    set comboparity [ComboBox $titf4.comboparity -textvariable Vg::parity \
                     -editable false -values [array names Vg::parity_select] \
                     -width 6 ];
    
    set labelcom [label $titf1.labelcom -text "COM port select:"];
    set labelbaund [label $titf2.labelbaund -text "Bits per second:"];    
    set labeldatabits [label $titf3.labeldatabits -text "Data bits:"];      
    set labelparity [label $titf4.labelparity -text "Parity:"];    
    set labelstopbits [label $titf5.labelstopbits -text "Stop bits:"];

    pack $comcombo $labelcom -padx 4 -fill both -side right;
    pack $combobaund $labelbaund -padx 4 -fill both -side right;
    pack $combodatabits $labeldatabits -padx 4 -fill both -side right;    
    pack $comboparity $labelparity -padx 4 -fill both -side right;
    
    pack $titf1 $titf2 $titf3 $titf4 $titf5 -padx 4 -pady 10 -fill both -anchor e;    
    pack $titf -padx 4 -fill both -expand yes;

    $dlg add -name ok;
    $dlg add -name cancel;
    
    $dlg draw;

    destroy $dlg

}
