namespace eval VgCRC {

    set INITIAL_16bitCRCnormal 0x0000
#    set POLYNOM_16bitCRCnormal 0x8005
    set POLYNOM_16bitCRCnormal 0xA001
}

proc VgCRC::CalculateHEXCRC {str} {
    set strlist [regexp -inline -all -- {..} $str]
    set CRC 0x00
    foreach var $strlist {
        set CRC [expr $CRC + 0x$var]
    }
    set CRC [expr ((0xFF - $CRC & 0xFF)+1) & 0xFF]
    return [format "%02X" $CRC]
}

proc VgCRC::CheckStringCRC {strlist} {
# 0 - Ok
# 1 - Error
    set CRC 0
    set str_number_bytes [ expr [llength $strlist]]
    for {set i 0} {$i < $str_number_bytes} {incr i} {
        set CRC [expr $CRC + 0x[lindex $strlist $i]]
    }
    set CRC [expr $CRC & 0xFF]
    if {$CRC == 0} {return 0}
    return 1
}

proc VgCRC::Calculate16bitCRCnormal {str_list} {
    # MSB first
#    global INITIAL_16bitCRCnormal POLYNOM_16bitCRCnormal
    Vg::LogLine "Calculate CRC... Please wait..."
    update
    set j 0
    set n [expr [llength $str_list]/100]
    set Vg::var_progressbar 0
    Vg::OnProgressBar [expr 100]
    update
    set t [clock seconds]
    set initial [expr $VgCRC::INITIAL_16bitCRCnormal]
    set polynom [expr $VgCRC::POLYNOM_16bitCRCnormal]
    set result $initial
    foreach var $str_list {
        if {$j == $n} {incr Vg::var_progressbar; set j 0; update}
        set result [expr $result ^ 0x$var << 8]
        for {set i 0} {$i<8} {incr i} {
            if {[expr $result & 0x8000]!=0} {set result [expr ($result << 1) ^ $polynom]} else {
                    set result [expr $result << 1]
                }
        }
        incr j        
    }
    set result [expr $result & 0xFFFF]
    set result [format "%04X" $result]
    set result [regexp -inline -all -- {\w\w} $result]
    Vg::LogLine "Done in [expr [clock seconds]-$t] seconds"
    Vg::OffProgressBar
    return $result
}

proc VgCRC::FastCalculate16bitCRCnormal {str_list} {
    # MSB first
    set crcTable [VgCRC::CalculateCRC16Table]

    Vg::LogLine "Calculate CRC... Please wait..."
    update
    set j 0
    set n [expr [llength $str_list]/100]
    set Vg::var_progressbar 0
    Vg::OnProgressBar [expr 100]
    update
    set t [clock seconds]
    set remainder 0;
    foreach var $str_list {
        if {$j == $n} {incr Vg::var_progressbar; set j 0; update}
        set remainder [expr (($remainder << 8) ^ [lindex $crcTable [expr ($remainder >> 8) ^ 0x$var]]) & 0xFFFF]
        incr j
    }
    set result [expr $remainder & 0xFFFF]
    set result [format "%04X" $result]
    set result [regexp -inline -all -- {\w\w} $result]
    Vg::LogLine "Done in [expr [clock seconds]-$t] seconds"
    Vg::OffProgressBar
    return $result

}

proc VgCRC::CalculateCRC16Table {} {
#    set WIDTH 16;
#    global POLYNOM_16bitCRCnormal
    set polynom [expr $VgCRC::POLYNOM_16bitCRCnormal]
    list crcTable "";
    
    for {set dividend  0} {$dividend < 256} {set dividend [expr $dividend+1]} {
        set remainder [ expr $dividend << 8]

        for {set bit 8} { $bit > 0} {set bit [expr $bit-1]} {			
            if {[expr $remainder & 0x8000]!=0} {
                set remainder [expr ($remainder << 1) ^ $polynom]
            } else {
                set remainder [expr $remainder << 1]
            }
        }
        lappend crcTable [ expr $remainder & 0xFFFF]
    }
    return $crcTable
}

proc VgCRC::CalculatePoint4Liner {x0 x1 y0 y1 x} {
    set y [expr ($y1-$y0)*($x-$x0)/(1.0*($x1-$x0))+$y0]
    return $y
}