namespace eval VgConfig {

}

proc VgConfig::create { nb } {
    set frame [$nb insert end VgConfig -text "Config"]
    set titf [LabelFrame  $frame.titf];   

    _gctl [$titf getframe]
    
    pack $titf -padx 4 -pady 4 -fill both -anchor center;      

    return $frame
}
proc VgConfig::_gctl { root } {
    # this handles '.' as a special case
    set base [expr {($root == ".") ? "" : $root}]
    variable ROOT $root
    variable BASE $base
    variable SCRIPTDIR ;


    # Widget Initialization
    variable _labelframe_conf_data [labelframe $BASE._labelframe_conf_data \
	    -text "Configuration data"]
    variable _labelframe_refclk [labelframe $BASE._labelframe_refclk \
	    -text "Reference clock"]
    variable _labelframe_outfile [labelframe $BASE._labelframe_outfile \
	    -text "Output file"]
    variable _labelframe_program [labelframe $BASE._labelframe_program \
	    -text "Programming"]
    
    pack $_labelframe_conf_data $_labelframe_refclk $_labelframe_outfile $_labelframe_program -expand yes -fill x
    
    variable fr1_conf_data [frame $_labelframe_conf_data.fr1_conf_data]
    variable fr11_conf_data [frame $_labelframe_conf_data.fr11_conf_data]    
    variable fr2_conf_data [frame $_labelframe_conf_data.fr2_conf_data]
    variable fr3_conf_data [frame $_labelframe_conf_data.fr3_conf_data]
    variable fr4_conf_data [frame $_labelframe_conf_data.fr4_conf_data]

    variable fr1_refclk [frame $_labelframe_refclk.fr1_refclk]
    variable fr2_refclk [frame $_labelframe_refclk.fr2_refclk]
    variable fr3_refclk [frame $_labelframe_refclk.fr3_refclk]
    
    pack $fr1_conf_data $fr11_conf_data $fr2_conf_data $fr3_conf_data $fr4_conf_data -expand yes -fill x -pady "4 4"
    pack $fr1_refclk $fr2_refclk $fr3_refclk -expand yes -fill x -pady "4 4"
    
#    variable _frame_1 [frame $BASE._frame_1]
#    variable _frame_2 [frame $BASE._frame_2]
#    variable _frame_refclk1 [frame $BASE._frame_refclk1]
#    variable _frame_refclk2 [frame $BASE._frame_refclk2]    
    variable _entry_pid [entry $fr1_conf_data._entry_pid \
	    -textvariable Vg::device_pid \
	    -justify right \
	    -invalidcommand [namespace code [list _entry_pid_invalidcommand]] \
	    -validatecommand [namespace code [list _entry_pid_validatecommand]] \
	    -width 10 ]
    variable _label_1 [label $fr1_conf_data._label_1 \
	    -text "Product ID"]
    
    pack $_entry_pid $_label_1 -side left
    pack configure $_entry_pid -padx "50 10"

    variable _entry_lot [entry $fr11_conf_data._entry_lot \
	    -textvariable Vg::device_lot \
	    -justify right \
	    -width 10 ]

    variable _label_11 [label $fr11_conf_data._label_11 \
	    -text "Product Lot"]
    
    pack $_entry_lot $_label_11 -side left
    pack configure $_entry_lot -padx "50 10"

    
    variable _entry_sid [entry $fr2_conf_data._entry_sid \
	    -textvariable Vg::device_sid \
	    -justify right \
	    -invalidcommand [namespace code [list _entry_sid_invalidcommand]] \
	    -validatecommand [namespace code [list _entry_sid_validatecommand]] \
	    -width 10 ]
    variable _label_2 [label $fr2_conf_data._label_2 \
	    -text "Software ID"]    
    
    pack $_entry_sid $_label_2 -side left
    pack configure $_entry_sid -padx "50 10"
    
    variable _entry_sn [entry $fr3_conf_data._entry_sn \
	    -textvariable Vg::device_sn \
	    -justify right \
	    -invalidcommand [namespace code [list _entry_sn_invalidcommand]] \
	    -validatecommand [namespace code [list _entry_sn_validatecommand]] \
	    -width 10 ]
    
    variable _label_3 [label $fr3_conf_data._label_3 \
	    -text "Serial Number"]
    
    pack $_entry_sn $_label_3 -side left
    pack configure $_entry_sn -padx "50 10"    
    
    variable _spinbox_dd [spinbox $fr4_conf_data._spinbox_dd \
	    -textvariable Vg::date_dd \
	    -command VgConfig::_spinbox_dd_command \
	    -from 1 \
	    -invalidcommand [namespace code [list _spinbox_dd_invalidcommand]] \
	    -justify "right" \
	    -to 31 \
	    -validatecommand [namespace code [list _spinbox_dd_validatecommand]] \
	    -width 2 \
	    -xscrollcommand VgConfig::_spinbox_dd_xscrollcommand]
    variable _spinbox_mm [spinbox $fr4_conf_data._spinbox_mm \
	    -textvariable Vg::date_mm \
	    -command VgConfig::_spinbox_mm_command \
	    -from 1 \
	    -invalidcommand [namespace code [list _spinbox_mm_invalidcommand]] \
	    -justify "right" \
	    -to 12 \
	    -validatecommand [namespace code [list _spinbox_mm_validatecommand]] \
	    -width 2 \
	    -xscrollcommand VgConfig::_spinbox_mm_xscrollcommand]
    variable _spinbox_yyyy [spinbox $fr4_conf_data._spinbox_yyyy \
	    -textvariable Vg::date_yyyy \
	    -command VgConfig::_spinbox_yyyy_command \
	    -from 1970 \
	    -invalidcommand [namespace code [list _spinbox_yyyy_invalidcommand]] \
	    -justify "right" \
	    -to 2225 \
	    -validatecommand [namespace code [list _spinbox_yyyy_validatecommand]] \
	    -width 4 \
	    -xscrollcommand VgConfig::_spinbox_yyyy_xscrollcommand]
    
    pack $_spinbox_dd $_spinbox_mm $_spinbox_yyyy -side left
    pack configure $_spinbox_dd -padx "50 0"     
    pack configure $_spinbox_mm -padx "10 10"  


    
    
    
    variable _entry_fr_1ghz [entry $fr1_refclk._entry_fr_1ghz \
	    -textvariable Vg::fr_1ghz \
	    -justify right \
            -validatecommand "VgConfig::entry_fr_1ghz_change" \
            -validate all \
	    -width 12 ]
    variable _label_7 [label $fr1_refclk._label_7 \
	    -text "1 GHz frequency"]    
    variable _label_8 [label $fr1_refclk._label_8 \
	    -text "MHz"]
    
    pack $_label_7 $_entry_fr_1ghz $_label_8 -side left    
    pack configure $_label_7 -padx "20 0"
    pack configure $_entry_fr_1ghz -padx "10 10"    
    
    
    variable _entry_ref_clk [entry $fr2_refclk._entry_ref_clk \
	    -state disable \
	    -textvariable Vg::flash_ref_clk \
	    -justify right \
	    -width 12 ]
    variable _label_9 [label $fr2_refclk._label_9 \
	    -text "Ref frequency"] 
    variable _label_10 [label $fr2_refclk._label_10 \
	    -text "Hz"]

    pack $_label_9 $_entry_ref_clk $_label_10 -side left 
    pack configure $_label_9 -padx "31 0"
    pack configure $_entry_ref_clk -padx "10 10"  

#    variable _label_4 [label $BASE._label_4 \
#	    -text ""]
#    variable _label_5 [label $BASE._label_5 \
#	    -text ""]
#    variable _label_6 [label $BASE._label_6 \
#	    -text ""]

    variable _label_11 [label $fr3_refclk._label_11 \
	    -text "Set 1 GHz output"]    
    variable _button_set_1ghz [button $fr3_refclk._button_set_1ghz \
	    -command "VgConfig::set_1ghz" \
	    -text "Set" \
	    -state disable \
	    -width 8]   
    
    pack $_label_11 $_button_set_1ghz  -side left 

    pack configure $_label_11 -padx "18 0"
    pack configure $_button_set_1ghz -padx "10 10" 

    variable _frame_outfile1 [frame $BASE._frame_outfile1]
    variable _frame_outfile2 [frame $BASE._frame_outfile2]
    variable _frame_outfile3 [frame $BASE._frame_outfile3]
    
    variable _button_save_config_file [button $BASE._button_save_config_file \
	    -command "VgConfig::SaveConfigFile" \
	    -text "Save" \
	    -state normal \
	    -width 8]
    variable _button_import_config_file [button $BASE._button_import_config_file \
	    -command "VgConfig::ButtonImportConfigFile" \
	    -text "Import" \
	    -state normal \
	    -width 8]
    variable _label_save_file [label $BASE._label_save_file \
	    -text "Save configuration data to file"]
    variable _label_import_file [label $BASE._label_import_file \
	    -text "Import configuration data from file"]
    
    pack $_frame_outfile2 $_frame_outfile3 -in $_labelframe_outfile
    pack $_frame_outfile2 -anchor "e" -pady "5"
    pack $_frame_outfile3 -anchor "e" -pady "5"
    pack $_button_save_config_file $_label_save_file -in $base._frame_outfile2 -side right
    pack $_button_import_config_file $_label_import_file -in $base._frame_outfile3 -side right
    pack $_button_save_config_file -padx "5 10"    
    pack $_button_import_config_file -padx "5 10"    
    
    variable _button_program_config_file [button $_labelframe_program._button_program_config_file \
	    -command "VgConfig::ProgramConfig" \
	    -text "Program" \
	    -width 8]
    variable _button_read_config [button $_labelframe_program._button_read_config \
	    -command "VgConfig::ButtonReadConfig" \
	    -text "Read" \
	    -width 8] 

    pack $_button_program_config_file -side left -padx "50 20" -pady "4 8"

    pack $_button_read_config -side right -padx "20 50" -pady "4 8"
}

proc VgConfig::_spinbox_mm_xscrollcommand { arg1 arg2} {
    
}
proc VgConfig::_spinbox_mm_command { } {
    
}

proc VgConfig::_spinbox_dd_xscrollcommand { arg1 arg2} {
    
}
proc VgConfig::_spinbox_dd_command { } {
    
}

proc VgConfig::_spinbox_yyyy_xscrollcommand { arg1 arg2} {
    
}
proc VgConfig::_spinbox_yyyy_command { } {
    
}
proc VgConfig::set_1ghz {} {
    set tmp_fr_ref $Vg::fr_ref
    set Vg::fr_ref [Vg::ReadRefFrequency 0]
    VgLNO::InitButton
    set tmp $Vg::fr_out
    set Vg::fr_out 1000
    VgLNO::LoadFrButton
    set Vg::fr_out $tmp
    set Vg::fr_ref $tmp_fr_ref
}
proc _entry_sn_validatecommand {} {

    
}

proc VgConfig::SaveConfigFile {} {
    global ENDOFFILE
    variable b
    variable a
    set types {{{LNO configuration file} {.conf}}}
    set tmp_initfile $Vg::SAVECONFDIR
    append tmp_initfile "save_conf.conf"
    if {[set Vg::saveconfigfilename [tk_getSaveFile -initialdir $Vg::SAVECONFDIR -initialfile $tmp_initfile -filetypes $types ]] ne ""} {
    regexp {.*(/)} "$Vg::saveconfigfilename"  Vg::SAVECONFDIR
        if {[VgFile::CreateConfigFile $Vg::saveconfigfilename]} {return 1}
        Vg::LogLine "Configuration data are saved to file successfully"
    }
}

proc VgConfig::ButtonImportConfigFile {} {
    set types {{{RWM configuration file} {.conf}}}
    if {[set Vg::saveconfigfilename [tk_getOpenFile -initialdir $Vg::SAVECONFDIR -filetypes $types ]] ne ""} {
        regexp {.*(/)} "$Vg::saveconfigfilename"  Vg::SAVECONFDIR
        VgConfig::ImportConfigFile $Vg::saveconfigfilename
    }
}

proc VgConfig::ImportConfigFile {filename} {

#    if { [catch {open $filename r} fd] } {
#        Vg::LogLine "Could not open $filename for reading"
#        return 1
#    }
#    Vg::LogLine "Open file for reading: \n$filename"
    set block [VgFile::GetDataFromHex $filename 0 32]
    if {$block != 0} {
        if { [VgFile::SetConfigInformation $block] == 0} {Vg::LogLine "Configuration data are imported successfully"}
    } else {
        Vg::LogLine "Fail to import data"
    }
#    close $fd  
}


proc VgConfig::ProgramConfig {} {
    variable serial;
#    if {[VgCOM::open_serial serial]} then {return 1}
#    close $serial
    set tmp_filename ""
    append tmp_filename $Vg::FLASHDIR $Vg::TEMPCONFIGFILENAME
#    Vg::LogLine "$Vg::FLASHDIR"
    VgFile::CreateConfigFile $tmp_filename
    VgFile::LoadFile2Flash $tmp_filename
}

proc VgConfig::ButtonReadConfig {} {
variable tmp_initfile "";
    set types {{{LNO configuration file} {.conf}}}
#    append tmp_initfile $Vg::CONFFILEDIR $Vg::DEFAULT_READCONFIGFLASH_FILENAME
    if {[set filename [tk_getSaveFile -initialdir $Vg::FLASHDIR -initialfile $Vg::read_config_filename -filetypes $types]] ne ""} {
        VgConfig::ReadConfig $filename
        Vg::LogLine "Configuration data are read from file and saved to file successfully"
    }    
}

proc VgConfig::ReadConfig {filename} {
    if {[VgFile::LoadFlash2File1 $filename 0 256]} {return 1}
    return 0
}


proc VgConfig::entry_fr_1ghz_change {} {
    catch {set Vg::flash_ref_clk [format "%.0f" [expr $Vg::fr_1ghz*$Vg::fr_ref*1000]]}
    return 1
}