namespace eval VgCOM {

}

proc VgCOM::open_serial {serial} {
    upvar $serial tmp
    if { [catch {open $Vg::serialport w+} tmp] } {
        Vg::LogLine "Could not open serial port $Vg::serialport"
        return 1 }
    fconfigure $tmp -mode $Vg::baundrate,$Vg::parity_select($Vg::parity),$Vg::databits,$Vg::stopbits
    fconfigure $tmp -blocking 1 -buffering none -encoding binary -translation binary     
    return 0
}

proc VgCOM::open_channel {serial} {
    upvar $serial tmp
    if { [catch {open $Vg::serialport w+} tmp] } {
        Vg::LogLine "Could not open serial port $Vg::serialport"
        return 1 }
    fconfigure $tmp -mode $Vg::baundrate,$Vg::parity_select($Vg::parity),$Vg::databits,$Vg::stopbits
    fconfigure $tmp -blocking 1 -buffering none -encoding binary -translation binary     
    return 0
}

proc VgCOM::close_channel {serial} {
    close $serial   
    return 0
}

proc VgCOM::puts_com {serial data} {
    set answer_cmd "";
    puts -nonewline $serial [binary format H2H2 $data [format "%02X" [expr  255 - [expr 0x$data]]]]
    set t [clock seconds]
    set i 0
    while {1} {
        catch {read $serial 1} answer_cmd
        if {$answer_cmd ne ""} {break}
        incr i
        if {$i == 100} {
            set t1 [clock seconds]
            if {($t1-$t) >= 2} {return 2}
            set i 0
        }
    }
    binary scan $answer_cmd c answer_cmd
    set answer_cmd [expr $answer_cmd & 0xFF]
    if {$answer_cmd != [expr  255 - [expr 0x$data]]} then {return 1}
    return 0
}
proc VgCOM::puts_data {serial com data answer} {
    upvar $answer var
    puts -nonewline $serial [binary format H2H2H2 $com [format "%02X" [expr  255 - [expr 0x$com]]] [format "%02X" [expr 0x$data & 0xFF]]]

    set t [clock seconds]
    set i 0
    while {1} {
        catch {read $serial 1} answer_cmd
        if {$answer_cmd ne ""} {break}
        incr i
        if {$i == 100} {
            set t1 [clock seconds]
            if {($t1-$t) >= 2} {return 2}
            set i 0
        }
    }
    binary scan $answer_cmd c answer_cmd
    set answer_cmd [expr $answer_cmd & 0xFF]
    set t [clock seconds]
    set i 0
    while {1} {
        catch {read $serial 1} answer
        if {$answer ne ""} {break}
        incr i
        if {$i == 100} {
            set t1 [clock seconds]
            if {($t1-$t) >= 2} {return 2}
            set i 0
        }
    }
    binary scan $answer c answer
    set answer [expr $answer & 0xFF]    
    if {$answer_cmd != [expr  255 - [expr 0x$com]]} then {return 1}
    set var [format "%02X" $answer]
    return 0
}

proc VgCOM::gets_page {serial adr answer} {
    upvar $answer answer_list
    set answer_list "";
    set answer_cmd "";
    set CRC 0;
    set adr1 [expr ($adr >> 16) & 0x01]
    set adr2 [expr ($adr >> 8) & 0xFF]
    set tmp [expr ($adr1 + $adr2) & 0xFF]
    set tmp [expr (0xFF - $tmp) & 0xFF]
#    Vg::LogLine "adr: $adr"
#    Vg::LogLine "adr1: $adr1"
#    Vg::LogLine "adr2: $adr2"
    puts -nonewline $serial [binary format H2H2H2 [format "%02X" $adr1] [format "%02X" $adr2] [format "%02X" $tmp]]
    set t [clock seconds]
    set i 0
    while {1} {
        catch {read $serial 1} answer_cmd
        if {$answer_cmd ne ""} {break}
        incr i
        if {$i == 100} {
            set t1 [clock seconds]
            if {($t1-$t) >= 2} {return 2}
            set i 0
        }
    }
    binary scan $answer_cmd c answer_cmd
    set answer_cmd [expr $answer_cmd & 0xFF]
    if {$answer_cmd != 0} then {return 1}
    
    for {set count 0} {$count < 256} {incr count} {
        set t [clock seconds]
        set i 0
        while {1} {
            catch {read $serial 1} answer_cmd
            if {$answer_cmd ne ""} {break}
            incr i
            if {$i == 100} {
                set t1 [clock seconds]
                if {($t1-$t) >= 2} {return 2}
                set i 0
            }
        }
        binary scan $answer_cmd c answer_cmd
        set answer_cmd [expr $answer_cmd & 0xFF]        
        lappend answer_list [format "%02X" $answer_cmd]
        set CRC [expr ($CRC + $answer_cmd) & 0xFF]
    }
    set CRC [expr (0xFF - ($CRC & 0xFF)) & 0xFF]
    set t [clock seconds]
    set i 0
    while {1} {
        catch {read $serial 1} answer_cmd
        if {$answer_cmd ne ""} {break}
        incr i
        if {$i == 100} {
            set t1 [clock seconds]
            if {($t1-$t) >= 2} {return 2}
            set i 0
        }
    }
    binary scan $answer_cmd c answer_cmd
    set answer_cmd [expr $answer_cmd & 0xFF]
#    Vg::LogLine "answer_cmd: $answer_cmd"
#    Vg::LogLine "CRC: $CRC"
    
    if { $answer_cmd != $CRC } then {return 1}
    
    return 0
}

proc VgCOM::puts_page {serial adr data_list} {
    
#    global CMD_WR_FL_P 
    set answer_cmd "";

#   CMD_RD_FL_P command
#    if {[VgCOM::puts_com $serial $CMD_WR_FL_P] && !$Vg::debugen} then {return 1}

    puts -nonewline $serial [binary format H2H2 $Vg::cmd_wr_fl_p [format "%02X" [expr  255 - [expr 0x$Vg::cmd_wr_fl_p]]]]
    set t [clock seconds]
    set i 0
    while {1} {
        catch {read $serial 1} answer_cmd
        if {$answer_cmd ne ""} {break}
        incr i
        if {$i == 100} {
            set t1 [clock seconds]
            if {($t1-$t) >= 2} {return 2}
            set i 0
        }
    }
    binary scan $answer_cmd c answer_cmd
    set answer_cmd [expr $answer_cmd & 0xFF]
#    Vg::LogLine "answer_cmd: $answer_cmd"
    if {$answer_cmd != [expr  255 - [expr 0x$Vg::cmd_wr_fl_p]]} then {return 1}

    set CRC 0;
    set adr1 [expr ($adr >> 16) & 0x01]
    set adr2 [expr ($adr >> 8) & 0xFF]
    set tmp [expr ($adr1 + $adr2) & 0xFF]
    set tmp [expr (0xFF - $tmp) & 0xFF]
    puts -nonewline $serial [binary format H2H2H2 [format "%02X" $adr1] [format "%02X" $adr2] [format "%02X" $tmp]]
    set t [clock seconds]
    set i 0

    while {1} {
        catch {read $serial 1} answer_cmd
        if {$answer_cmd ne ""} {break}
        incr i
        if {$i == 100} {
            set t1 [clock seconds]
            if {($t1-$t) >= 2} {return 2}
            set i 0
        }
    }
        
    binary scan $answer_cmd c answer_cmd
    set answer_cmd [expr $answer_cmd & 0xFF]
#    Vg::LogLine "answer_cmd: $answer_cmd"
    if {$answer_cmd != 0} then {return 2}
    
    for {set count 0} {$count < 256} {incr count} {
        set tmp [lindex $data_list $count]
        set CRC [expr ($CRC + 0x$tmp) & 0xFF]
        puts -nonewline $serial [binary format H2 $tmp]
    }
    set CRC [expr (0xFF - ($CRC & 0xFF)) & 0xFF]
    set answer_cmd "";
    catch {flush $serial} answer_cmd

    set t [clock seconds]
    set i 0
    while {1} {
        catch {read $serial 1} answer_cmd
        if {$answer_cmd ne ""} {break}
        incr i
        if {$i == 100} {
            set t1 [clock seconds]
            if {($t1-$t) >= 2} {return 2}
            set i 0
        }
    }

#    if {$answer_cmd ne ""} {
        binary scan $answer_cmd c answer_cmd
        set answer_cmd [expr $answer_cmd & 0xFF]
#    }
#    Vg::LogLine "answer_cmd: $answer_cmd"

    if { $answer_cmd != $CRC } then {return 1}
    
    return 0
}

proc VgCOM::GetPageFromFlash {serial adr page} {
    upvar $page answer
#    global CMD_RD_FL_P 
    
#   CMD_RD_FL_P command
    if {[VgCOM::puts_com $serial $Vg::cmd_rd_fl_p] && !$Vg::debugen} then {return 1} 
#   adr
    if {[VgCOM::gets_page $serial $adr answer] != 0} then {Vg::LogLine "Vg::GetPageFromFlash -> error"; Vg::LogLine "answer: $answer"; Vg::LogLine "bytes: [llength $answer]"}
    
        
    return 0
}

proc VgCOM::GetByteFromFlash {serial adr answerout} {
    upvar $answerout answer
    global FLASH_CMD_WRSR FLASH_CMD_WREN CPLD_ADR_WR_FLASH CPLD_ADR_RD_FLASH FLASH_CMD_WRITE FLASH_CMD_READ 
    
    set data $CPLD_ADR_RD_FLASH
    append data $FLASH_CMD_READ
    append data [format "%06X" [expr 0x$Vg::adr & 0x01FFFF]]
    append data "00"
    
    VgCOM::put_channel $serial $data 0 answer 

    return 0
}

proc VgCOM::put_channel {serial datastr zerobytes answerstr} {
#    global CMD_SS0_LOW CMD_SS0_HIGH CMD_SPI0 CMD_SS1_LOW CMD_SS1_HIGH CMD_SPI1
    
    upvar $answerstr answer_var
    set answer_var "";
    update

    Vg::LogLine "VgCOM::put_channel: 0x$datastr"
#    Vg::LogLine "zerobytes: $zerobytes"    
    
    
#   SS to 0
    puts -nonewline $serial [binary format H2H2 $Vg::cmd_ss_low [format "%02X" [expr  255 - [expr 0x$Vg::cmd_ss_low]]]]

    catch {read $serial 1} answer_cmd

    binary scan $answer_cmd c answer_cmd
    set answer_cmd [expr $answer_cmd & 0xFF]
    if {$answer_cmd != [expr  255 - [expr 0x$Vg::cmd_ss_low]]} then {return 1}

#   put data
    set datalist [regexp -inline -all -- {..} $datastr]
    foreach var $datalist {
#        Vg::LogLine "var: $var"
        puts -nonewline $serial [binary format H2H2H2 $Vg::cmd_spi [format "%02X" [expr  255 - [expr 0x$Vg::cmd_spi]]] [format "%02X" [expr 0x$var & 0xFF]]]

        catch {read $serial 1} answer_cmd
        binary scan $answer_cmd c answer_cmd
        set answer_cmd [expr $answer_cmd & 0xFF]
        
        catch {read $serial 1} answer
        binary scan $answer c answer
        set answer [expr $answer & 0xFF]    
        if {$answer_cmd != [expr  255 - [expr 0x$Vg::cmd_spi]]} then {return 1}

        append answer_var [format "%02X" $answer]
    }

#   SS to 1
    puts -nonewline $serial [binary format H2H2 $Vg::cmd_ss_high [format "%02X" [expr  255 - [expr 0x$Vg::cmd_ss_high]]]]

    catch {read $serial 1} answer_cmd

    binary scan $answer_cmd c answer_cmd
    set answer_cmd [expr $answer_cmd & 0xFF]
    if {$answer_cmd != [expr  255 - [expr 0x$Vg::cmd_ss_high]]} then {return 1}

#   put zero bytes    
    
    for {set i 0} {$i<$zerobytes} {incr i} {
        puts -nonewline $serial [binary format H2H2H2 $Vg::cmd_spi [format "%02X" [expr  255 - [expr 0x$Vg::cmd_spi]]] 00]

        catch {read $serial 1} answer_cmd
        binary scan $answer_cmd c answer_cmd
        set answer_cmd [expr $answer_cmd & 0xFF]
        
        catch {read $serial 1} answer
        binary scan $answer c answer
        set answer [expr $answer & 0xFF]    
        if {$answer_cmd != [expr  255 - [expr 0x$Vg::cmd_spi]]} then {return 1}

    }

    return 0
}

proc VgCOM::_put_channel {serial datastr zerobytes answerstr} {
#    global CMD_SS0_LOW CMD_SS0_HIGH CMD_SPI0 CMD_SS1_LOW CMD_SS1_HIGH CMD_SPI1
    
    upvar $answerstr answer_var
    set answer_var "";
    update
    
#   SS to 0
    puts -nonewline $serial [binary format H2H2 $Vg::cmd_ss_low [format "%02X" [expr  255 - [expr 0x$Vg::cmd_ss_low]]]]

    catch {read $serial 1} answer_cmd

    binary scan $answer_cmd c answer_cmd
    set answer_cmd [expr $answer_cmd & 0xFF]
    if {$answer_cmd != [expr  255 - [expr 0x$Vg::cmd_ss_low]]} then {return 1}

#   put data
    set datalist [regexp -inline -all -- {..} $datastr]
    foreach var $datalist {
#        Vg::LogLine "var: $var"
        puts -nonewline $serial [binary format H2H2H2 $Vg::cmd_spi [format "%02X" [expr  255 - [expr 0x$Vg::cmd_spi]]] [format "%02X" [expr 0x$var & 0xFF]]]

        catch {read $serial 1} answer_cmd
        binary scan $answer_cmd c answer_cmd
        set answer_cmd [expr $answer_cmd & 0xFF]
        
        catch {read $serial 1} answer
        binary scan $answer c answer
        set answer [expr $answer & 0xFF]    
        if {$answer_cmd != [expr  255 - [expr 0x$Vg::cmd_spi]]} then {return 1}

        append answer_var [format "%02X" $answer]
    }

#   SS to 1
    puts -nonewline $serial [binary format H2H2 $Vg::cmd_ss_high [format "%02X" [expr  255 - [expr 0x$Vg::cmd_ss_high]]]]

    catch {read $serial 1} answer_cmd

    binary scan $answer_cmd c answer_cmd
    set answer_cmd [expr $answer_cmd & 0xFF]
    if {$answer_cmd != [expr  255 - [expr 0x$Vg::cmd_ss_high]]} then {return 1}

#   put zero bytes    
    
    for {set i 0} {$i<$zerobytes} {incr i} {
        puts -nonewline $serial [binary format H2H2H2 $Vg::cmd_spi [format "%02X" [expr  255 - [expr 0x$Vg::cmd_spi]]] 00]

        catch {read $serial 1} answer_cmd
        binary scan $answer_cmd c answer_cmd
        set answer_cmd [expr $answer_cmd & 0xFF]
        
        catch {read $serial 1} answer
        binary scan $answer c answer
        set answer [expr $answer & 0xFF]    
        if {$answer_cmd != [expr  255 - [expr 0x$Vg::cmd_spi]]} then {return 1}

    }

    return 0
}

proc VgCOM::PageErase {serial adr} {
    global FLASH_CMD_PE FLASH_CMD_WREN CPLD_ADR_WR_FLASH
    variable answer "";

    set data $CPLD_ADR_WR_FLASH
    append data $FLASH_CMD_WREN
    VgCOM::_put_channel $serial $data 0 answer     
    
    set data $CPLD_ADR_WR_FLASH
    append data $FLASH_CMD_PE
    append data [format "%06X" [expr $adr & 0x01FFFF]]
    
    VgCOM::_put_channel $serial $data 0 answer
    
    return 0    
}