namespace eval VgAVD2 {

    namespace import ::Vg::LogLine;

}

proc VgAVD2::create { nb } {
    set frame [$nb insert end VgAVD2 -text "AVD2"]
    set titf [LabelFrame  $frame.titf];   

    set Vg::flt_list "";
    set dat [array names Vg::flt_array]
    foreach str $dat {
        lappend Vg::flt_list $Vg::flt_array($str)
    }


    VgAVD2::_gctl [$titf getframe]
    
    pack $titf -padx 4 -pady 4 -fill both -anchor center;      

    return $frame
}

proc VgAVD2::_gctl { root } {
    set base [expr {($root == ".") ? "" : $root}]
    variable ROOT $root
    variable BASE $base
    variable SCRIPTDIR ; # defined in main script




    # Widget Initialization
    variable frame_gctl [labelframe $BASE.frame_gctl \
	    -text "General control"]
    variable frame_ampctl [labelframe $BASE.frame_ampctl \
	    -text "Amplifier control"]
    variable frame_ifctl [labelframe $BASE.frame_ifctl \
	    -text "IF control"]
    
    variable frame_testctl [frame $BASE.frame_testctl]

    variable fr1_gctl [frame $frame_gctl.fr1_gctl]
    variable fr2_gctl [frame $frame_gctl.fr2_gctl]
    variable fr3_gctl [frame $frame_gctl.fr3_gctl]

    variable fr11_ampctl [frame $frame_ampctl.fr11_ampctl]
    variable fr1_ampctl [frame $frame_ampctl.fr1_ampctl]
    variable fr22_ampctl [frame $frame_ampctl.fr22_ampctl]
    variable fr2_ampctl [frame $frame_ampctl.fr2_ampctl]
    variable fr3_ampctl [frame $frame_ampctl.fr3_ampctl]
    variable fr4_ampctl [frame $frame_ampctl.fr4_ampctl]
    variable fr5_ampctl [frame $frame_ampctl.fr5_ampctl]
    variable fr6_ampctl [frame $frame_ampctl.fr6_ampctl]
    variable fr7_ampctl [frame $frame_ampctl.fr7_ampctl]

    variable fr1_ifctl [frame $frame_ifctl.fr3_ampctl]
    
    variable label_fr1 [label $fr1_gctl.label_fr1 \
	    -text "Fin"]
    variable entry_fr [entry $fr1_gctl.entry_fr \
	    -justify "right" \
	    -textvariable "Vg::frin" \
	    -width 10 ]
    variable label_fr2 [label $fr1_gctl.label_fr2 \
	    -text "MHz"]
    variable button_frload [button $fr1_gctl.button_frload \
	    -command "VgAVD2::LoadFrButton" \
	    -text "Load" \
	    -width 10]
    

    variable chbutton_pwr_en [checkbutton $fr2_gctl.chbutton_pwr_en \
	    -text "AVD2 enable" \
            -command "VgAVD2::ChBtnPowerEn" \
	    -variable "Vg::pwr_en"]

    variable button_initload [button $fr2_gctl.button_initload \
	    -command "VgAVD2::InitButton" \
	    -text "Init" \
	    -width 10]

    variable chbutton_extref_en [checkbutton $fr3_gctl.chbutton_extref_en \
	    -text "Ext ref clock enable enable" \
	    -variable "Vg::extref_en"]

    variable button_adv [button $fr3_gctl.button_adv \
	    -command "VgAVD2::AdvButton" \
	    -text "Advanced..." \
	    -width 10]

    variable chbutton_manual_en [checkbutton $fr11_ampctl.chbutton_manual_en \
	    -text "Manual/automatic control" \
            -state normal \
            -command "VgAVD2::ChButton_manual_en" \
	    -variable "Vg::manual_ctl_en"]
    
    variable chbutton_lna_en [checkbutton $fr1_ampctl.chbutton_lna_en \
	    -text "LNA enable" \
            -state disable \
	    -variable "Vg::lna_en"]

    variable chbutton_cont_update_en [checkbutton $fr1_ampctl.chbutton_cont_update_en \
	    -text "Continius update enable" \
	    -state "disable" \
	    -variable "Vg::cont_update_en"]    
    

    variable label1_fr2_ampctl [label $fr2_ampctl.label1_fr2_ampctl \
	    -text "Pin"]
    
    variable entry_pin [entry $fr2_ampctl.entry_pin \
	    -justify "right" \
	    -textvariable "Vg::pin" \
	    -width 10 ]

    variable label2_fr22_ampctl [label $fr22_ampctl.label2_fr22_ampctl \
	    -text "V(p-p)"]

    variable label1_fr22_ampctl [label $fr22_ampctl.label1_fr22_ampctl \
	    -text "Vout"]
    variable entry_vout [entry $fr22_ampctl.entry_vout \
	    -justify "right" \
	    -textvariable "Vg::voutpp" \
	    -width 10 ]

    variable label2_fr2_ampctl [label $fr2_ampctl.label2_fr2_ampctl \
	    -text "dBm (Est input power)"]

    variable label1_fr3_ampctl [label $fr3_ampctl.label1_fr3_ampctl \
	    -text "Pm"]
    
    variable entry_pm [entry $fr3_ampctl.entry_pm \
	    -justify "right" \
	    -textvariable "Vg::pmeasure" \
            -state disable \
	    -width 10 ]

    variable label2_fr3_ampctl [label $fr3_ampctl.label2_fr3_ampctl \
	    -text "dBm (Measured power at mixer)"]

    variable button_read_power [button $fr3_ampctl.button_read_power \
	    -command "VgAVD2::ButtonReadPower" \
	    -text "Read" \
	    -width 10]

    variable label1_fr4_ampctl [label $fr4_ampctl.label1_fr4_ampctl \
	    -text "Pmod"]
    
    variable entry_p_mod [entry $fr4_ampctl.entry_p_mod \
	    -justify "right" \
	    -textvariable "Vg::p_mod" \
            -state normal \
	    -width 10 ]

    variable label2_fr4_ampctl [label $fr4_ampctl.label2_fr4_ampctl \
	    -text "dB (Needed power at mixer)"]

    variable label1_fr5_ampctl [label $fr5_ampctl.label1_fr5_ampctl \
	    -text "Gif"]
    
    variable entry_if_gain [entry $fr5_ampctl.entry_if_gain \
	    -justify "right" \
	    -textvariable "Vg::if_gain" \
            -state disable \
	    -width 10 ]

    variable label2_fr5_ampctl [label $fr5_ampctl.label2_fr5_ampctl \
	    -text "dB (IF section gain)"]

    variable label1_fr6_ampctl [label $fr6_ampctl.label1_fr6_ampctl \
	    -text "Go"]
    
    variable entry_if_gain_offset [entry $fr6_ampctl.entry_if_gain_offset \
	    -justify "right" \
	    -textvariable "Vg::if_gain_offset" \
            -state normal \
	    -width 10 ]

    variable label2_fr6_ampctl [label $fr6_ampctl.label2_fr6_ampctl \
	    -text "dB  (IF gain offset I and Q)"]    

    variable label1_fr7_ampctl [label $fr7_ampctl.label1_fr7_ampctl \
	    -text "I offset:"]
    
    variable entry_i_offset [entry $fr7_ampctl.entry_i_offset \
	    -justify "right" \
	    -textvariable "Vg::i_offset" \
            -state normal \
	    -width 10 ]

    variable label2_fr7_ampctl [label $fr7_ampctl.label2_fr7_ampctl \
	    -text "mV"]
    
    
    variable label3_fr7_ampctl [label $fr7_ampctl.label3_fr7_ampctl \
	    -text "Q offset:"]
    
    variable entry_q_offset [entry $fr7_ampctl.entry_q_offset \
	    -justify "right" \
	    -textvariable "Vg::q_offset" \
            -state normal \
	    -width 10 ]

    variable label4_fr7_ampctl [label $fr7_ampctl.label4_fr7_ampctl \
	    -text "mV"]
    
    variable button_ampupdate [button $fr2_ampctl.button_ampupdate \
	    -command "VgAVD2::AmpUpdate" \
	    -text "Set" \
	    -width 10]    
    
    variable label1_fr1_ifctl [label $fr1_ifctl.label1_fr1_ifctl \
	    -text "I/Q filter"]
    
    variable combobox_iq_flt [ComboBox $fr1_ifctl.combobox_iq_flt \
	    -textvariable "Vg::iq_flt" \
            -editable false \
	    -values $Vg::flt_list \
	    -width 10 ]

    variable button_fltupdate [button $fr1_ifctl.button_fltupdate \
	    -command "VgAVD2::FltUpdate" \
	    -text "Update" \
	    -width 10]
    
    
    variable label1_fr1_testctl [label $frame_testctl.label1_fr1_testctl \
	    -text "Temperature"]
    
    variable entry_temp [entry $frame_testctl.entry_temp \
	    -justify "right" \
	    -textvariable "Vg::temperature" \
            -state disable \
	    -width 10 ]

    variable label2_fr1_testctl [label $frame_testctl.label2_fr1_testctl \
	    -text "C"]    
    
    variable button_tempread [button $frame_testctl.button_tempread \
	    -command "VgAVD2::ButtonReadTemp" \
	    -text "Read" \
	    -width 10]
    
    pack $label_fr1 $entry_fr $label_fr2 -side left
    pack configure $label_fr1 -padx "20 5"
    pack configure $label_fr2 -padx "5 0"
    pack $button_frload -side right -padx "0 20"

    pack $chbutton_pwr_en -side left
    pack configure $chbutton_pwr_en -padx "20 0"
    pack $button_initload -side right -padx "0 20"
    
    pack $chbutton_extref_en -side left
    pack configure $chbutton_extref_en -padx "20 0"
    pack $button_adv -side right  -padx "0 20"
    
    pack $chbutton_lna_en -side left -padx "20 0"
    pack $chbutton_cont_update_en -side right -padx "0 20"

    pack $chbutton_manual_en -side left -padx "20 0"

    pack $label1_fr22_ampctl $entry_vout $label2_fr22_ampctl -side left
    pack configure $label1_fr22_ampctl -padx "12 0"
    
#    pack $label1_fr2_ampctl $entry_pin $label2_fr2_ampctl $button_ampupdate -side left
    pack $label1_fr2_ampctl $entry_pin $label2_fr2_ampctl -side left
    pack configure $label1_fr2_ampctl -padx "20 0"
#    pack $button_ampupdate -side right -padx "0 20"
    
    pack $label1_fr3_ampctl $entry_pm $label2_fr3_ampctl -side left
    pack $button_read_power -side right -padx "0 20"
    pack configure $label1_fr3_ampctl -padx "20 0"    
    
    pack $label1_fr4_ampctl $entry_p_mod $label2_fr4_ampctl -side left
    pack configure $label1_fr4_ampctl -padx "8 0"     
    
    pack $label1_fr5_ampctl $entry_if_gain $label2_fr5_ampctl -side left
    pack configure $label1_fr5_ampctl -padx "21 0"     

    pack $label1_fr6_ampctl $entry_if_gain_offset $label2_fr6_ampctl -side left
    pack configure $label1_fr6_ampctl -padx "21 0"
    
    pack $label1_fr7_ampctl $entry_i_offset $label2_fr7_ampctl $label3_fr7_ampctl $entry_q_offset $label4_fr7_ampctl -side left
    pack configure $label1_fr7_ampctl -padx "5 0"
    pack configure $label3_fr7_ampctl -padx "20 0"
    
    pack $label1_fr1_ifctl $combobox_iq_flt -side left
    pack configure $label1_fr1_ifctl -padx "20 0"
    pack $button_fltupdate -side right -padx "0 20"
    
    pack $label1_fr1_testctl $entry_temp $label2_fr1_testctl -side left
    pack $button_tempread -side right -padx "0 22"
    
    pack $fr1_gctl $fr2_gctl $fr3_gctl -expand yes -fill x
    pack configure $fr1_gctl -pady "10 5"
    pack configure $fr2_gctl -pady "5 5"
    pack configure $fr3_gctl -pady "5 10"
    pack $fr11_ampctl $fr1_ampctl $fr22_ampctl $fr2_ampctl $fr3_ampctl $fr4_ampctl $fr5_ampctl $fr6_ampctl $fr7_ampctl -expand yes -fill x
    pack configure $fr1_ampctl -pady "5 5"
    pack configure $fr2_ampctl -pady "5 5"
    pack configure $fr3_ampctl -pady "5 5"
    pack configure $fr4_ampctl -pady "5 5"
    pack configure $fr5_ampctl -pady "5 5"      
    pack configure $fr6_ampctl -pady "5 5"      
    pack configure $fr7_ampctl -pady "5 10"    
    pack $fr1_ifctl -expand yes -fill x -pady "10 10"
    pack $frame_gctl $frame_ampctl $frame_ifctl $frame_testctl -padx 4 -fill both -expand yes;
    pack configure $frame_testctl -pady "10 0"

}

proc VgAVD2::ChButton_manual_en {} {
    if {$Vg::manual_ctl_en == 1} {
        $VgAVD2::entry_pin configure -state normal
    } else {
        $VgAVD2::entry_pin configure -state disable
    }
}

proc VgAVD2::LoadFrButton {} {
    if {$Vg::init_done == 0} {
	tk_messageBox -message "Initialization wasn't done. Please, press \"Init\" button first" \
            -type ok
	return 1
    }
    
    Vg::LogLine "\nVgAVD2::LoadFrButton"
    
    VgAVD2::CalculateInputSection
    VgAVD2::CalculateRFSection

    if {$Vg::manual_ctl_en == 1} {

        VgAVD2::CalculateAttenuators
    
        VgAVD2::CalculateAttReg      
        VgAVD2::LoadAllRegisters    

    } else {
        # off lna
        VgAVD2::SetMaxAttenuation
        VgAVD2::CalculateAttdB
        VgAVD2::LoadAllRegisters
#        VgAVD2::LoadRFAttRegisters
        
        set i 0
        after 1
        VgAVD2::ReadPowerRegisters 0
        set delta [expr $Vg::p_mod-$Vg::pmeasure]
        while {[expr abs($delta)] > $Vg::pm_acc} {
            Vg::LogLine "\n\n $i **************************"
            incr i
            Vg::LogLine "delta: $delta"
            VgAVD2::CalculateAttenuators            
            VgAVD2::CalculateAttReg
            if {$Vg::lna_off_first == 1} {
                set Vg::lna_off_first 0
                VgAVD2::OffRFinLNA
            }
            VgAVD2::LoadRFAttRegisters
            if {$Vg::lna_on_last == 1} {
                set Vg::lna_on_last 0
                VgAVD2::OnRFinLNA
            }
            after 1
            VgAVD2::ReadPowerRegisters 0
            set delta [expr $Vg::p_mod-$Vg::pmeasure]
        }

    }

}

proc VgAVD2::CalculateAttenuators {} {
    variable A1 0;
    variable A2 0;
    variable A3 0;
        
    if {$Vg::manual_ctl_en == 1} {

        Vg::LogLine "Pin: $Vg::pin dBm" 
        Vg::LogLine "Vout(p-p): $Vg::voutpp V"
        set Vg::pout [format "%.2f" [expr 10*log10(10*$Vg::voutpp*$Vg::voutpp/4.0)]]
        Vg::LogLine "Pout: $Vg::pout dBm"        
        set Gall [expr $Vg::pout-$Vg::pin]      
        Vg::LogLine "Gall: $Gall dB"
        set Vg::if_gain [expr $Vg::pout - $Vg::p_mod]
        Vg::LogLine "Gif: $Vg::if_gain dB"
        
        if {[expr $Gall-$Vg::if_gain] > $Vg::gain_rfinlna} {
            set Vg::lna_en 1
        } else {
            set Vg::lna_en 0
        }
        if {$Vg::lna_en == 1} {
            set Vg::gain_rfin $Vg::gain_rfinlna
        } else {
            set Vg::gain_rfin $Vg::gain_rfinatt        
        }        
        set G0 [expr $Gall-$Vg::gain_rfin-$Vg::if_gain]
        Vg::LogLine "Gin: $Vg::gain_rfin"
        Vg::LogLine "G0: $G0"        
        set Vg::Att [expr $Vg::gain_fr-$G0]
        Vg::LogLine "Att: $Vg::Att"         
        
        VgAVD2::CalculateAttValues $Vg::Att A1 A2 A3
        
        set Vg::att1 $A1
        set Vg::att2 $A2
        set Vg::att3 $A3
        
    } else {
        set g_need [expr $Vg::p_mod-$Vg::pmeasure]
        if {[expr abs($g_need)] > $Vg::g_max_incr} {
            set g_incr $Vg::g_max_incr
        } else {
            set g_incr $g_need
        }
        set Vg::Att [expr $Vg::att1+$Vg::att2+$Vg::att3]
        set Vg::Att [expr $Vg::Att-$g_incr]
        
        Vg::LogLine "pmeasure: $Vg::pmeasure"
        Vg::LogLine "g_incr: $g_incr"
        set G0 [expr $Vg::gain_fr-$Vg::Att]
        Vg::LogLine "G0: $G0"
        
        if {$Vg::lna_en == 1} {
            if {[expr $G0+$Vg::lna_hyst] > $Vg::gain_rfinlna} {
                set Vg::lna_en 0
                set Vg::Att [expr $Vg::Att-$Vg::gain_rfinlna]
                set Vg::lna_off_first 1
            }
        } else {
            if {[expr $G0+$Vg::lna_hyst] > $Vg::gain_rfinlna} {            
                set Vg::lna_en 1
                set Vg::Att [expr $Vg::Att+$Vg::gain_rfinlna]
                set Vg::lna_on_last 1
            }
        }
        
        VgAVD2::CalculateAttValues $Vg::Att A1 A2 A3

        set Vg::att1 $A1
        set Vg::att2 $A2
        set Vg::att3 $A3

    }
}

proc VgAVD2::InitButton { } {
    global 2_POW_48 2_POW_32 2_POW_16 CPLD_ADR_FUNC_WR CPLD_ADR_ATT1_CTL_WR CPLD_ADR_ATT2_CTL_WR CPLD_ADR_ATT3_CTL_WR CPLD_ADR_ATT_RFINATT_WR CPLD_ADR_ATT_RFINLNA_WR CPLD_ADR_PLL_WR CPLD_ADR_DDS_WR CPLD_ADR_DET_ADC_RD
    Vg::LogLine "" 
    Vg::LogLine "VgAVD2::InitButton ... Compute all parameters"
    variable serial "";
    variable answer "";

    VgAVD2::CalculateParameters
    VgAVD2::SetMaxAttenuation    
    VgAVD2::LoadAllRegisters
    set Vg::init_done 1
}

proc VgAVD2::SetMaxAttenuation {} {


    set Vg::pout [format "%.2f" [expr 10*log10(10*$Vg::voutpp*$Vg::voutpp/4.0)]]
    Vg::LogLine "Pout: $Vg::pout dBm"        

    set Vg::if_gain [expr $Vg::pout - $Vg::p_mod]
    Vg::LogLine "Gif: $Vg::if_gain dB"
    
    set Vg::reg_att1 31
    set Vg::reg_att2 31
    set Vg::reg_att3 31
    
    VgAVD2::CalculateAttdB

}

proc VgAVD2::AdvButton { } {
    
    if {$Vg::init_done == 0} {
	tk_messageBox -message "Initialization wasn't done. Please, press \"Init\" button first" \
            -type ok
	return 1
    }
    
    set dlg [Dialog .advdlg -parent . -modal local \
                 -separator false \
                 -title   "Advanced AVD2 configuration" \
                 -side    bottom    \
                 -anchor  e  \
                 -default 2 -cancel 2]
  
    set titf [TitleFrame  $dlg.titf -text "Advanced"]; 


    VgAVD2::CalculateAttdB
    
    VgAVD2::CalculateInputSection
    VgAVD2::CalculateRFSection
    
    Vg::LogLine "Vg::gain_rfinatt: $Vg::gain_rfinatt"
    Vg::LogLine "Vg::gain_rfinlna: $Vg::gain_rfinlna"
    Vg::LogLine "Vg::att_rfinatt_cal: $Vg::att_rfinatt_cal"    
    Vg::LogLine "Vg::att_rfinlna_cal: $Vg::att_rfinlna_cal"
    
    Vg::LogLine "Vg::cal_att_370_coef: $Vg::cal_att_370_coef"    
    Vg::LogLine "Vg::cal_att_470_coef: $Vg::cal_att_470_coef" 
    
    
    
    VgAVD2::CalculateAttReg    
    
    CalculateParameters
    VgAVD2::CalculateAttdB
    VgAVD2::CalculateAttReg
    VgAVD2::CalculateAttdB
    
#    Vg::LogLine "Vg::rf_gain: $Vg::rf_gain"
    
#    CalculateAttdB
    _advdlg  [$titf getframe]

    pack $titf -padx 4 -pady 4 -fill both;
    


    $dlg add -name load_all -text "Load" -command "VgAVD2::AdvLoad";
    $dlg add -name close -text "Close" -command "VgAVD2::AdvClose $dlg";

    $dlg draw
    destroy $dlg
}

proc VgAVD2::_advdlg { root } {
    set base [expr {($root == ".") ? "" : $root}]
    variable ROOT $root
    variable BASE $base
    variable SCRIPTDIR ; # defined in main script



    variable fr1_advdlg [frame $BASE.fr1_advdlg]
    variable fr2_advdlg [frame $BASE.fr2_advdlg]
    variable fr3_advdlg [frame $BASE.fr3_advdlg]
    variable fr4_advdlg [frame $BASE.fr4_advdlg]
    variable fr5_advdlg [frame $BASE.fr5_advdlg]
    variable fr6_advdlg [frame $BASE.fr6_advdlg]
    variable fr7_advdlg [frame $BASE.fr7_advdlg]
    variable fr8_advdlg [frame $BASE.fr8_advdlg]
    

    # Widget Initialization
    
    variable chbutton_lna_en [checkbutton $fr1_advdlg.chbutton_lna_en \
	    -text "LNA enable" \
            -state normal \
	    -variable "Vg::lna_en"]

    variable label_lnaatt_1 [label $fr2_advdlg.label_lnaatt_1 \
	    -text "LNA attenuator:"]
    variable entry_lnaatt [entry $fr2_advdlg.entry_lnaatt \
	    -justify "right" \
	    -textvariable "Vg::att_rfinlna_cal" \
            -state normal \
	    -width 10 ]    
    variable label_lnaatt_2 [label $fr2_advdlg.label_lnaatt_2 \
	    -text "dB"]
    
    variable label_rfinatt_1 [label $fr3_advdlg.label_rfinatt_1 \
	    -text "RFin attenuator:"]
    variable entry_rfinatt [entry $fr3_advdlg.entry_rfinatt \
	    -justify "right" \
	    -textvariable "Vg::att_rfinatt_cal" \
            -state normal \
	    -width 10 ]    
    variable label_rfinatt_2 [label $fr3_advdlg.label_rfinatt_2 \
	    -text "dB"]    
    
    variable label_att1_1 [label $fr4_advdlg.label_att1_1 \
	    -text "Att1:"]
    variable entry_att1 [entry $fr4_advdlg.entry_att1 \
	    -justify "right" \
	    -textvariable "Vg::att1" \
            -state normal \
	    -width 10 ]    
    variable label_att1_2 [label $fr4_advdlg.label_att1_2 \
	    -text "dB"]  
    
    variable label_att2_1 [label $fr5_advdlg.label_att2_1 \
	    -text "Att2:"]
    variable entry_att2 [entry $fr5_advdlg.entry_att2 \
	    -justify "right" \
	    -textvariable "Vg::att2" \
            -state normal \
	    -width 10 ]    
    variable label_att2_2 [label $fr5_advdlg.label_att2_2 \
	    -text "dB"]
    
    variable label_att3_1 [label $fr6_advdlg.label_att3_1 \
	    -text "Att3:"]
    variable entry_att3 [entry $fr6_advdlg.entry_att3 \
	    -justify "right" \
	    -textvariable "Vg::att3" \
            -state normal \
	    -width 10 ]    
    variable label_att3_2 [label $fr6_advdlg.label_att3_2 \
	    -text "dB"]  
    
    variable label_ifatt_1 [label $fr7_advdlg.label_ifatt_1 \
	    -text "IF gain:"]
    variable entry_ifatt [entry $fr7_advdlg.entry_ifatt \
	    -justify "right" \
	    -textvariable "Vg::if_gain" \
            -state normal \
	    -width 10 ]    
    variable label_ifatt_2 [label $fr7_advdlg.label_ifatt_2 \
	    -text "dB"]
    
    pack $fr1_advdlg $fr2_advdlg $fr3_advdlg $fr4_advdlg $fr5_advdlg $fr6_advdlg $fr7_advdlg $fr8_advdlg -anchor e -pady "5 5"
    pack $fr1_advdlg -anchor w
    pack $chbutton_lna_en

    pack $label_lnaatt_2 $entry_lnaatt $label_lnaatt_1 -side right
    pack configure $entry_lnaatt -padx "5 5"
    
    pack $label_rfinatt_2 $entry_rfinatt $label_rfinatt_1 -side right
    pack configure $entry_rfinatt -padx "5 5"

    pack $label_att1_2 $entry_att1 $label_att1_1 -side right
    pack configure $entry_att1 -padx "5 5"

    pack $label_att2_2 $entry_att2 $label_att2_1 -side right
    pack configure $entry_att2 -padx "5 5"
    
    pack $label_att3_2 $entry_att3 $label_att3_1 -side right
    pack configure $entry_att3 -padx "5 5"

    pack $label_ifatt_2 $entry_ifatt $label_ifatt_1 -side right
    pack configure $entry_ifatt -padx "5 5"
    # Geometry Management


}

proc VgAVD2::ChBtnPowerEn { } {
    Vg::LogLine "test"
    
}

proc VgAVD2::entry_fr_validatecommand { } {


}

proc VgAVD2::AdvLoad { } {

    VgAVD2::CalculateAttReg
    VgAVD2::CalculateAttdB
    VgAVD2::LoadAllRegisters
    


}

proc VgAVD2::AdvClose { dlg } {

    $dlg enddialog 0
}

proc VgAVD2::FltUpdate {} {

    VgAVD2::LoadIFRegisters
}

proc VgAVD2::GetSW1reg {flt} {
    global CPLD_ADR_SW1_WR
    switch $flt {
        "100 MHz" {
            set reg [expr (0x8 << 16) | (0x9 << 24)]
        }
        "15 MHz" {
            set reg [expr (0x8 << 4) | (0x9 << 20)]
        }
        "2 MHz" {
            set reg [expr (0x8 << 28) | (0x9 << 0)]
        }
        "0.4 MHz" {
            set reg [expr (0x8 << 8) | (0x9 << 12)]
        }
        default {
            Vg::LogLine "Error. Can't set SW1 register"
            return 0
        }
    }
    set data $CPLD_ADR_SW1_WR
    append data [format "%08X" $reg]
#    set data "0A09080000"
    return $data
}

proc VgAVD2::GetSW2reg {flt} {
    global CPLD_ADR_SW2_WR    
    switch $flt {
        "100 MHz" {
            set reg [expr (0x$CPLD_ADR_SW2_WR << 32) | 0xC | (0xE << 4)]
        }
        "15 MHz" {
            set reg [expr (0x$CPLD_ADR_SW2_WR << 32) | 0x9 | (0xD << 4)]
        }
        "2 MHz" {
            set reg [expr (0x$CPLD_ADR_SW2_WR << 32) | 0xF | (0x8 << 4)]
        }
        "0.4 MHz" {
            set reg [expr (0x$CPLD_ADR_SW2_WR << 32) | 0xA | (0xB << 4)]
        }
        default {
            Vg::LogLine "Error. Can't set SW2 register"
            return 0
        }
    }
    set data $CPLD_ADR_SW2_WR
    append data [format "%08X" $reg]
    return $data
}

proc VgAVD2::Calculate_D_Ioffset {V} {
    set D [expr $Vg::a_i_dac*$V+$Vg::b_i_dac]
    if {$D < 0} {set D 0}
    if {$D > 4095} {set D 4095}
    set D [expr round($D)]
    return $D
}

proc VgAVD2::Calculate_V_Ioffset {D} {
    set V [expr 1000*($D-$Vg::b_i_dac)/(1.0*$Vg::a_i_dac)]
    set V [format "%.3f" $V]
    return $V
}

proc VgAVD2::Calculate_D_Qoffset {V} {
    set D [expr $Vg::a_q_dac*$V+$Vg::b_q_dac]
    if {$D < 0} {set D 0}
    if {$D > 4095} {set D 4095}
    set D [expr round($D)]
    return $D
}

proc VgAVD2::Calculate_V_Qoffset {D} {
    set V [expr 1000*($D-$Vg::b_q_dac)/(1.0*$Vg::a_q_dac)]
    set V [format "%.3f" $V]
    return $V
}

proc VgAVD2::Calculate_D_if_gain_offset {db} {
    set D [expr $Vg::a_if_gain_offset*$db+$Vg::b_if_gain_offset]
    if {$D < 0} {set D 0}
    if {$D > 4095} {set D 4095}
    set D [expr round($D)]
    return $D
}

proc VgAVD2::Calculate_G_if_gain_offset {D} {
    set db [expr ($D-$Vg::b_if_gain_offset)/(1.0*$Vg::a_if_gain_offset)]
    set db [format "%.3f" $db]
    return $db
}

proc VgAVD2::Calculate_D_if_gain {db} {
    set D [expr $Vg::a_if_gain*$db+$Vg::b_if_gain]
    if {$D < 0} {set D 0}
    if {$D > 4095} {set D 4095}
    set D [expr round($D)]
    return $D
}

proc VgAVD2::GetDACreg {data adr nPD nLDAC} {
# i_dac_offset q_dac_ffset if_gain if_gain_offset
    global CPLD_ADR_DAC_WR    
    switch $adr {
        "i_offset" {
            set reg [expr (0x2 << 14) | ($nPD << 13) | ($nLDAC << 12) | ($data & 0xFFF)]
        }
        "q_offset" {
            set reg [expr (0x3 << 14) | ($nPD << 13) | ($nLDAC << 12) | ($data & 0xFFF)]
        }
        "if_gain" {
            set reg [expr (0x0 << 14) | ($nPD << 13) | ($nLDAC << 12) | ($data & 0xFFF)]
        }
        "if_gain_offset" {
            set reg [expr (0x1 << 14) | ($nPD << 13) | ($nLDAC << 12) | ($data & 0xFFF)]
        }
        default {
            Vg::LogLine "Error. Can't set DAC register"
            return 0
        }
    }
    set data $CPLD_ADR_DAC_WR
    append data [format "%04X" $reg]
    return $data
}

proc VgAVD2::CalculateAttdB {} {
    set Vg::att1 [expr $Vg::cal_att_370_coef*$Vg::reg_att1]
    set Vg::att1 [format "%.2f" $Vg::att1]
    set Vg::att2 [expr $Vg::cal_att_370_coef*$Vg::reg_att2]
    set Vg::att2 [format "%.2f" $Vg::att2]
    set Vg::att3 [expr $Vg::cal_att_470_coef*$Vg::reg_att3]   
    set Vg::att_rfinatt_cal [expr 0.25*$Vg::reg_att_rfinatt_cal]
    set Vg::att_rfinlna_cal [expr 0.25*$Vg::reg_att_rfinlna_cal]
}

proc VgAVD2::CalculateAttReg {} {
    if {$Vg::att1 < 0} {set Vg::att1 0}
    set Vg::reg_att1 [expr round($Vg::att1/$Vg::cal_att_370_coef)]
    if {$Vg::reg_att1 > 31} {set Vg::reg_att1 31}
    
    if {$Vg::att2 < 0} {set Vg::att2 0}
    set Vg::reg_att2 [expr round($Vg::att2/$Vg::cal_att_370_coef)]
    if {$Vg::reg_att2 > 31} {set Vg::reg_att2 31}
    
    if {$Vg::att3 < 0} {set Vg::att3 0}
    set Vg::reg_att3 [expr round($Vg::att3/$Vg::cal_att_470_coef)]
    if {$Vg::reg_att3 > 31} {set Vg::reg_att3 31}
    
    if {$Vg::att_rfinatt_cal < 0} {set Vg::att_rfinatt_cal 0}
    set Vg::reg_att_rfinatt_cal [expr round($Vg::att_rfinatt_cal/0.25)]
    if {$Vg::reg_att_rfinatt_cal > 31} {set Vg::reg_att_rfinatt_cal 31}
    
    if {$Vg::att_rfinlna_cal < 0} {set Vg::att_rfinlna_cal 0}
    set Vg::reg_att_rfinlna_cal [expr round($Vg::att_rfinlna_cal/0.25)]
    if {$Vg::reg_att_rfinlna_cal > 31} {set Vg::reg_att_rfinlna_cal 31}
}

proc VgAVD2::LoadAllRegisters {} {
    global CPLD_ADR_FUNC_WR CPLD_ADR_ATT1_CTL_WR CPLD_ADR_ATT2_CTL_WR CPLD_ADR_ATT3_CTL_WR CPLD_ADR_ATT_RFINATT_WR CPLD_ADR_ATT_RFINLNA_WR CPLD_ADR_PLL_WR CPLD_ADR_DDS_WR CPLD_ADR_DET_ADC_RD

    if {[VgCOM::open_channel serial]} then {return 1}
        
#   ATT_RFINATT register
    set data [expr (0x$CPLD_ADR_ATT_RFINATT_WR << 8) | ($Vg::reg_att_rfinatt_cal & 0x1F)]
    VgCOM::put_channel $serial [format "%04X" $data] 0 answer

#   ATT_RFINLNA register
    set data [expr (0x$CPLD_ADR_ATT_RFINLNA_WR << 8) | ($Vg::reg_att_rfinlna_cal & 0x1F)]
    VgCOM::put_channel $serial [format "%04X" $data] 0 answer

#   ATT1_CTL register
    set data [expr (0x$CPLD_ADR_ATT1_CTL_WR << 8) | ($Vg::reg_att1 & 0x1F)]
    VgCOM::put_channel $serial [format "%04X" $data] 0 answer
    
#   ATT2_CTL register
    set data [expr (0x$CPLD_ADR_ATT2_CTL_WR << 8) | ($Vg::reg_att2 & 0x1F)]
    VgCOM::put_channel $serial [format "%04X" $data] 0 answer
    
#   ATT3_CTL register
    set data [expr (0x$CPLD_ADR_ATT3_CTL_WR << 8) | ($Vg::reg_att3 & 0x1F)]
    VgCOM::put_channel $serial [format "%04X" $data] 0 answer
    
#   FUNC register
    set out_en 0
    set data [expr (0x$CPLD_ADR_FUNC_WR << 8) | ($out_en << 5) | (($Vg::band & 0x3) << 3) | (($Vg::lna_en & 0x1) << 2) | (($Vg::extref_en & 0x1) << 1) | ($Vg::pwr_en & 0x1)]
    Vg::LogLine "extref_en: $Vg::extref_en"
    Vg::LogLine "data: $data"
    VgCOM::put_channel $serial [format "%04X" $data] 1 answer

#   out en
    set out_en 1
    set data [expr (0x$CPLD_ADR_FUNC_WR << 8) | ($out_en << 5) | (($Vg::band & 0x3) << 3) | (($Vg::lna_en & 0x1) << 2) | (($Vg::extref_en & 0x1) << 1) | ($Vg::pwr_en & 0x1)] 
    VgCOM::put_channel $serial [format "%04X" $data] 1 answer

#   PLL R
    set data [expr (0x$CPLD_ADR_PLL_WR << 24) | ($Vg::REG_R_PLL & 0xFFFFFF)]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   PLL FUNC
    set data [expr (0x$CPLD_ADR_PLL_WR << 24) | ($Vg::REG_Func_PLL & 0xFFFFFF)]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   PLL N
    set data [expr (0x$CPLD_ADR_PLL_WR << 24) | ($Vg::REG_N_PLL & 0xFFFFFF)]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS RESET
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x0012 << 8) | 0x01]    
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS IO UPDATE
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x0005 << 8) | 0x01]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x0000
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x0000 << 8) | 0x80]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x0010  0x90
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x0010 << 8) | 0x90]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x040B
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x040B << 8) | 0xFF]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x040C
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x040C << 8) | 0x03]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x01A6
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x01A6 << 8) | ($Vg::FTWl & 0xFF)]    
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x01A7
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x01A7 << 8) | (($Vg::FTWl >> 8) & 0xFF)]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x01A8
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x01A8 << 8) | (($Vg::FTWl >> 16) & 0xFF)]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x01A9
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x01A9 << 8) | (($Vg::FTWl >> 24) & 0xFF)]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x01AA
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x01AA << 8) | ($Vg::FTWh & 0xFF)]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x01AB
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x01AB << 8) | (($Vg::FTWh >> 8) & 0xFF)]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS IO UPDATE
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x0005 << 8) | 0x01] 
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   SW1 register
    set data [VgAVD2::GetSW1reg $Vg::iq_flt]
    VgCOM::put_channel $serial $data 0 answer

#   SW2 register
    set data [VgAVD2::GetSW2reg $Vg::iq_flt]    
    VgCOM::put_channel $serial $data 0 answer  
    
#   I DAC offset
    set data [VgAVD2::Calculate_D_Ioffset [expr $Vg::i_offset/1000.0]]
    set Vg::i_offset [VgAVD2::Calculate_V_Ioffset $data]
    set data [VgAVD2::GetDACreg $data i_offset 1 0]
    VgCOM::put_channel $serial $data 0 answer
    
#   Q DAC offset
    set data [VgAVD2::Calculate_D_Qoffset [expr $Vg::q_offset/1000.0]]
    set Vg::q_offset [VgAVD2::Calculate_V_Qoffset $data]    
    set data [VgAVD2::GetDACreg $data q_offset 1 0]    
    VgCOM::put_channel $serial $data 0 answer
    
#   IF gain offset
    set data [VgAVD2::Calculate_D_if_gain_offset [expr $Vg::if_gain_offset]]
    set Vg::if_gain_offset [VgAVD2::Calculate_G_if_gain_offset $data]      
    set data [VgAVD2::GetDACreg $data if_gain_offset 1 0]     
    VgCOM::put_channel $serial $data 0 answer
    
#   IF gain
    set data [VgAVD2::Calculate_D_if_gain [expr $Vg::if_gain]]
    set data [VgAVD2::GetDACreg $data if_gain 1 0]
    VgCOM::put_channel $serial $data 0 answer

#   Temperature
    set channel 1
    set data [expr (0x$CPLD_ADR_DET_ADC_RD << 16) | ($channel << 14) | ($channel << 13)]
    VgCOM::put_channel $serial [format "%06X" $data] 0 answer
    VgCOM::put_channel $serial [format "%06X" $data] 0 answer    

    set voltage [expr (3.3*(0x$answer & 0xFFF))/4096.0]
    set temperature [expr 500*($voltage-0.6)+27]

    set Vg::temperature [format "%.1f" $temperature]    
    
# RF power    
    set channel 0
    set data [expr (0x$CPLD_ADR_DET_ADC_RD << 16) | ($channel << 14) | ($channel << 13)]
    VgCOM::put_channel $serial [format "%06X" $data] 0 answer    
    VgCOM::put_channel $serial [format "%06X" $data] 0 answer

    Vg::LogLine "answer: 0x$answer"
    Vg::LogLine "answer: [expr 0x$answer & 0xFFF]"
    
    set voltage [expr (3.3*(0x$answer & 0xFFF))/4096.0]    
    Vg::LogLine "voltage: $voltage"

    set rf_power [expr $voltage/$Vg::pm_slope+$Vg::pm_intercept]
    set Vg::pmeasure [format "%.1f" $rf_power]
    
    Vg::LogLine "rf_power: $Vg::pmeasure"

    close $serial  
}

proc VgAVD2::CalculateParameters {} {
    global 2_POW_48 2_POW_32 2_POW_16
    if {$Vg::frin < 800} { set Vg::band 2}  
    if {$Vg::frin >= 800 && $Vg::frin < 1600} { set Vg::band 1} 
    if {$Vg::frin >= 1600} { set Vg::band 0} 

#    set Vg::fvco [expr $Vg::frin*pow(2, $Vg::band)]
#    set Vg::FTWl [expr round((400/$Vg::fvco)*$2_POW_32)]
#    set Vg::FTWh [expr round((400/$Vg::fvco)*$2_POW_16)]

    set Vg::fvco [expr $Vg::frin*pow(2, $Vg::band)]
    set Vg::FTWl [expr (400/$Vg::fvco)*$2_POW_48]
    set Vg::FTWh [expr ($Vg::FTWl / $2_POW_32)]

    set Vg::FTWl [expr int($Vg::FTWl) & 0xFFFFFFFF]
    set Vg::FTWh [expr int($Vg::FTWh) & 0xFFFF]    

    Vg::LogLine "band: $Vg::band"
    Vg::LogLine "fvco: $Vg::fvco"
    Vg::LogLine "FTWh: 0x[format "%04X" $Vg::FTWh]"
    Vg::LogLine "FTWl: 0x[format "%08X" $Vg::FTWl]" 
}

proc VgAVD2::AmpUpdate {} {
    global CPLD_ADR_DET_ADC_RD

    if {[VgCOM::open_channel serial]} then {return 1}

    set channel 0
    set data [expr (0x$CPLD_ADR_DET_ADC_RD << 16) | ($channel << 14) | ($channel << 13)]
    VgCOM::put_channel $serial [format "%06X" $data] 0 answer    
    VgCOM::put_channel $serial [format "%06X" $data] 0 answer

    Vg::LogLine "answer: 0x$answer"
#    Vg::LogLine "answer: [expr 0x$answer & 0xFFF]"

#    set voltage [expr (3.3*(0x$answer & 0xFFF))/4096.0]    
#    Vg::LogLine "voltage: $voltage"
#    set rf_power [expr $voltage/$Vg::pm_slope+$Vg::pm_intercept]
#    set Vg::pmeasure [format "%.1f" $rf_power]
 
    set answer [expr 0x$answer & 0xFFF]
#    set answer 1090
    
    variable power -200;
#    set filename "calibration.dat"
    VgAVD2::CalculatePower power $answer $Vg::frin $Vg::calibration_det_data 1

#    Vg::LogLine "power: $power"
    set Vg::pmeasure [format "%.1f" $power]
    Vg::LogLine "rf_power: $Vg::pmeasure"
    close $serial
}

proc VgAVD2::CalculatePower {power D freq filename show} {

    variable P
    upvar $power tmp

    if {[VgAVD2::GetPowerInformation P $D $freq $filename $show]} {
	Vg::LogLine "Error while getting data from file: $filename"
	return 1
    }    
    
#    Vg::LogLine "P: $P"
    set tmp $P

    return 0
}

proc VgAVD2::GetPowerInformation {P D freq filename show} {
# freq - MHz
    upvar $P P_tmp
    variable param_list "";
    variable power_list "";
    variable data_list "";

    if {[VgFile::GetParamFromFile param_list power_list $filename $show]} {return 1}

    set N [expr ($freq*1000000-[lindex $param_list 6]*[lindex $param_list 3])/(1.0*[lindex $param_list 7]*[lindex $param_list 3])]
    set N [expr round(floor($N))]
    if {$N < 2} {set N 2}
    set a [expr 1000000/[lindex $param_list 3]]
    set a [expr $a*$freq]
    set b [expr ([lindex $param_list 6]+[lindex $param_list 7]*([lindex $param_list 5]-1))]
    if {$a >= $b} {set N [expr [lindex $param_list 5]-2]}   

    
    set F1 [expr [lindex $param_list 6]+$N*[lindex $param_list 7]]
    set F2 [expr $F1+[lindex $param_list 7]]

    VgFile::GetColumnFromFile data_list $N [lindex $param_list 4] $filename
    set i [VgFile::GetValuesFromColumn $data_list $D]

    set Da1 [lindex $data_list $i]
    set Di1 [lindex $data_list [expr $i+1]]
    set Pa1 [lindex $power_list $i]
    set Pi1 [lindex $power_list [expr $i+1]]

    VgFile::GetColumnFromFile data_list [expr $N+1] [lindex $param_list 4] $filename
    set i [VgFile::GetValuesFromColumn $data_list $D]

#    Vg::LogLine "D: $D"    
#    Vg::LogLine "data_list: $data_list"
#    Vg::LogLine "i: $i"

    set Da2 [lindex $data_list $i]
    set Di2 [lindex $data_list [expr $i+1]]
    set Pa2 [lindex $power_list $i]
    set Pi2 [lindex $power_list [expr $i+1]]    

    set P_tmp [VgAVD2::GetPowerPoint $freq $D $F1 $F2 $Da1 $Di1 $Da2 $Di2 $Pa1 $Pi1 $Pa2 $Pi2]

    return 0
}

proc VgAVD2::GetPowerPoint {freq D F1 F2 Da1 Di1 Da2 Di2 Pa1 Pi1 Pa2 Pi2} {
    set Da [VgCRC::CalculatePoint4Liner $F2 $F1 $Da2 $Da1 $freq]
    set Di [VgCRC::CalculatePoint4Liner $F2 $F1 $Di2 $Di1 $freq]
    
    set P [expr (($D-$Di)*$Pa1+($Da-$D)*$Pi1)/(1.0*($Da-$Di))]
    return $P
}


proc VgAVD2::CalculateAttValues {db att1 att2 att3} {
    upvar $att1 tmp_att1
    upvar $att2 tmp_att2    
    upvar $att3 tmp_att3
    variable att_th 15;
    variable att_ch 5;
    
    set alpha [expr $db/(2.0*$Vg::cal_att_370_coef*31+$Vg::cal_att_470_coef*31)]
    set tmp [expr $Vg::cal_att_370_coef*31*$alpha]
    set tmp_att1 [expr round($tmp)]
    if {$tmp_att1 > $att_th} {set tmp_att1 [expr $tmp_att1 + $att_ch]}

    set tmp [expr $Vg::cal_att_370_coef*31*$alpha]
    set tmp_att2 [expr round($tmp)]
    if {$tmp_att2 > $att_th} {set tmp_att2 [expr $tmp_att2 + $att_ch/2.0]}    

    set tmp [expr $db-$tmp_att1-$tmp_att2]
    set tmp_att3 [expr round($tmp)]
    
    return 0
}


proc VgAVD2::CalculateInputSection {} {
    
    variable param_var
    VgFile::GetCalibrationParamFromFile  param_var $Vg::frin $Vg::calibration_rfinatt_att_data 1
    set Vg::att_rfinatt_cal $param_var
    VgFile::GetCalibrationParamFromFile  param_var $Vg::frin $Vg::calibration_rfinlna_att_data 1
    set Vg::att_rfinlna_cal $param_var
    VgFile::GetCalibrationParamFromFile  param_var $Vg::frin $Vg::calibration_rfinatt_gain_data 1
    set Vg::gain_rfinatt $param_var
    VgFile::GetCalibrationParamFromFile  param_var $Vg::frin $Vg::calibration_rfinlna_gain_data 1
    set Vg::gain_rfinlna $param_var
    
}

proc VgAVD2::CalculateRFSection {} {
    
    variable param_var
    VgFile::GetCalibrationParamFromFile  param_var $Vg::frin $Vg::calibration_att370_data 1
    Vg::LogLine "param_var: $param_var"
    set Vg::cal_att_370_coef [expr $param_var/31.0]
    
    VgFile::GetCalibrationParamFromFile  param_var $Vg::frin $Vg::calibration_att470_data 1
    Vg::LogLine "param_var: $param_var"
    set Vg::cal_att_470_coef [expr $param_var/31.0]    
    
    VgFile::GetCalibrationParamFromFile  param_var $Vg::frin $Vg::calibration_rfgain 1
    Vg::LogLine "param_var: $param_var"
    set Vg::gain_fr $param_var



#    Vg::LogLine "Vg::gain_fr: $Vg::gain_fr"
}
proc VgAVD2::LoadFreqRegisters {} {
    global CPLD_ADR_FUNC_WR CPLD_ADR_ATT1_CTL_WR CPLD_ADR_ATT2_CTL_WR CPLD_ADR_ATT3_CTL_WR CPLD_ADR_ATT_RFINATT_WR CPLD_ADR_ATT_RFINLNA_WR CPLD_ADR_PLL_WR CPLD_ADR_DDS_WR CPLD_ADR_DET_ADC_RD

    if {[VgCOM::open_channel serial]} then {return 1}
        
    set out_en 1
    set data [expr (0x$CPLD_ADR_FUNC_WR << 8) | ($out_en << 5) | (($Vg::band & 0x3) << 3) | (($Vg::lna_en & 0x1) << 2) | (($Vg::extref_en & 0x1) << 1) | ($Vg::pwr_en & 0x1)] 
    VgCOM::put_channel $serial [format "%04X" $data] 1 answer    

#   DDS 0x01A6
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x01A6 << 8) | ($Vg::FTWl & 0xFF)]    
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x01A7
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x01A7 << 8) | (($Vg::FTWl >> 8) & 0xFF)]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x01A8
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x01A8 << 8) | (($Vg::FTWl >> 16) & 0xFF)]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x01A9
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x01A9 << 8) | (($Vg::FTWl >> 24) & 0xFF)]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x01AA
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x01AA << 8) | ($Vg::FTWh & 0xFF)]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x01AB
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x01AB << 8) | (($Vg::FTWh >> 8) & 0xFF)]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS IO UPDATE
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x0005 << 8) | 0x01] 
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer    
    
    close $serial
}

proc VgAVD2::LoadRFAttRegisters {} {
    global CPLD_ADR_FUNC_WR CPLD_ADR_ATT1_CTL_WR CPLD_ADR_ATT2_CTL_WR CPLD_ADR_ATT3_CTL_WR CPLD_ADR_ATT_RFINATT_WR CPLD_ADR_ATT_RFINLNA_WR CPLD_ADR_PLL_WR CPLD_ADR_DDS_WR CPLD_ADR_DET_ADC_RD

    if {[VgCOM::open_channel serial]} then {return 1}
        
#   ATT_RFINATT register
    set data [expr (0x$CPLD_ADR_ATT_RFINATT_WR << 8) | ($Vg::reg_att_rfinatt_cal & 0x1F)]
    VgCOM::put_channel $serial [format "%04X" $data] 0 answer

#   ATT_RFINLNA register
    set data [expr (0x$CPLD_ADR_ATT_RFINLNA_WR << 8) | ($Vg::reg_att_rfinlna_cal & 0x1F)]
    VgCOM::put_channel $serial [format "%04X" $data] 0 answer

#   ATT1_CTL register
    set data [expr (0x$CPLD_ADR_ATT1_CTL_WR << 8) | ($Vg::reg_att1 & 0x1F)]
    VgCOM::put_channel $serial [format "%04X" $data] 0 answer
    
#   ATT2_CTL register
    set data [expr (0x$CPLD_ADR_ATT2_CTL_WR << 8) | ($Vg::reg_att2 & 0x1F)]
    VgCOM::put_channel $serial [format "%04X" $data] 0 answer
    
#   ATT3_CTL register
    set data [expr (0x$CPLD_ADR_ATT3_CTL_WR << 8) | ($Vg::reg_att3 & 0x1F)]
    VgCOM::put_channel $serial [format "%04X" $data] 0 answer
    
    close $serial
}

proc VgAVD2::LoadIFRegisters {} {
    global CPLD_ADR_FUNC_WR CPLD_ADR_ATT1_CTL_WR CPLD_ADR_ATT2_CTL_WR CPLD_ADR_ATT3_CTL_WR CPLD_ADR_ATT_RFINATT_WR CPLD_ADR_ATT_RFINLNA_WR CPLD_ADR_PLL_WR CPLD_ADR_DDS_WR CPLD_ADR_DET_ADC_RD

    if {[VgCOM::open_channel serial]} then {return 1}
        
#   SW1 register
    set data [VgAVD2::GetSW1reg $Vg::iq_flt]
    VgCOM::put_channel $serial $data 0 answer

#   SW2 register
    set data [VgAVD2::GetSW2reg $Vg::iq_flt]    
    VgCOM::put_channel $serial $data 0 answer  
    
#   I DAC offset
    set data [VgAVD2::Calculate_D_Ioffset [expr $Vg::i_offset/1000.0]]
    set Vg::i_offset [VgAVD2::Calculate_V_Ioffset $data]
    set data [VgAVD2::GetDACreg $data i_offset 1 0]
    VgCOM::put_channel $serial $data 0 answer
    
#   Q DAC offset
    set data [VgAVD2::Calculate_D_Qoffset [expr $Vg::q_offset/1000.0]]
    set Vg::q_offset [VgAVD2::Calculate_V_Qoffset $data]    
    set data [VgAVD2::GetDACreg $data q_offset 1 0]    
    VgCOM::put_channel $serial $data 0 answer
    
#   IF gain offset
    set data [VgAVD2::Calculate_D_if_gain_offset [expr $Vg::if_gain_offset]]
    set Vg::if_gain_offset [VgAVD2::Calculate_G_if_gain_offset $data]      
    set data [VgAVD2::GetDACreg $data if_gain_offset 1 0]     
    VgCOM::put_channel $serial $data 0 answer
    
#   IF gain
    set data [VgAVD2::Calculate_D_if_gain [expr $Vg::if_gain]]
    set data [VgAVD2::GetDACreg $data if_gain 1 0]
    VgCOM::put_channel $serial $data 0 answer

    
    close $serial
}

proc VgAVD2::LoadAllRegisters {} {
    global CPLD_ADR_FUNC_WR CPLD_ADR_ATT1_CTL_WR CPLD_ADR_ATT2_CTL_WR CPLD_ADR_ATT3_CTL_WR CPLD_ADR_ATT_RFINATT_WR CPLD_ADR_ATT_RFINLNA_WR CPLD_ADR_PLL_WR CPLD_ADR_DDS_WR CPLD_ADR_DET_ADC_RD

    if {[VgCOM::open_channel serial]} then {return 1}
        
#   ATT_RFINATT register
    set data [expr (0x$CPLD_ADR_ATT_RFINATT_WR << 8) | ($Vg::reg_att_rfinatt_cal & 0x1F)]
    VgCOM::put_channel $serial [format "%04X" $data] 0 answer

#   ATT_RFINLNA register
    set data [expr (0x$CPLD_ADR_ATT_RFINLNA_WR << 8) | ($Vg::reg_att_rfinlna_cal & 0x1F)]
    VgCOM::put_channel $serial [format "%04X" $data] 0 answer

#   ATT1_CTL register
    set data [expr (0x$CPLD_ADR_ATT1_CTL_WR << 8) | ($Vg::reg_att1 & 0x1F)]
    VgCOM::put_channel $serial [format "%04X" $data] 0 answer
    
#   ATT2_CTL register
    set data [expr (0x$CPLD_ADR_ATT2_CTL_WR << 8) | ($Vg::reg_att2 & 0x1F)]
    VgCOM::put_channel $serial [format "%04X" $data] 0 answer
    
#   ATT3_CTL register
    set data [expr (0x$CPLD_ADR_ATT3_CTL_WR << 8) | ($Vg::reg_att3 & 0x1F)]
    VgCOM::put_channel $serial [format "%04X" $data] 0 answer
    
#   FUNC register
    set out_en 0
    set data [expr (0x$CPLD_ADR_FUNC_WR << 8) | ($out_en << 5) | (($Vg::band & 0x3) << 3) | (($Vg::lna_en & 0x1) << 2) | (($Vg::extref_en & 0x1) << 1) | ($Vg::pwr_en & 0x1)]
    Vg::LogLine "extref_en: $Vg::extref_en"
    Vg::LogLine "data: $data"
    VgCOM::put_channel $serial [format "%04X" $data] 1 answer

#   out en
    set out_en 1
    set data [expr (0x$CPLD_ADR_FUNC_WR << 8) | ($out_en << 5) | (($Vg::band & 0x3) << 3) | (($Vg::lna_en & 0x1) << 2) | (($Vg::extref_en & 0x1) << 1) | ($Vg::pwr_en & 0x1)] 
    VgCOM::put_channel $serial [format "%04X" $data] 1 answer

#   PLL R
    set data [expr (0x$CPLD_ADR_PLL_WR << 24) | ($Vg::REG_R_PLL & 0xFFFFFF)]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   PLL FUNC
    set data [expr (0x$CPLD_ADR_PLL_WR << 24) | ($Vg::REG_Func_PLL & 0xFFFFFF)]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   PLL N
    set data [expr (0x$CPLD_ADR_PLL_WR << 24) | ($Vg::REG_N_PLL & 0xFFFFFF)]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS RESET
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x0012 << 8) | 0x01]    
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS IO UPDATE
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x0005 << 8) | 0x01]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x0000
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x0000 << 8) | 0x80]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x0010  0x90
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x0010 << 8) | 0x90]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x040B
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x040B << 8) | 0xFF]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x040C
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x040C << 8) | 0x03]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x01A6
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x01A6 << 8) | ($Vg::FTWl & 0xFF)]    
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x01A7
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x01A7 << 8) | (($Vg::FTWl >> 8) & 0xFF)]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x01A8
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x01A8 << 8) | (($Vg::FTWl >> 16) & 0xFF)]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x01A9
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x01A9 << 8) | (($Vg::FTWl >> 24) & 0xFF)]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x01AA
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x01AA << 8) | ($Vg::FTWh & 0xFF)]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS 0x01AB
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x01AB << 8) | (($Vg::FTWh >> 8) & 0xFF)]
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   DDS IO UPDATE
    set data [expr (0x$CPLD_ADR_DDS_WR << 24) | (0x0005 << 8) | 0x01] 
    VgCOM::put_channel $serial [format "%08X" $data] 0 answer
    
#   SW1 register
    set data [VgAVD2::GetSW1reg $Vg::iq_flt]
    VgCOM::put_channel $serial $data 0 answer

#   SW2 register
    set data [VgAVD2::GetSW2reg $Vg::iq_flt]    
    VgCOM::put_channel $serial $data 0 answer  
    
#   I DAC offset
    set data [VgAVD2::Calculate_D_Ioffset [expr $Vg::i_offset/1000.0]]
    set Vg::i_offset [VgAVD2::Calculate_V_Ioffset $data]
    set data [VgAVD2::GetDACreg $data i_offset 1 0]
    VgCOM::put_channel $serial $data 0 answer
    
#   Q DAC offset
    set data [VgAVD2::Calculate_D_Qoffset [expr $Vg::q_offset/1000.0]]
    set Vg::q_offset [VgAVD2::Calculate_V_Qoffset $data]    
    set data [VgAVD2::GetDACreg $data q_offset 1 0]    
    VgCOM::put_channel $serial $data 0 answer
    
#   IF gain offset
    set data [VgAVD2::Calculate_D_if_gain_offset [expr $Vg::if_gain_offset]]
    set Vg::if_gain_offset [VgAVD2::Calculate_G_if_gain_offset $data]      
    set data [VgAVD2::GetDACreg $data if_gain_offset 1 0]     
    VgCOM::put_channel $serial $data 0 answer
    
#   IF gain
    set data [VgAVD2::Calculate_D_if_gain [expr $Vg::if_gain]]
    set data [VgAVD2::GetDACreg $data if_gain 1 0]
    VgCOM::put_channel $serial $data 0 answer

    close $serial  
}

proc VgAVD2::ReadTempRegisters {} {
    global CPLD_ADR_FUNC_WR CPLD_ADR_ATT1_CTL_WR CPLD_ADR_ATT2_CTL_WR CPLD_ADR_ATT3_CTL_WR CPLD_ADR_ATT_RFINATT_WR CPLD_ADR_ATT_RFINLNA_WR CPLD_ADR_PLL_WR CPLD_ADR_DDS_WR CPLD_ADR_DET_ADC_RD

    if {[VgCOM::open_channel serial]} then {return 1}

#   Temperature
    set channel 1
    set data [expr (0x$CPLD_ADR_DET_ADC_RD << 16) | ($channel << 14) | ($channel << 13)]
    VgCOM::put_channel $serial [format "%06X" $data] 0 answer
    VgCOM::put_channel $serial [format "%06X" $data] 0 answer    

    set voltage [expr (3.3*(0x$answer & 0xFFF))/4096.0]
    set temperature [expr 500*($voltage-0.6)+27]

    set Vg::temperature [format "%.1f" $temperature]     
    
    
    close $serial
    
}

proc VgAVD2::ReadPowerRegisters {show} {
    global CPLD_ADR_FUNC_WR CPLD_ADR_ATT1_CTL_WR CPLD_ADR_ATT2_CTL_WR CPLD_ADR_ATT3_CTL_WR CPLD_ADR_ATT_RFINATT_WR CPLD_ADR_ATT_RFINLNA_WR CPLD_ADR_PLL_WR CPLD_ADR_DDS_WR CPLD_ADR_DET_ADC_RD

    if {[VgCOM::open_channel serial]} then {return 1}
# RF power    
    set channel 0
    set data [expr (0x$CPLD_ADR_DET_ADC_RD << 16) | ($channel << 14) | ($channel << 13)]
    VgCOM::put_channel $serial [format "%06X" $data] 0 answer
    set answer 0
    for {set i 0} {$i<8} {incr i} {
        VgCOM::put_channel $serial [format "%06X" $data] 0 answer1
        set answer [expr $answer+0x$answer1]
    }
    set answer [format "%03X" [expr $answer / 8]]
    
    if {$show == 1} {
        Vg::LogLine "answer: 0x$answer"
        Vg::LogLine "answer: [expr 0x$answer & 0xFFF]"
    }
    set voltage [expr (3.3*(0x$answer & 0xFFF))/4096.0]
    if {$show == 1} {
        Vg::LogLine "voltage: $voltage"
    }
    set answer [expr 0x$answer & 0xFFF]
    
    variable power -200;
    VgAVD2::CalculatePower power $answer $Vg::frin $Vg::calibration_det_data $show
    
#    set rf_power [expr $voltage/$Vg::pm_slope+$Vg::pm_intercept]
    set Vg::pmeasure [format "%.1f" $power]
    if {$show == 1} {
        Vg::LogLine "rf_power: $Vg::pmeasure"    
    }
    
    close $serial
    
}
proc VgAVD2::OnRFinLNA {} {
    global CPLD_ADR_FUNC_WR CPLD_ADR_ATT1_CTL_WR CPLD_ADR_ATT2_CTL_WR CPLD_ADR_ATT3_CTL_WR CPLD_ADR_ATT_RFINATT_WR CPLD_ADR_ATT_RFINLNA_WR CPLD_ADR_PLL_WR CPLD_ADR_DDS_WR CPLD_ADR_DET_ADC_RD

    if {[VgCOM::open_channel serial]} then {return 1}
    set out_en 1
    set data [expr (0x$CPLD_ADR_FUNC_WR << 8) | ($out_en << 5) | (($Vg::band & 0x3) << 3) | (1 << 2) | (($Vg::extref_en & 0x1) << 1) | ($Vg::pwr_en & 0x1)] 
    VgCOM::put_channel $serial [format "%04X" $data] 1 answer
    close $serial
}

proc VgAVD2::OffRFinLNA {} {
    global CPLD_ADR_FUNC_WR CPLD_ADR_ATT1_CTL_WR CPLD_ADR_ATT2_CTL_WR CPLD_ADR_ATT3_CTL_WR CPLD_ADR_ATT_RFINATT_WR CPLD_ADR_ATT_RFINLNA_WR CPLD_ADR_PLL_WR CPLD_ADR_DDS_WR CPLD_ADR_DET_ADC_RD

    if {[VgCOM::open_channel serial]} then {return 1}
    set out_en 1
    set data [expr (0x$CPLD_ADR_FUNC_WR << 8) | ($out_en << 5) | (($Vg::band & 0x3) << 3) | (0 << 2) | (($Vg::extref_en & 0x1) << 1) | ($Vg::pwr_en & 0x1)] 
    VgCOM::put_channel $serial [format "%04X" $data] 1 answer
    close $serial
}

proc VgAVD2::ButtonReadTemp {} {
    #Vg::LogLine "Nothing to do !"
    
    #set filename "F:\\Temp\\TCL\\AVD2\\_flash\\_read_data_file.hex"
    #set data [VgFile::GetDataFromHex $filename 256 32]
    #Vg::LogLine "data: $data"
    #
    #set data [VgFile::GetDataFromHex $filename 288 46]
    #Vg::LogLine "data: $data"    
    #
    #set data [VgFile::GetDataFromHex $filename 334 32]
    #Vg::LogLine "data: $data"
    VgAVD2::ReadTempRegisters
    
}

proc VgAVD2::ButtonReadPower {} {
#    Vg::LogLine "Nothing to do !"
    VgAVD2::ReadPowerRegisters 1
    
}