#!/bin/sh
# The next line is executed by /bin/sh, but not tcl \
exec wish "$0" ${1+"$@"}

lappend auto_path /bwidget1_8/
lappend auto_path /

package require BWidget
    set EXE_COMPILE 0

    set CMD_SS0_LOW 02
    set CMD_SS0_HIGH 03
    set CMD_SS1_LOW 04
    set CMD_SS1_HIGH 05    
    
    set CMD_SPI0 86
    set CMD_SPI1 87
    
    set CMD_EMPTY C0
    set CMD_RUN C1
    
    set CMD_CTL_LOW 00
    set CMD_CTL_HIGH 01
    
    set CMD_RD_FL_P0 10
    set CMD_WR_FL_P0 11 

    set CMD_RD_FL_P1 20
    set CMD_WR_FL_P1 21

    set STR_DIDNT_RX_ANSWER "Didn't receive answer\nPlease check cable connection and device power supply"

    set FLASH_CMD_READ 03
    set FLASH_CMD_WRITE 02
    set FLASH_CMD_WREN 06
    set FLASH_CMD_WRDI 04
    set FLASH_CMD_RDSR 05
    set FLASH_CMD_WRSR 01
    set FLASH_CMD_PE 42
    set FLASH_CMD_SE D8
    set FLASH_CMD_CE C7
    set FLASH_CMD_RDID AB
    set FLASH_CMD_PDP B9
    
    set CPLD_ADR_FUNC_WR 01
    set CPLD_ADR_ATT_RFINATT_WR 02
    set CPLD_ADR_ATT_RFINLNA_WR 03
    set CPLD_ADR_ATT1_CTL_WR 04
    set CPLD_ADR_ATT2_CTL_WR 05
    set CPLD_ADR_ATT3_CTL_WR 06
    set CPLD_ADR_DDS_WR 07
    set CPLD_ADR_DAC_WR 08
    set CPLD_ADR_PLL_WR 09
    set CPLD_ADR_SW1_WR 0A
    set CPLD_ADR_SW2_WR 0B
    set CPLD_ADR_PLL_RD 81
    set CPLD_ADR_DET_ADC_RD 82
    
    
    set CPLD_ADR_WR_FLASH 10
    set CPLD_ADR_RD_FLASH 11

# 1048576
    set FLASH_SIZE 1048576
    
    set CONFIGBLKSIG AABBCCDD   
    set DATABLKSIG 99887766
    set ADR_DATABLK 0x00
    set ADR_CONFIGBLKSIG 0x00
    set MAX_ADR_CONFIG_BLOCK 0xFF


    set ADR_PID 0x04
    set ADR_SID 0x06
    set ADR_SN 0x08
    set ADR_LOT 0x0A    
    set ADR_DATE 0x0B
    set ADR_REF_FR 0x10
    set ADR_DATA_SIZE 0x14
    set ADR_FLASH_SIZE 0x18
    
    set ROWBLKSIG 5544
    set ENDOFFILE 00000001
    set ZERO_LINE 00000000000000000000000000000000
    
    set 2_POW_48 281474976710656
    set 2_POW_32 4294967296
    set 2_POW_16 65536    
    set DEFAULT_REF_CLK 100000000
    
namespace eval Vg {
    variable licence "Freeware";
    variable program_sw_version "1.0.1";
    variable device
    variable connector;
    variable busy 0;

    variable cmd_ss_low;
    variable cmd_ss_high;
    variable cmd_spi;
    variable cmd_wr_fl_p;
    variable cmd_rd_fl_p;

    set com_select [list COM1 COM2 COM3 COM4 COM5 COM6 COM7 COM8 COM9];
    set baund_select [list 110 300 1200 2400 4800 9600 19200 38400 57600 115200 230400 460800 921600];
    set databits_select [list 5 6 7 8]
    array set parity_select [list "none" n "odd" o "even" e "mark" m "space" s];
    set stopbits_select [list 1 2]    

    variable serialport    
    variable baundrate
    variable databits    
    variable parity    
    variable stopbits    
    
    variable init_done 0;
    variable band
    variable fvco
    variable FTWh
    variable FTWl
    variable frin 1000;
    variable pwr_en 1;
    variable extref_en 0;
    variable lna_en 0;
    variable lna_off_first 0;
    variable lna_on_last 0;
    variable manual_ctl_en 1;
    variable cont_update_en 0;
    variable pin 0;
    variable voutpp 1.0;
    variable pmeasure;
    variable p_mod 0;
    variable g_max_incr 5;
    variable pm_acc 1;
    variable lna_hyst 5;
    variable rf_gain;
    variable if_gain 4;
    variable Att;
    variable if_gain_offset 0;
    variable i_offset 0;
    variable q_offset 0;    
    variable iq_flt "100 MHz";
    
    variable a_i_dac 62600;
    variable b_i_dac 1980;
    variable a_q_dac 63450;
    variable b_q_dac 2325;
    
    variable a_if_gain_offset 3184;
    variable b_if_gain_offset 2300;    
    
    variable a_if_gain 130;
    variable b_if_gain 870;
# 558
    variable pout;
    variable temperature "N/A"
    
#    variable pm_slope;
#    variable pm_intercept;
#    variable v0 1.3817;
#    variable v1 0.8886;
#    variable p0 -20;
#    variable p1 0;

#    variable REG_Func_PLL
#    variable REG_R_PLL
#    variable REG_N_PLL
 
#    variable REG_R_PLL [expr 0x03300004]   
#    variable REG_Func_PLL [expr 0x031F8043]
#    variable REG_N_PLL [expr 0x03000101]

    variable REG_Func_PLL [expr 0x1F8002 | (0x1 << 4)];
    variable REG_N_PLL [expr (0x000001) | (1 << 8)];
    variable REG_R_PLL [expr (0x000000) | (1 << 2)]; 

    variable att1 0;  
    variable att2 0;    
    variable att3 0;
    variable att_rfinatt_cal 0;
    variable att_rfinlna_cal 0;    

    variable reg_att_rfinatt_cal [expr 0x0];
    variable reg_att_rfinlna_cal [expr 0x0];
    variable reg_att1 [expr 0x1F];
    variable reg_att2 [expr 0x1F];
    variable reg_att3 [expr 0x1F];
    variable cal_att_370_coef 1.0;
    variable cal_att_470_coef 1.0;
    
    variable gain_rfinatt 0;
    variable gain_rfinlna 45;
    variable gain_rfin;
    variable gain_fr;
    
    variable var_wel
    variable var_wip
    variable var_bp1
    variable var_bp0
    variable var_wpen
    variable adr_page_erase    
    variable adr_sec_erase    
    variable adr_wr_sector
    variable adr_rd_sector    
    variable data_wr_sector
    variable data_rd_sector       
    
    variable VARCONFIGFILENAME "./_config/config.ini";
    variable var_config_filename
    
    variable SCRIPTDIR
    variable DATAFILEDIR
    variable FLASHDIR
    variable default_calibration_det_data "cal_det.dat"
    variable default_calibration_rfinlna_att_data "cal_rfinlna_att.dat"
    variable default_calibration_rfinlna_gain_data "cal_rfinlna_gain.dat"    
    variable default_calibration_rfinatt_att_data "cal_rfinatt_att.dat"
    variable default_calibration_rfinatt_gain_data "cal_rfinatt_gain.dat"
    variable default_calibration_att370_data "cal_hmc370.dat"
    variable default_calibration_att470_data "cal_hmc470.dat"
    variable default_calibration_rfgain "cal_gain.dat"    
    
    variable default_program_data_filename "calibration.pak"
    variable program_data_filename
    variable default_data_dir "/_data/"
    variable default_flash_dir "/_flash/"
    variable calibration_det_data
    variable calibration_rfinlna_att_data
    variable calibration_rfinlna_gain_data    
    variable calibration_rfinatt_att_data
    variable calibration_rfinatt_gain_data
    variable calibration_att370_data
    variable calibration_att470_data
    variable calibration_rfgain
    variable read_data_filename
    variable read_config_filename
    variable TEMPDATAFILENAME "_temp_data_file.hex";
    variable DATAREADFILENAME "_read_data_file.hex";
    variable CONFIGREADFILENAME "_read_config_file.conf";
    variable DATAEXPORTFILENAME_AVD2 "_export_data_file_AVD2.dat"
    variable DATAEXPORTFILENAME_AVD2_LP "_export_data_file_AVD2_lp.dat"
    variable TEMPCONFIGFILENAME "_temp_config_file.conf"
    variable init_save_configfilename
    variable SAVECONFDIR;
    variable saveconfigfilename;
    
    
    variable date_dd
    variable date_mm
    variable date_yyyy
    variable device_pid 0;
    variable device_sid 10;
    variable device_sn 34955;
    variable device_lot 1;
    variable fr_1ghz
    variable fr_ref
    variable flash_ref_clk
    variable data_size 0;


    variable flt_list "";
    array set flt_array [list 0 "0.4 MHz" 1 "2 MHz" 2 "15 MHz" 3 "100 MHz"];
    
    namespace export LogLine;
    variable notebook
    variable mainframe
    variable status
    variable prgtext
    variable prgindic
    variable toolbar1 1
    variable var_progressbar 0;

}
proc Vg::DeviceSelect {} {
    
    set devseldlg [MainFrame .devseldlg -separator none ]
    $devseldlg showstatusbar none
    wm title . "Device select"
    wm minsize . 200 100
    wm resizable . 0 0
    set titf [TitleFrame $devseldlg.titf -text "Device select"];

    set rbone [radiobutton [$titf getframe].rbone -text "AVD2" -value "avd2" -variable Vg::device]
#    set rbtwo [radiobutton [$titf getframe].rbtwo -text "LNO_LP" -value "lno_lp" -variable Vg::device]
    $rbone select   
    pack $rbone -anchor "w"
    
    set selectbutton [button $devseldlg.select -text "Ok" \
                     -command Vg::DeviceSelectOk \
                     -width 12 ];

    pack $titf -padx 4 -pady "5 10" -fill both -expand yes;

    pack $devseldlg -fill both -expand yes -padx 10 -pady 10   

    pack $selectbutton -padx 4;

    BWidget::place . 0 0 center
    raise .
    focus -force .
}

proc Vg::create { } {
#    global tk_patchLevel
#    global softversion "1.0"
#    variable _wfont
    variable notebook
    variable mainframe
    variable logchart
    variable scrollchart    
    
#    variable font
    variable prgtext
    variable prgindic

#    Vg::DeviceSelect
    update
    set prgtext "Please wait while loading program..."
    set prgindic -1
    _create_intro
    update

#    bind all <F12> { catch {console show} }
    # Menu description
    set descmenu {
        "&File" all file 0 {
            {command "E&xit" {} "Exit" {} -command exit}
            {command "&Save preferences" {} "Save configuration" {} -command Vg::SavePreferences}
        }
        "&Setup" all file 0 {
            {command "COM &configure" {} "COM port configure" {} -command Vg::COMconfigure}
        }
        "&View" all file 0 {
            {command "&Clear chart log" {} "Clear chart log" {} -command Vg::ClearChart}
        }
        "&Help" all file 0 {
            {command "&About" {} "About" {} -command Vg::AboutDlg}
        }         
    }
    after 50
    set prgtext "Creating MainFrame..."
    set prgindic 0
    set mainframe [MainFrame .mainframe \
                       -menu         $descmenu \
                       -textvariable Vg::status \
                       -progressvar  Vg::prgindic]

    $mainframe addindicator -text "Advantex LLC Software"
#    $mainframe addindicator -textvariable softversion

    # NoteBook creation
    set frame [$mainframe getframe]
    set notebook [NoteBook $frame.nb]

    set prgtext "Creating ..."
    update  
    incr prgindic
    set f0 [VgAVD2::create $notebook]
    set prgtext   "Creating AVD2 configuration..."
    update
    after 50      
    incr prgindic
    set f3  [VgFlash::create $notebook]
    set prgtext   "Creating Flash configuration..."
    update
    after 50
    incr prgindic
    set f4  [VgConfig::create $notebook]
    set prgtext   "Creating Config configuration..."
    update
    after 50
    incr prgindic
    set f5  [VgProgram::create $notebook]
    set prgtext   "Creating Program configuration..."
    update
    after 50

    set logchart [text $frame.txt -height 15 -width 50 -yscrollcommand "$frame.scrolltxt set" -state disabled  -font "Courier 8"]
    set scrollchart [scrollbar $frame.scrolltxt -command "$logchart yview"]
    
    set prgtext   "Done"
    update
    incr prgindic
    $notebook compute_size
    pack $notebook -fill both -padx 4 -pady 4
    $notebook raise [$notebook page 0]

    pack $logchart $scrollchart -side left -fill both -pady 4
    pack $logchart -expand yes -padx "4 0"
    pack $scrollchart -padx "0 4"
    
    pack $mainframe -fill both -expand yes
    update idletasks

    Vg::Init;
    LogLine "Initialized... Ok";
    LogLine "Device are selected: $Vg::device";    
    after 50     
    destroy .intro
}

proc Vg::_create_intro { } {
    global EXE_COMPILE
    variable VgDIR
    
    set top [toplevel .intro -relief raised -borderwidth 2]

    wm withdraw $top
    wm overrideredirect $top 1

    if {$EXE_COMPILE == 0} {
        set ximg  [label $top.x -bitmap @$VgDIR/adv_logo.xbm \
                -foreground grey80 -background white]
    } else {
        set ximg  [label $top.x -bitmap @/adv_logo.xbm \
                -foreground grey80 -background white]
    }
    set frame [frame $ximg.f -background white]
    set lab1  [label $frame.lab1 -text "Loading..." \
	    -background white -font {times 8}]
    set lab2  [label $frame.lab2 -textvariable Vg::prgtext \
	    -background white -font {times 8} -width 35]
    set prg   [ProgressBar $frame.prg -width 200 -height 20 -background white \
	    -variable Vg::prgindic -maximum 7]
    pack $lab1 $lab2 $prg -expand yes
    pack configure $prg -pady "0 10"
    place $frame -x 0 -y 0 -relwidth 1.0

    pack $ximg
    BWidget::place $top 0 0 center
    wm deiconify $top
}

proc Vg::main {} {
    variable VgDIR

    lappend ::auto_path [file dirname $VgDIR]
    namespace inscope :: package require BWidget

    wm withdraw .
    switch $Vg::device {
        "avd2" {
            set str "Advantex LLC - AVD2"
        }
        default {
            set str "Advantex LLC"   
        }
    }
    
    wm title . $str
    wm minsize . 330 470
#    wm maxsize . 400 1000
#wm resizable . 0 1

    Vg::create
    BWidget::place . 0 0 center
    wm deiconify .
    raise .
    focus -force .

}

proc Vg::ClearChart {} {
    variable logchart;
    
    $logchart configure -state normal;
    $logchart delete 1.0 end;
    $logchart configure -state disabled;    
}

proc Vg::LogLine { str } {
    variable logchart;
    
    $logchart configure -state normal;
    $logchart insert end "$str\n";
    $logchart configure -state disabled;
    $logchart yview end;
}

proc Vg::Init {} {
    
    global CMD_SS0_LOW CMD_SS0_HIGH CMD_SPI0 CMD_SS1_LOW CMD_SS1_HIGH CMD_SPI1 CMD_RD_FL_P0 CMD_WR_FL_P0 CMD_RD_FL_P1 CMD_WR_FL_P1
    switch $Vg::connector {
        "conn1" {
            set Vg::cmd_ss_low $CMD_SS0_LOW
            set Vg::cmd_ss_high $CMD_SS0_HIGH            
            set Vg::cmd_spi $CMD_SPI0
            
            set Vg::cmd_rd_fl_p $CMD_RD_FL_P0
            set Vg::cmd_wr_fl_p $CMD_WR_FL_P0            

        }
        "conn2" {
            set Vg::cmd_ss_low $CMD_SS1_LOW
            set Vg::cmd_ss_high $CMD_SS1_HIGH            
            set Vg::cmd_spi $CMD_SPI1
            
            set Vg::cmd_rd_fl_p $CMD_RD_FL_P1
            set Vg::cmd_wr_fl_p $CMD_WR_FL_P1 
        }
        default {

        }
    }
    
#    wm withdraw .
    switch $Vg::device {
        "avd2" {
#            set Vg::DATAEXPORTFILENAME $Vg::DATAEXPORTFILENAME_LNO
            set Vg::device_pid 0
            set Vg::device_sid 10
            set Vg::device_sn 34955
        }

        default {

        }
    }
    
    set  Vg::var_config_filename $Vg::VARCONFIGFILENAME
    
###############################################################################################################################################
    if {[VgFile::GetVarValue Vg::serialport "serial_port" $Vg::var_config_filename]} {set Vg::serialport "COM1"}

    if {[VgFile::GetVarValue Vg::baundrate "serial_baund" $Vg::var_config_filename]} {set Vg::baundrate 19200}
    if {[VgFile::GetVarValue Vg::databits "serial_databits" $Vg::var_config_filename]} {set Vg::databits 8}
    if {[VgFile::GetVarValue Vg::parity "serial_parity" $Vg::var_config_filename]} {set Vg::parity "none"}
    if {[VgFile::GetVarValue Vg::stopbits "serial_stopbits" $Vg::var_config_filename]} {set Vg::stopbits 1}

##############################################################################################################################################
     
  

    set Vg::SCRIPTDIR [file dirname [info script]]
    set Vg::DATAFILEDIR $Vg::SCRIPTDIR
    append Vg::DATAFILEDIR $Vg::default_data_dir 
    set Vg::FLASHDIR $Vg::SCRIPTDIR
    append Vg::FLASHDIR $Vg::default_flash_dir    

    set Vg::program_data_filename $Vg::DATAFILEDIR
    append  Vg::program_data_filename $Vg::default_program_data_filename

    set Vg::calibration_det_data $Vg::DATAFILEDIR
    append  Vg::calibration_det_data $Vg::default_calibration_det_data
    
    set Vg::calibration_rfinlna_att_data $Vg::DATAFILEDIR
    append  Vg::calibration_rfinlna_att_data $Vg::default_calibration_rfinlna_att_data    

    set Vg::calibration_rfinlna_gain_data $Vg::DATAFILEDIR
    append  Vg::calibration_rfinlna_gain_data $Vg::default_calibration_rfinlna_gain_data
    
    set Vg::calibration_rfinatt_att_data $Vg::DATAFILEDIR
    append  Vg::calibration_rfinatt_att_data $Vg::default_calibration_rfinatt_att_data

    set Vg::calibration_rfinatt_gain_data $Vg::DATAFILEDIR
    append  Vg::calibration_rfinatt_gain_data $Vg::default_calibration_rfinatt_gain_data
    
    set Vg::calibration_att370_data $Vg::DATAFILEDIR
    append  Vg::calibration_att370_data $Vg::default_calibration_att370_data    
    
    set Vg::calibration_att470_data $Vg::DATAFILEDIR
    append  Vg::calibration_att470_data $Vg::default_calibration_att470_data     
    
    set Vg::calibration_rfgain $Vg::DATAFILEDIR
    append  Vg::calibration_rfgain $Vg::default_calibration_rfgain     
    
    
    set Vg::read_data_filename $Vg::FLASHDIR
    append  Vg::read_data_filename $Vg::DATAREADFILENAME
    set Vg::read_config_filename $Vg::FLASHDIR
    append  Vg::read_config_filename $Vg::CONFIGREADFILENAME  

    set Vg::init_save_configfilename $Vg::FLASHDIR
    
    set Vg::SAVECONFDIR $Vg::FLASHDIR
    
#    append Vg::init_save_configfilename  [format "%*d" $Vg::device_sn] ".conf"
    
    set Vg::var_wel 0
    set Vg::var_wip 0
    set Vg::var_bp1 0
    set Vg::var_bp0 0
    
    set Vg::adr_page_erase 00000
    set Vg::adr_sec_erase 00000
    set Vg::adr_wr_sector 00000
    set Vg::adr_rd_sector 00000
    set Vg::data_wr_sector 00
    set Vg::data_rd_sector
    
    set date [clock seconds]
    set Vg::date_dd [clock format $date -format %d ]
    set Vg::date_mm [clock format $date -format %m ]    
    set Vg::date_yyyy [clock format $date -format %Y ] 

    set Vg::fr_1ghz 1000.000
    set Vg::fr_ref 100.0
    set Vg::flash_ref_clk [format "%.0f" [expr $Vg::fr_1ghz*$Vg::fr_ref*1000]]

    set Vg::att1 [expr $Vg::reg_att1]
    set Vg::att2 [expr $Vg::reg_att2]
    set Vg::att3 [expr 0.25*$Vg::reg_att3]   
    set Vg::att_rfinatt_cal [expr 0.25*$Vg::reg_att_rfinatt_cal]
    set Vg::att_rfinlna_cal [expr 0.25*$Vg::reg_att_rfinlna_cal]

    set Vg::pout [format "%.2f" [expr 10*log10(10*$Vg::voutpp*$Vg::voutpp/4.0)]]     
    
    set Vg::fr_ref 100.0

}

proc Vg::COMconfigure {} {
    
    set dlg [Dialog .comselectdlg -parent . -modal local \
                 -separator false \
                 -title   "COM port configure" \
                 -side    bottom    \
                 -anchor  e  \
                 -default 0 -cancel 1];
    set titf [TitleFrame [$dlg getframe].titf -text "Setup"];
    
    set titf1 [frame [$titf getframe].titf1]
    set titf2 [frame [$titf getframe].titf2]
    set titf3 [frame [$titf getframe].titf3]
    set titf4 [frame [$titf getframe].titf4]
    set titf5 [frame [$titf getframe].titf5]

    set comcombo [ComboBox $titf1.comcombo -textvariable Vg::serialport \
                     -editable false -values $Vg::com_select \
                     -width 6 ];
    set combobaund [ComboBox $titf2.combobaund -textvariable Vg::baundrate \
                     -editable false -values $Vg::baund_select \
                     -width 6 ];

    set combodatabits [ComboBox $titf3.combodatabits -textvariable Vg::databits \
                     -editable false -values $Vg::databits_select \
                     -width 6 ];

    set comboparity [ComboBox $titf4.comboparity -textvariable Vg::parity \
                     -editable false -values [array names Vg::parity_select] \
                     -width 6 ];
    
    set labelcom [label $titf1.labelcom -text "COM port select:"];
    set labelbaund [label $titf2.labelbaund -text "Bits per second:"];    
    set labeldatabits [label $titf3.labeldatabits -text "Data bits:"];      
    set labelparity [label $titf4.labelparity -text "Parity:"];    
    set labelstopbits [label $titf5.labelstopbits -text "Stop bits:"];

    pack $comcombo $labelcom -padx 4 -fill both -side right;
    pack $combobaund $labelbaund -padx 4 -fill both -side right;
    pack $combodatabits $labeldatabits -padx 4 -fill both -side right;    
    pack $comboparity $labelparity -padx 4 -fill both -side right;
    
    pack $titf1 $titf2 $titf3 $titf4 $titf5 -padx 4 -pady 10 -fill both -anchor e;    
    pack $titf -padx 4 -fill both -expand yes;

    $dlg add -name ok;
    $dlg add -name cancel;
    
    $dlg draw;

    destroy $dlg

}

proc Vg::AboutDlg {} {
    
}

## Some startup code that runs after everything is defined
namespace eval Vg {
    global EXE_COMPILE
    set pwd [pwd]
    cd [file dirname [info script]]
    variable VgDIR [pwd]
#    variable VgDIR;
#    set VgDIR "";
    cd $pwd
    if {$EXE_COMPILE == 0} {
        foreach script {
            avd2.tcl com.tcl flash.tcl config.tcl program.tcl file.tcl crc.tcl dlg.tcl
        } {
            namespace inscope :: source $VgDIR/$script
        }
    } else {
        foreach script {
            avd2.tcl com.tcl flash.tcl config.tcl program.tcl file.tcl crc.tcl dlg.tcl
        } {
            namespace inscope :: source "/$script"
        }
    }

}

proc Vg::FlashConfigure { } {
    set dlg [Dialog .flash_dlg -parent . -modal local \
                 -separator false \
                 -title   "Flash configuration" \
                 -side    bottom    \
                 -anchor  e  \
                 -default 2 -cancel 2]
  
    set titf [TitleFrame  $dlg.titf -text "Flash"]; 
    
    flash_dlg  [$titf getframe]

    pack $titf -padx 4 -pady 4 -fill both;

    $dlg draw
    destroy $dlg
}

proc Vg::flash_dlg { root } {
    set base [expr {($root == ".") ? "" : $root}]
    variable ROOT $root
    variable BASE $base
    variable SCRIPTDIR ; # defined in main script

}

proc Vg::OnProgressBar {max} {
    if {$max <= 0} {set max 1}
    .mainframe configure -progressvar Vg::var_progressbar -progressmax $max
    .mainframe showstatusbar progression    
}

proc Vg::OffProgressBar {} {
    .mainframe showstatusbar status
    update
}

proc Vg::DeviceSelectOk {} {  
    destroy .devseldlg
    wm resizable . 1 1
    Vg::main
    wm geom . [wm geom .]  
}

proc Vg::AboutDlg {} {
    VgDlg::About    
}

proc Vg::SavePreferences {} {

    set data_list "";

    set str [list "#" "<-comment here"]
    lappend data_list $str  

    set str [list "serial_port" $Vg::serialport]
    lappend data_list $str    

    set str [list "serial_baund" $Vg::baundrate]
    lappend data_list $str

    set str [list "serial_databits" $Vg::databits]
    lappend data_list $str

    set str [list "serial_parity" $Vg::parity]
    lappend data_list $str

    set str [list "serial_stopbits" $Vg::stopbits]
    lappend data_list $str    

    #set str [list "lno_freq" $Vg::frout]
    #lappend data_list $str
    #
    #set str [list "lno_pout" $Vg::poutdbm]
    #lappend data_list $str
    #
    #set str [list "refclk_en" $Vg::refclk_en]
    #lappend data_list $str
    #
    #set str [list "lno_out_amp_en" $Vg::outampen]
    #lappend data_list $str

    if {[VgFile::SavePreferences2File $data_list $Vg::var_config_filename]} {
        Vg::LogLine "Can't save preferences to file:\n$Vg::var_config_filename"
    } else {
        Vg::LogLine "Preferences are saved successfully to file:\n$Vg::var_config_filename"
    }
}


proc Vg::DeviceSelect {} {
    
    set devseldlg [MainFrame .devseldlg -separator none ]
    $devseldlg showstatusbar none
    wm title . "Device select"
    wm minsize . 200 100
    wm resizable . 0 0
    set titf [TitleFrame $devseldlg.titf -text "Device select"];
    set device_rbone [radiobutton [$titf getframe].device_rbone -text "AVD2" -value "avd2" -variable Vg::device]
    
    set titf_conn [TitleFrame $devseldlg.titf_conn -text "Connector select"];
    set conn_rbone [radiobutton [$titf_conn getframe].conn_rbone -text "Connector1" -value "conn1" -variable Vg::connector]
    set conn_rbtwo [radiobutton [$titf_conn getframe].conn_rbtwo -text "Connector2" -value "conn2" -variable Vg::connector]    
    
    $device_rbone select
    $conn_rbone select
    
    pack $device_rbone -anchor "w"

    pack $conn_rbone $conn_rbtwo -anchor "w"
    
    set selectbutton [button $devseldlg.select -text "Ok" \
                     -command Vg::DeviceSelectOk \
                     -width 12 ];

    pack $titf $titf_conn -padx 4 -pady "5 10" -fill both -expand yes;

    pack $devseldlg -fill both -expand yes -padx 10 -pady 10   

    pack $selectbutton -padx 4;

    BWidget::place . 0 0 center
    raise .
    focus -force .
}


proc Vg::DeviceSelectOk {} {

    destroy .devseldlg
    wm resizable . 1 1
    Vg::main
    wm geom . [wm geom .]
}


Vg::DeviceSelect